/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.ImmutableByteArray;
import com.ibm.wala.util.strings.StringStuff;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.util.Map;

public final class TypeName
implements Serializable {
    public static final byte ArrayMask = 1;
    public static final byte PointerMask = 2;
    public static final byte ReferenceMask = 3;
    public static final byte PrimitiveMask = 4;
    public static final byte ElementMask = 7;
    public static final byte ElementBits = 3;
    private static final long serialVersionUID = -3256390509887654326L;
    private static final Map<TypeNameKey, TypeName> map = HashMapFactory.make();
    private final TypeNameKey key;

    private static synchronized TypeName findOrCreate(TypeNameKey t) {
        TypeName result = map.get(t);
        if (result == null) {
            result = new TypeName(t);
            map.put(t, result);
        }
        return result;
    }

    public static TypeName findOrCreate(ImmutableByteArray name, int start, int length) throws IllegalArgumentException {
        Atom className = Atom.findOrCreate(StringStuff.parseForClass(name, start, length));
        ImmutableByteArray p = StringStuff.parseForPackage(name, start, length);
        Atom packageName = p == null ? null : Atom.findOrCreate(p);
        int dim = StringStuff.parseForArrayDimensionality(name, start, length);
        boolean innermostPrimitive = StringStuff.classIsPrimitive(name, start, length);
        if (innermostPrimitive) {
            if (dim == 0) {
                dim = -1;
            } else {
                dim <<= 3;
                dim |= 4;
            }
        }
        TypeNameKey t = new TypeNameKey(packageName, className, dim);
        return TypeName.findOrCreate(t);
    }

    public static TypeName findOrCreate(ImmutableByteArray name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return TypeName.findOrCreate(name, 0, name.length());
    }

    public static TypeName findOrCreate(String name) throws IllegalArgumentException {
        ImmutableByteArray b = ImmutableByteArray.make(name);
        return TypeName.findOrCreate(b);
    }

    public static TypeName findOrCreateClass(Atom packageName, Atom className) {
        if (packageName == null) {
            throw new IllegalArgumentException("null packageName");
        }
        if (className == null) {
            throw new IllegalArgumentException("null className");
        }
        TypeNameKey T = new TypeNameKey(packageName, className, 0);
        return TypeName.findOrCreate(T);
    }

    public static TypeName findOrCreate(Atom packageName, Atom className, int dim) {
        TypeNameKey T = new TypeNameKey(packageName, className, dim);
        return TypeName.findOrCreate(T);
    }

    private TypeName(TypeNameKey key) {
        this.key = key;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key.toString();
    }

    public String toUnicodeString() {
        return this.key.toUnicodeString();
    }

    public static TypeName string2TypeName(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        byte[] val = s.getBytes();
        return TypeName.findOrCreate(new ImmutableByteArray(val));
    }

    public static TypeName findOrCreateClassName(String packageName, String className) {
        Atom p = Atom.findOrCreateUnicodeAtom(packageName);
        Atom c = Atom.findOrCreateUnicodeAtom(className);
        return TypeName.findOrCreateClass(p, c);
    }

    public TypeName parseForArrayElementName() {
        int tmpDim;
        int newDim = (this.key.dim & 7) == 4 ? ((tmpDim = this.key.dim >> 6) == 0 ? -1 : tmpDim << 3 | 4) : this.key.dim >> 3;
        return TypeName.findOrCreate(this.key.packageName, this.key.className, newDim);
    }

    private TypeName getDerivedTypeForElementType(byte mask) {
        int newDim = this.key.dim == -1 ? mask << 3 | 4 : ((this.key.dim & 7) == 4 ? (this.key.dim & 0xFFFFFFF8 | mask) << 3 | 4 : this.key.dim << 3 | mask);
        return TypeName.findOrCreate(this.key.packageName, this.key.className, newDim);
    }

    public TypeName getArrayTypeForElementType() {
        return this.getDerivedTypeForElementType((byte)1);
    }

    public TypeName getPointerTypeForElementType() {
        return this.getDerivedTypeForElementType((byte)2);
    }

    public TypeName getReferenceTypeForElementType() {
        return this.getDerivedTypeForElementType((byte)3);
    }

    public final int getDerivedMask() {
        return this.key.dim;
    }

    public final boolean isClassType() {
        return this.key.dim == 0;
    }

    public final boolean isArrayType() {
        return this.key.dim > 0;
    }

    public final boolean isPrimitiveType() {
        return this.key.dim == -1;
    }

    public final TypeName getInnermostElementType() {
        int newDim = (this.key.dim & 7) == 4 ? -1 : 0;
        return TypeName.findOrCreate(this.key.packageName, this.key.className, newDim);
    }

    public Atom getPackage() {
        return this.key.packageName;
    }

    public Atom getClassName() {
        return this.key.className;
    }

    private static final class TypeNameKey
    implements Serializable {
        private final Atom packageName;
        private final Atom className;
        private final int dim;

        private TypeNameKey(Atom packageName, Atom className, int dim) {
            this.packageName = packageName;
            this.className = className;
            this.dim = dim;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeNameKey) {
                TypeNameKey other = (TypeNameKey)obj;
                return this.className == other.className && this.packageName == other.packageName && this.dim == other.dim;
            }
            return false;
        }

        public int hashCode() {
            int result = this.className.hashCode() * 5009 + this.dim * 5011;
            if (this.packageName != null) {
                result += this.packageName.hashCode();
            }
            return result;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            this.toStringPrefix(result);
            if (this.packageName != null) {
                result.append(this.packageName.toString());
                result.append("/");
            }
            result.append(this.className.toString());
            return result.toString();
        }

        private void toStringPrefix(StringBuffer result) {
            boolean isPrimitive;
            boolean bl = isPrimitive = this.dim == -1 || (this.dim & 7) == 4;
            if (this.dim != -1) {
                int d = (this.dim & 7) == 4 ? this.dim >> 3 : this.dim;
                while (d != 0) {
                    switch (d & 7) {
                        case 1: {
                            result.append("[");
                            break;
                        }
                        case 2: {
                            result.append("*");
                            break;
                        }
                        case 3: {
                            result.append("&");
                        }
                    }
                    d >>= 3;
                }
            }
            if (!isPrimitive) {
                result.append("L");
            } else if (this.packageName != null && isPrimitive) {
                result.append("P");
            }
        }

        public String toUnicodeString() {
            try {
                StringBuffer result = new StringBuffer();
                this.toStringPrefix(result);
                if (this.packageName != null) {
                    result.append(this.packageName.toUnicodeString());
                    result.append("/");
                }
                result.append(this.className.toUnicodeString());
                return result.toString();
            }
            catch (UTFDataFormatException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
                return null;
            }
        }
    }
}

