/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import java.util.Arrays;

public class SSAPhiInstruction
extends SSAInstruction {
    private final int result;
    private int[] params;

    public SSAPhiInstruction(int iindex, int result, int[] params) throws IllegalArgumentException {
        super(iindex);
        if (params == null) {
            throw new IllegalArgumentException("params is null");
        }
        this.result = result;
        this.params = params;
        if (params.length == 0) {
            throw new IllegalArgumentException("can't have phi with no params");
        }
        int[] nArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            if (p == 0) {
                throw new IllegalArgumentException("zero is an invalid value number for a parameter to phi");
            }
            ++n2;
        }
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) throws IllegalArgumentException {
        if (defs != null && defs.length == 0) {
            throw new IllegalArgumentException();
        }
        return insts.PhiInstruction(this.iindex, defs == null ? this.result : defs[0], uses == null ? this.params : uses);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        StringBuffer s = new StringBuffer();
        s.append(this.getValueString(symbolTable, this.result)).append(" = phi ");
        s.append(" ").append(this.getValueString(symbolTable, this.params[0]));
        int i = 1;
        while (i < this.params.length) {
            s.append(",").append(this.getValueString(symbolTable, this.params[i]));
            ++i;
        }
        return s.toString();
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitPhi(this);
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef() {
        return this.result;
    }

    @Override
    public int getDef(int i) {
        if (i != 0) {
            throw new IllegalArgumentException("invalid i: " + i);
        }
        return this.result;
    }

    @Override
    public int getNumberOfUses() {
        return this.params.length;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    @Override
    public int getUse(int j) throws IllegalArgumentException {
        if (j >= this.params.length || j < 0) {
            throw new IllegalArgumentException("Bad use " + j);
        }
        return this.params[j];
    }

    public void setValues(int[] i) {
        if (i == null || i.length < 1) {
            throw new IllegalArgumentException("illegal i: " + Arrays.toString(i));
        }
        this.params = i;
    }

    @Override
    protected String getValueString(SymbolTable symbolTable, int valueNumber) {
        if (valueNumber == -1) {
            return "TOP";
        }
        return super.getValueString(symbolTable, valueNumber);
    }

    @Override
    public int hashCode() {
        return 7823 * this.result;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }
}

