/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.shrikeBT.BytecodeConstants;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLMethodSummaryReader
implements BytecodeConstants {
    static final boolean DEBUG = false;
    private final AnalysisScope scope;
    private final HashMap<MethodReference, MethodSummary> summaries = HashMapFactory.make();
    private final HashSet<TypeReference> allocatable = HashSetFactory.make();
    private final HashSet<Atom> ignoredPackages = HashSetFactory.make();
    private static final int E_CLASSLOADER = 0;
    private static final int E_METHOD = 1;
    private static final int E_CLASS = 2;
    private static final int E_PACKAGE = 3;
    private static final int E_CALL = 4;
    private static final int E_NEW = 5;
    private static final int E_POISON = 6;
    private static final int E_SUMMARY_SPEC = 7;
    private static final int E_RETURN = 8;
    private static final int E_PUTSTATIC = 9;
    private static final int E_AASTORE = 10;
    private static final int E_PUTFIELD = 11;
    private static final int E_GETFIELD = 12;
    private static final int E_ATHROW = 13;
    private static final int E_CONSTANT = 14;
    private static final int E_AALOAD = 15;
    private static final Map<String, Integer> elementMap = HashMapFactory.make((int)14);
    private static final String A_NAME = "name";
    private static final String A_TYPE = "type";
    private static final String A_CLASS = "class";
    private static final String A_SIZE = "size";
    private static final String A_DESCRIPTOR = "descriptor";
    private static final String A_REASON = "reason";
    private static final String A_LEVEL = "level";
    private static final String A_WILDCARD = "*";
    private static final String A_DEF = "def";
    private static final String A_STATIC = "static";
    private static final String A_VALUE = "value";
    private static final String A_FIELD = "field";
    private static final String A_FIELD_TYPE = "fieldType";
    private static final String A_ARG = "arg";
    private static final String A_ALLOCATABLE = "allocatable";
    private static final String A_REF = "ref";
    private static final String A_INDEX = "index";
    private static final String A_IGNORE = "ignore";
    private static final String A_FACTORY = "factory";
    private static final String A_NUM_ARGS = "numArgs";
    private static final String V_NULL = "null";
    private static final String V_TRUE = "true";

    static {
        elementMap.put("classloader", new Integer(0));
        elementMap.put("method", new Integer(1));
        elementMap.put(A_CLASS, new Integer(2));
        elementMap.put("package", new Integer(3));
        elementMap.put("call", new Integer(4));
        elementMap.put("new", new Integer(5));
        elementMap.put("poison", new Integer(6));
        elementMap.put("summary-spec", new Integer(7));
        elementMap.put("return", new Integer(8));
        elementMap.put("putstatic", new Integer(9));
        elementMap.put("aastore", new Integer(10));
        elementMap.put("putfield", new Integer(11));
        elementMap.put("getfield", new Integer(12));
        elementMap.put("throw", new Integer(13));
        elementMap.put("constant", new Integer(14));
        elementMap.put("aaload", new Integer(15));
    }

    public XMLMethodSummaryReader(InputStream xmlFile, AnalysisScope scope) {
        if (xmlFile == null) {
            throw new IllegalArgumentException("null xmlFile");
        }
        if (scope == null) {
            throw new IllegalArgumentException("null scope");
        }
        this.scope = scope;
        try {
            this.readXML(xmlFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    private void readXML(InputStream xml) throws SAXException, IOException, ParserConfigurationException {
        SAXHandler handler = new SAXHandler();
        assert (xml != null) : "Null xml stream";
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.newSAXParser().parse(new InputSource(xml), (DefaultHandler)handler);
    }

    public Map<MethodReference, MethodSummary> getSummaries() {
        return this.summaries;
    }

    public Set<TypeReference> getAllocatableClasses() {
        return this.allocatable;
    }

    public Set<Atom> getIgnoredPackages() {
        return this.ignoredPackages;
    }

    private class SAXHandler
    extends DefaultHandler {
        private ClassLoaderReference governingLoader = null;
        private MethodSummary governingMethod = null;
        private TypeReference governingClass = null;
        private Atom governingPackage = null;
        private int nextLocal = -1;
        private Map<String, Integer> symbolTable = null;

        private SAXHandler() {
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes atts) {
            Integer element = (Integer)elementMap.get(qName);
            if (element == null) {
                Assertions.UNREACHABLE((String)("Invalid element: " + qName));
            }
            switch (element) {
                case 0: {
                    String clName = atts.getValue(XMLMethodSummaryReader.A_NAME);
                    this.governingLoader = this.classLoaderName2Ref(clName);
                    break;
                }
                case 1: {
                    String mname = atts.getValue(XMLMethodSummaryReader.A_NAME);
                    if (mname.equals(XMLMethodSummaryReader.A_WILDCARD)) {
                        Assertions.UNREACHABLE((String)"Wildcards not currently implemented.");
                        break;
                    }
                    this.startMethod(atts);
                    break;
                }
                case 2: {
                    String cname = atts.getValue(XMLMethodSummaryReader.A_NAME);
                    if (cname.equals(XMLMethodSummaryReader.A_WILDCARD)) {
                        Assertions.UNREACHABLE((String)"Wildcards not currently implemented");
                        break;
                    }
                    this.startClass(cname, atts);
                    break;
                }
                case 3: {
                    this.governingPackage = Atom.findOrCreateUnicodeAtom(atts.getValue(XMLMethodSummaryReader.A_NAME));
                    String ignore = atts.getValue(XMLMethodSummaryReader.A_IGNORE);
                    if (ignore == null || !ignore.equals(XMLMethodSummaryReader.V_TRUE)) break;
                    XMLMethodSummaryReader.this.ignoredPackages.add(this.governingPackage);
                    break;
                }
                case 4: {
                    this.processCallSite(atts);
                    break;
                }
                case 5: {
                    this.processAllocation(atts);
                    break;
                }
                case 9: {
                    this.processPutStatic(atts);
                    break;
                }
                case 11: {
                    this.processPutField(atts);
                    break;
                }
                case 12: {
                    this.processGetField(atts);
                    break;
                }
                case 13: {
                    this.processAthrow(atts);
                    break;
                }
                case 10: {
                    this.processAastore(atts);
                    break;
                }
                case 15: {
                    this.processAaload(atts);
                    break;
                }
                case 8: {
                    this.processReturn(atts);
                    break;
                }
                case 6: {
                    this.processPoison(atts);
                    break;
                }
                case 14: {
                    this.processConstant(atts);
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    Assertions.UNREACHABLE((String)("Unexpected element: " + name));
                }
            }
        }

        private void startClass(String cname, Attributes atts) {
            String clName = "L" + this.governingPackage + "/" + cname;
            this.governingClass = this.className2Ref(clName);
            String allocString = atts.getValue(XMLMethodSummaryReader.A_ALLOCATABLE);
            if (allocString != null) {
                Assertions.productionAssertion((boolean)allocString.equals(XMLMethodSummaryReader.V_TRUE));
                XMLMethodSummaryReader.this.allocatable.add(this.governingClass);
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            Integer element = (Integer)elementMap.get(qName);
            if (element == null) {
                Assertions.UNREACHABLE((String)("Invalid element: " + name));
            }
            switch (element) {
                case 0: {
                    this.governingLoader = null;
                    break;
                }
                case 1: {
                    if (this.governingMethod != null) {
                        this.checkReturnValue(this.governingMethod);
                    }
                    this.governingMethod = null;
                    this.symbolTable = null;
                    break;
                }
                case 2: {
                    this.governingClass = null;
                    break;
                }
                case 3: {
                    this.governingPackage = null;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                default: {
                    Assertions.UNREACHABLE((String)("Unexpected element: " + name));
                }
            }
        }

        private void checkReturnValue(MethodSummary governingMethod) {
            Assertions.productionAssertion((governingMethod != null ? 1 : 0) != 0);
            Assertions.productionAssertion((governingMethod.getReturnType() != null ? 1 : 0) != 0);
            if (governingMethod.getReturnType().isReferenceType()) {
                SSAInstruction[] statements = governingMethod.getStatements();
                int i = 0;
                while (i < statements.length) {
                    if (statements[i] instanceof SSAReturnInstruction) {
                        return;
                    }
                    ++i;
                }
                Assertions.UNREACHABLE((String)("Method summary " + governingMethod + " must have a return statement."));
            }
        }

        private void processCallSite(Attributes atts) {
            String typeString = atts.getValue(XMLMethodSummaryReader.A_TYPE);
            String nameString = atts.getValue(XMLMethodSummaryReader.A_NAME);
            String classString = atts.getValue(XMLMethodSummaryReader.A_CLASS);
            String descString = atts.getValue(XMLMethodSummaryReader.A_DESCRIPTOR);
            TypeReference type = TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(classString));
            Atom nm = Atom.findOrCreateAsciiAtom(nameString);
            Language lang = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            SSAInstructionFactory insts = lang.instructionFactory();
            Descriptor D = Descriptor.findOrCreateUTF8(lang, descString);
            MethodReference ref = MethodReference.findOrCreate(type, nm, D);
            CallSiteReference site = null;
            int nParams = ref.getNumberOfParameters();
            if (typeString.equals("virtual")) {
                site = CallSiteReference.make(this.governingMethod.getNextProgramCounter(), ref, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.VIRTUAL);
                ++nParams;
            } else if (typeString.equals("special")) {
                site = CallSiteReference.make(this.governingMethod.getNextProgramCounter(), ref, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL);
                ++nParams;
            } else if (typeString.equals("interface")) {
                site = CallSiteReference.make(this.governingMethod.getNextProgramCounter(), ref, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.INTERFACE);
                ++nParams;
            } else if (typeString.equals(XMLMethodSummaryReader.A_STATIC)) {
                site = CallSiteReference.make(this.governingMethod.getNextProgramCounter(), ref, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC);
            } else {
                Assertions.UNREACHABLE((String)("Invalid call type " + typeString));
            }
            int[] params = new int[nParams];
            int i = 0;
            while (i < params.length) {
                String argString = atts.getValue(XMLMethodSummaryReader.A_ARG + i);
                Assertions.productionAssertion((argString != null ? 1 : 0) != 0, (String)("unspecified arg in method " + this.governingMethod + " " + site));
                Integer valueNumber = this.symbolTable.get(argString);
                if (valueNumber == null) {
                    Assertions.UNREACHABLE((String)("Cannot lookup value: " + argString));
                }
                params[i] = valueNumber;
                ++i;
            }
            int exceptionValue = this.nextLocal++;
            String defVar = atts.getValue(XMLMethodSummaryReader.A_DEF);
            if (defVar != null) {
                if (this.symbolTable.keySet().contains(defVar)) {
                    Assertions.UNREACHABLE((String)("Cannot def variable twice: " + defVar + " in " + this.governingMethod));
                }
                int defNum = this.nextLocal;
                this.symbolTable.put(defVar, new Integer(this.nextLocal++));
                this.governingMethod.addStatement(insts.InvokeInstruction(this.governingMethod.getNumberOfStatements(), defNum, params, exceptionValue, site, null));
            } else {
                this.governingMethod.addStatement(insts.InvokeInstruction(this.governingMethod.getNumberOfStatements(), params, exceptionValue, site, null));
            }
        }

        private void processAllocation(Attributes atts) {
            Language lang = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            SSAInstructionFactory insts = lang.instructionFactory();
            String classString = atts.getValue(XMLMethodSummaryReader.A_CLASS);
            TypeReference type = TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(classString));
            String defVar = atts.getValue(XMLMethodSummaryReader.A_DEF);
            if (this.symbolTable.keySet().contains(defVar)) {
                Assertions.UNREACHABLE((String)("Cannot def variable twice: " + defVar + " in " + this.governingMethod));
            }
            if (defVar == null) {
                defVar = "L" + this.nextLocal;
            }
            int defNum = this.nextLocal;
            this.symbolTable.put(defVar, new Integer(this.nextLocal++));
            NewSiteReference ref = NewSiteReference.make(this.governingMethod.getNextProgramCounter(), type);
            SSANewInstruction a = null;
            if (type.isArrayType()) {
                String size = atts.getValue(XMLMethodSummaryReader.A_SIZE);
                Assertions.productionAssertion((size != null ? 1 : 0) != 0);
                Integer sNumber = this.symbolTable.get(size);
                Assertions.productionAssertion((sNumber != null ? 1 : 0) != 0);
                Assertions.productionAssertion((type.getDerivedMask() == 1 || type.getDerivedMask() == 12 ? 1 : 0) != 0);
                a = insts.NewInstruction(this.governingMethod.getNumberOfStatements(), defNum, ref, new int[]{sNumber});
            } else {
                a = insts.NewInstruction(this.governingMethod.getNumberOfStatements(), defNum, ref);
            }
            this.governingMethod.addStatement(a);
        }

        private void processAthrow(Attributes atts) {
            Integer valueNumber;
            Language lang = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            SSAInstructionFactory insts = lang.instructionFactory();
            String V = atts.getValue(XMLMethodSummaryReader.A_VALUE);
            if (V == null) {
                Assertions.UNREACHABLE((String)("Must specify value for putfield " + this.governingMethod));
            }
            if ((valueNumber = this.symbolTable.get(V)) == null) {
                Assertions.UNREACHABLE((String)("Cannot lookup value: " + V));
            }
            SSAThrowInstruction T = insts.ThrowInstruction(this.governingMethod.getNumberOfStatements(), valueNumber);
            this.governingMethod.addStatement(T);
        }

        private void processGetField(Attributes atts) {
            Integer refNumber;
            Language lang = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            SSAInstructionFactory insts = lang.instructionFactory();
            String classString = atts.getValue(XMLMethodSummaryReader.A_CLASS);
            TypeReference type = TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(classString));
            String fieldString = atts.getValue(XMLMethodSummaryReader.A_FIELD);
            Atom fieldName = Atom.findOrCreateAsciiAtom(fieldString);
            String ftString = atts.getValue(XMLMethodSummaryReader.A_FIELD_TYPE);
            TypeReference fieldType = TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(ftString));
            FieldReference field = FieldReference.findOrCreate(type, fieldName, fieldType);
            String defVar = atts.getValue(XMLMethodSummaryReader.A_DEF);
            if (this.symbolTable.keySet().contains(defVar)) {
                Assertions.UNREACHABLE((String)("Cannot def variable twice: " + defVar + " in " + this.governingMethod));
            }
            if (defVar == null) {
                Assertions.UNREACHABLE((String)("Must specify def for getfield " + this.governingMethod));
            }
            int defNum = this.nextLocal;
            this.symbolTable.put(defVar, new Integer(this.nextLocal++));
            String R = atts.getValue(XMLMethodSummaryReader.A_REF);
            if (R == null) {
                Assertions.UNREACHABLE((String)("Must specify ref for getfield " + this.governingMethod));
            }
            if ((refNumber = this.symbolTable.get(R)) == null) {
                Assertions.UNREACHABLE((String)("Cannot lookup ref: " + R));
            }
            SSAGetInstruction G = insts.GetInstruction(this.governingMethod.getNumberOfStatements(), defNum, refNumber, field);
            this.governingMethod.addStatement(G);
        }

        private void processPutField(Attributes atts) {
            Integer refNumber;
            String R;
            Integer valueNumber;
            Language lang = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            SSAInstructionFactory insts = lang.instructionFactory();
            String classString = atts.getValue(XMLMethodSummaryReader.A_CLASS);
            TypeReference type = TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(classString));
            String fieldString = atts.getValue(XMLMethodSummaryReader.A_FIELD);
            Atom fieldName = Atom.findOrCreateAsciiAtom(fieldString);
            String ftString = atts.getValue(XMLMethodSummaryReader.A_FIELD_TYPE);
            TypeReference fieldType = TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(ftString));
            FieldReference field = FieldReference.findOrCreate(type, fieldName, fieldType);
            String V = atts.getValue(XMLMethodSummaryReader.A_VALUE);
            if (V == null) {
                Assertions.UNREACHABLE((String)("Must specify value for putfield " + this.governingMethod));
            }
            if ((valueNumber = this.symbolTable.get(V)) == null) {
                Assertions.UNREACHABLE((String)("Cannot lookup value: " + V));
            }
            if ((R = atts.getValue(XMLMethodSummaryReader.A_REF)) == null) {
                Assertions.UNREACHABLE((String)("Must specify ref for putfield " + this.governingMethod));
            }
            if ((refNumber = this.symbolTable.get(R)) == null) {
                Assertions.UNREACHABLE((String)("Cannot lookup ref: " + R));
            }
            SSAPutInstruction P = insts.PutInstruction(this.governingMethod.getNumberOfStatements(), refNumber, valueNumber, field);
            this.governingMethod.addStatement(P);
        }

        private void processPutStatic(Attributes atts) {
            Integer valueNumber;
            Language lang = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            SSAInstructionFactory insts = lang.instructionFactory();
            String classString = atts.getValue(XMLMethodSummaryReader.A_CLASS);
            TypeReference type = TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(classString));
            String fieldString = atts.getValue(XMLMethodSummaryReader.A_FIELD);
            Atom fieldName = Atom.findOrCreateAsciiAtom(fieldString);
            String ftString = atts.getValue(XMLMethodSummaryReader.A_FIELD_TYPE);
            TypeReference fieldType = TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(ftString));
            FieldReference field = FieldReference.findOrCreate(type, fieldName, fieldType);
            String V = atts.getValue(XMLMethodSummaryReader.A_VALUE);
            if (V == null) {
                Assertions.UNREACHABLE((String)("Must specify value for putstatic " + this.governingMethod));
            }
            if ((valueNumber = this.symbolTable.get(V)) == null) {
                Assertions.UNREACHABLE((String)("Cannot lookup value: " + V));
            }
            SSAPutInstruction P = insts.PutInstruction(this.governingMethod.getNumberOfStatements(), valueNumber, field);
            this.governingMethod.addStatement(P);
        }

        private void processAastore(Attributes atts) {
            String strType;
            String V;
            String I;
            Integer refNumber;
            Language lang = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            SSAInstructionFactory insts = lang.instructionFactory();
            String R = atts.getValue(XMLMethodSummaryReader.A_REF);
            if (R == null) {
                Assertions.UNREACHABLE((String)("Must specify ref for aastore " + this.governingMethod));
            }
            if ((refNumber = this.symbolTable.get(R)) == null) {
                Assertions.UNREACHABLE((String)("Cannot lookup value: " + R));
            }
            if ((I = atts.getValue(XMLMethodSummaryReader.A_INDEX)) == null) {
                Assertions.UNREACHABLE((String)("Must specify index for aastore " + this.governingMethod));
            }
            if ((V = atts.getValue(XMLMethodSummaryReader.A_VALUE)) == null) {
                Assertions.UNREACHABLE((String)("Must specify value for aastore " + this.governingMethod));
            }
            TypeReference type = (strType = atts.getValue(XMLMethodSummaryReader.A_TYPE)) == null ? TypeReference.JavaLangObject : TypeReference.findOrCreate(this.governingLoader, strType);
            Integer valueNumber = this.symbolTable.get(V);
            if (valueNumber == null) {
                Assertions.UNREACHABLE((String)("Cannot lookup value: " + V));
            }
            SSAArrayStoreInstruction S = insts.ArrayStoreInstruction(this.governingMethod.getNumberOfStatements(), refNumber, 0, valueNumber, type);
            this.governingMethod.addStatement(S);
        }

        private void processAaload(Attributes atts) {
            String strType;
            String I;
            Integer refNumber;
            Language lang = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            SSAInstructionFactory insts = lang.instructionFactory();
            String R = atts.getValue(XMLMethodSummaryReader.A_REF);
            if (R == null) {
                Assertions.UNREACHABLE((String)("Must specify ref for aaload " + this.governingMethod));
            }
            if ((refNumber = this.symbolTable.get(R)) == null) {
                Assertions.UNREACHABLE((String)("Cannot lookup value: " + R));
            }
            if ((I = atts.getValue(XMLMethodSummaryReader.A_INDEX)) == null) {
                Assertions.UNREACHABLE((String)("Must specify index for aaload " + this.governingMethod));
            }
            TypeReference type = (strType = atts.getValue(XMLMethodSummaryReader.A_TYPE)) == null ? TypeReference.JavaLangObject : TypeReference.findOrCreate(this.governingLoader, strType);
            String defVar = atts.getValue(XMLMethodSummaryReader.A_DEF);
            if (this.symbolTable.keySet().contains(defVar)) {
                Assertions.UNREACHABLE((String)("Cannot def variable twice: " + defVar + " in " + this.governingMethod));
            }
            if (defVar == null) {
                Assertions.UNREACHABLE((String)("Must specify def for getfield " + this.governingMethod));
            }
            int defNum = this.nextLocal;
            this.symbolTable.put(defVar, new Integer(this.nextLocal++));
            SSAArrayLoadInstruction S = insts.ArrayLoadInstruction(this.governingMethod.getNumberOfStatements(), defNum, refNumber, 0, type);
            this.governingMethod.addStatement(S);
        }

        private void processReturn(Attributes atts) {
            Language lang = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            SSAInstructionFactory insts = lang.instructionFactory();
            if (this.governingMethod.getReturnType() != null) {
                String retV = atts.getValue(XMLMethodSummaryReader.A_VALUE);
                if (retV == null) {
                    SSAReturnInstruction R = insts.ReturnInstruction(this.governingMethod.getNumberOfStatements());
                    this.governingMethod.addStatement(R);
                } else {
                    Integer valueNumber = this.symbolTable.get(retV);
                    if (valueNumber == null) {
                        if (!retV.equals(XMLMethodSummaryReader.V_NULL)) {
                            Assertions.UNREACHABLE((String)("Cannot return value with no def: " + retV));
                        } else {
                            valueNumber = this.symbolTable.get(XMLMethodSummaryReader.V_NULL);
                            if (valueNumber == null) {
                                valueNumber = new Integer(this.nextLocal++);
                                this.symbolTable.put(XMLMethodSummaryReader.V_NULL, valueNumber);
                            }
                        }
                    }
                    boolean isPrimitive = this.governingMethod.getReturnType().isPrimitiveType();
                    SSAReturnInstruction R = insts.ReturnInstruction(this.governingMethod.getNumberOfStatements(), valueNumber, isPrimitive);
                    this.governingMethod.addStatement(R);
                }
            }
        }

        private void processConstant(Attributes atts) {
            String var = atts.getValue(XMLMethodSummaryReader.A_NAME);
            if (var == null) {
                Assertions.UNREACHABLE((String)"Must give name for constant");
            }
            Integer valueNumber = new Integer(this.nextLocal++);
            this.symbolTable.put(var, valueNumber);
            String typeString = atts.getValue(XMLMethodSummaryReader.A_TYPE);
            String valueString = atts.getValue(XMLMethodSummaryReader.A_VALUE);
            this.governingMethod.addConstant(valueNumber, typeString.equals("int") ? new ConstantValue(new Integer(valueString)) : (typeString.equals("long") ? new ConstantValue(new Long(valueString)) : (typeString.equals("short") ? new ConstantValue(new Short(valueString)) : (typeString.equals("float") ? new ConstantValue(new Float(valueString)) : (typeString.equals("double") ? new ConstantValue(new Double(valueString)) : null)))));
        }

        private void processPoison(Attributes atts) {
            String reason = atts.getValue(XMLMethodSummaryReader.A_REASON);
            this.governingMethod.addPoison(reason);
            String level = atts.getValue(XMLMethodSummaryReader.A_LEVEL);
            if (level.equals("severe")) {
                this.governingMethod.setPoisonLevel((byte)2);
            } else if (level.equals("moderate")) {
                this.governingMethod.setPoisonLevel((byte)1);
            } else if (level.equals("mild")) {
                this.governingMethod.setPoisonLevel((byte)0);
            } else {
                Assertions.UNREACHABLE((String)("Unexpected level: " + level));
            }
        }

        private void startMethod(Attributes atts) {
            int nParams;
            String specifiedArgs;
            String factoryString;
            String methodName = atts.getValue(XMLMethodSummaryReader.A_NAME);
            Atom mName = Atom.findOrCreateUnicodeAtom(methodName);
            String descString = atts.getValue(XMLMethodSummaryReader.A_DESCRIPTOR);
            Language lang = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            Descriptor D = Descriptor.findOrCreateUTF8(lang, descString);
            MethodReference ref = MethodReference.findOrCreate(this.governingClass, mName, D);
            this.governingMethod = new MethodSummary(ref);
            XMLMethodSummaryReader.this.summaries.put(ref, this.governingMethod);
            boolean isStatic = false;
            String staticString = atts.getValue(XMLMethodSummaryReader.A_STATIC);
            if (staticString != null) {
                if (staticString.equals(XMLMethodSummaryReader.V_TRUE)) {
                    isStatic = true;
                    this.governingMethod.setStatic(true);
                } else if (staticString.equals("false")) {
                    isStatic = false;
                    this.governingMethod.setStatic(false);
                } else {
                    Assertions.UNREACHABLE((String)("Invalid attribute value static: " + staticString));
                }
            }
            if ((factoryString = atts.getValue(XMLMethodSummaryReader.A_FACTORY)) != null) {
                if (factoryString.equals(XMLMethodSummaryReader.V_TRUE)) {
                    this.governingMethod.setFactory(true);
                } else if (factoryString.equals("false")) {
                    this.governingMethod.setFactory(false);
                } else {
                    Assertions.UNREACHABLE((String)("Invalid attribute value factory: " + factoryString));
                }
            }
            if ((specifiedArgs = atts.getValue(XMLMethodSummaryReader.A_NUM_ARGS)) == null) {
                nParams = ref.getNumberOfParameters();
                if (!isStatic) {
                    ++nParams;
                }
            } else {
                nParams = Integer.parseInt(specifiedArgs);
            }
            this.nextLocal = nParams + 1;
            this.symbolTable = HashMapFactory.make((int)5);
            int i = 0;
            while (i < nParams) {
                this.symbolTable.put(XMLMethodSummaryReader.A_ARG + i, new Integer(i + 1));
                ++i;
            }
        }

        private ClassLoaderReference classLoaderName2Ref(String clName) {
            return XMLMethodSummaryReader.this.scope.getLoader(Atom.findOrCreateUnicodeAtom(clName));
        }

        private TypeReference className2Ref(String clName) {
            return TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(clName));
        }
    }
}

