/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ipa.summaries.LambdaSummaryClass;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.shrikeCT.BootstrapMethodsReader;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeDynamicInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.strings.Atom;
import java.util.WeakHashMap;

public class LambdaMethodTargetSelector
implements MethodTargetSelector {
    private final WeakHashMap<BootstrapMethodsReader.BootstrapMethod, SummarizedMethod> summaries = new WeakHashMap();
    private final MethodTargetSelector base;

    public LambdaMethodTargetSelector(MethodTargetSelector base) {
        this.base = base;
    }

    @Override
    public IMethod getCalleeTarget(CGNode caller, CallSiteReference site, IClass receiver) {
        if (!site.getDeclaredTarget().getName().equals(MethodReference.clinitName) && caller.getClassHierarchy().lookupClass(TypeReference.LambdaMetaFactory) != null && caller.getClassHierarchy().lookupClass(TypeReference.LambdaMetaFactory).equals(caller.getClassHierarchy().lookupClass(site.getDeclaredTarget().getDeclaringClass()))) {
            SSAInvokeDynamicInstruction invoke = (SSAInvokeDynamicInstruction)caller.getIR().getCalls(site)[0];
            if (!this.summaries.containsKey(invoke.getBootstrap())) {
                String cls = caller.getMethod().getDeclaringClass().getName().toString().replace("/", "$").substring(1);
                int bootstrapIndex = invoke.getBootstrap().getIndexInClassFile();
                MethodReference ref = MethodReference.findOrCreate(site.getDeclaredTarget().getDeclaringClass(), Atom.findOrCreateUnicodeAtom(String.valueOf(site.getDeclaredTarget().getName().toString()) + "$" + cls + "$" + bootstrapIndex), site.getDeclaredTarget().getDescriptor());
                MethodSummary summary = new MethodSummary(ref);
                if (site.isStatic()) {
                    summary.setStatic(true);
                }
                int index = 0;
                int v = site.getDeclaredTarget().getNumberOfParameters() + 2;
                LambdaSummaryClass lambda = LambdaSummaryClass.findOrCreate(caller, invoke);
                SSAInstructionFactory insts = Language.JAVA.instructionFactory();
                summary.addStatement(insts.NewInstruction(index, v, NewSiteReference.make(index, lambda.getReference())));
                ++index;
                int i = 0;
                while (i < site.getDeclaredTarget().getNumberOfParameters()) {
                    summary.addStatement(insts.PutInstruction(index++, v, i + 1, lambda.getField(Atom.findOrCreateUnicodeAtom("c" + i)).getReference()));
                    ++i;
                }
                summary.addStatement(insts.ReturnInstruction(index++, v, false));
                this.summaries.put(invoke.getBootstrap(), new SummarizedMethod(ref, summary, caller.getClassHierarchy().lookupClass(site.getDeclaredTarget().getDeclaringClass())));
            }
            return this.summaries.get(invoke.getBootstrap());
        }
        return this.base.getCalleeTarget(caller, site, receiver);
    }
}

