/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.dataflow.IFDS.IFlowFunction;
import com.ibm.wala.dataflow.IFDS.IPartiallyBalancedFlowFunctions;
import com.ibm.wala.dataflow.IFDS.IUnaryFlowFunction;
import com.ibm.wala.dataflow.IFDS.IdentityFlowFunction;
import com.ibm.wala.ipa.slicer.HeapStatement;
import com.ibm.wala.ipa.slicer.ReachabilityFunctions;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.util.debug.Assertions;

public class SliceFunctions
implements IPartiallyBalancedFlowFunctions<Statement> {
    @Override
    public IUnaryFlowFunction getCallFlowFunction(Statement src, Statement dest, Statement ret) {
        return ReachabilityFunctions.createReachabilityFunctions().getCallFlowFunction(src, dest, ret);
    }

    @Override
    public IUnaryFlowFunction getCallNoneToReturnFlowFunction(Statement src, Statement dest) {
        if (src == null) {
            throw new IllegalArgumentException("src is null");
        }
        Statement s = src;
        switch (s.getKind()) {
            case PARAM_CALLER: 
            case NORMAL_RET_CALLER: 
            case EXC_RET_CALLER: {
                return ReachabilityFunctions.KILL_FLOW;
            }
            case HEAP_PARAM_CALLER: 
            case HEAP_PARAM_CALLEE: 
            case HEAP_RET_CALLER: 
            case HEAP_RET_CALLEE: {
                if (dest instanceof HeapStatement) {
                    HeapStatement hd = (HeapStatement)dest;
                    HeapStatement hs = (HeapStatement)src;
                    if (hs.getLocation().equals(hd.getLocation())) {
                        return IdentityFlowFunction.identity();
                    }
                    return ReachabilityFunctions.KILL_FLOW;
                }
                return ReachabilityFunctions.KILL_FLOW;
            }
            case NORMAL: {
                return ReachabilityFunctions.KILL_FLOW;
            }
        }
        Assertions.UNREACHABLE((String)s.getKind().toString());
        return null;
    }

    @Override
    public IUnaryFlowFunction getCallToReturnFlowFunction(Statement src, Statement dest) {
        return ReachabilityFunctions.createReachabilityFunctions().getCallToReturnFlowFunction(src, dest);
    }

    @Override
    public IUnaryFlowFunction getNormalFlowFunction(Statement src, Statement dest) {
        return ReachabilityFunctions.createReachabilityFunctions().getNormalFlowFunction(src, dest);
    }

    @Override
    public IFlowFunction getReturnFlowFunction(Statement call, Statement src, Statement dest) {
        return ReachabilityFunctions.createReachabilityFunctions().getReturnFlowFunction(call, src, dest);
    }

    public IFlowFunction getReturnFlowFunction(Statement src, Statement dest) {
        return ReachabilityFunctions.createReachabilityFunctions().getReturnFlowFunction(src, dest);
    }

    @Override
    public IFlowFunction getUnbalancedReturnFlowFunction(Statement src, Statement dest) {
        return this.getReturnFlowFunction(src, dest);
    }
}

