/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import java.util.Collection;
import java.util.Set;

public class ArgumentTypeEntrypoint
extends Entrypoint {
    private final TypeReference[][] paramTypes;
    private final IClassHierarchy cha;

    protected TypeReference[][] makeParameterTypes(IMethod method) throws IllegalArgumentException {
        if (method == null) {
            throw new IllegalArgumentException("method == null");
        }
        TypeReference[][] result = new TypeReference[method.getNumberOfParameters()][];
        int i = 0;
        while (i < result.length) {
            TypeReference[] typeReferenceArray;
            TypeReference t = method.getParameterType(i);
            if (!t.isPrimitiveType()) {
                ArrayClass arrayKlass;
                IClass innermost;
                IClass klass = this.cha.lookupClass(t);
                if (klass == null) {
                    t = null;
                } else if (!klass.isInterface() && klass.isAbstract()) {
                    t = this.chooseAConcreteSubClass(klass);
                } else if (klass.isInterface()) {
                    t = this.chooseAnImplementor(klass);
                } else if (klass.isArrayClass() && (innermost = (arrayKlass = (ArrayClass)klass).getInnermostElementClass()) != null && innermost.isInterface()) {
                    TypeReference impl = this.chooseAnImplementor(innermost);
                    if (impl == null) {
                        t = null;
                    } else {
                        t = TypeReference.findOrCreateArrayOf(impl);
                        int dim = 1;
                        while (dim < arrayKlass.getDimensionality()) {
                            t = TypeReference.findOrCreateArrayOf(t);
                            ++dim;
                        }
                    }
                }
            }
            if (t == null) {
                typeReferenceArray = new TypeReference[]{};
            } else {
                TypeReference[] typeReferenceArray2 = new TypeReference[1];
                typeReferenceArray = typeReferenceArray2;
                typeReferenceArray2[0] = t;
            }
            result[i] = typeReferenceArray;
            ++i;
        }
        return result;
    }

    private TypeReference chooseAnImplementor(IClass iface) {
        Set<IClass> implementors = this.cha.getImplementors(iface.getReference());
        if (!implementors.isEmpty()) {
            return implementors.iterator().next().getReference();
        }
        return null;
    }

    private TypeReference chooseAConcreteSubClass(IClass klass) {
        Collection<IClass> subclasses = this.cha.computeSubClasses(klass.getReference());
        for (IClass c : subclasses) {
            if (c.isAbstract()) continue;
            return c.getReference();
        }
        return null;
    }

    public ArgumentTypeEntrypoint(IMethod method, IClassHierarchy cha) {
        super(method);
        this.cha = cha;
        this.paramTypes = this.makeParameterTypes(method);
    }

    @Override
    public TypeReference[] getParameterTypes(int i) {
        return this.paramTypes[i];
    }

    @Override
    public int getNumberOfParameters() {
        return this.paramTypes.length;
    }
}

