/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph;

import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.ClassTargetSelector;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ssa.SSAOptions;

public class AnalysisOptions {
    private AnalysisScope analysisScope;
    private Iterable<? extends Entrypoint> entrypoints;
    private ClassTargetSelector classTargetSelector;
    private MethodTargetSelector methodTargetSelector;
    private int minEquationsForTopSort = 100;
    private double topologicalGrowthFactor = 0.5;
    private int maxEvalBetweenTopo = 1000000000;
    private ReflectionOptions reflectionOptions = ReflectionOptions.FULL;
    private boolean handleStaticInit = true;
    private SSAOptions ssaOptions = new SSAOptions();
    private boolean useConstantSpecificKeys = false;
    private boolean useStacksForLexicalScoping = false;
    private boolean useLexicalScopingForGlobals = false;
    private boolean traceStringConstants = false;
    private long maxNumberOfNodes = -1L;

    public AnalysisOptions() {
    }

    public AnalysisOptions(AnalysisScope scope, Iterable<? extends Entrypoint> e) {
        this.analysisScope = scope;
        this.entrypoints = e;
    }

    public AnalysisScope getAnalysisScope() {
        return this.analysisScope;
    }

    public void setAnalysisScope(AnalysisScope analysisScope) {
        this.analysisScope = analysisScope;
    }

    public Iterable<? extends Entrypoint> getEntrypoints() {
        return this.entrypoints;
    }

    public void setEntrypoints(Iterable<? extends Entrypoint> entrypoints) {
        this.entrypoints = entrypoints;
    }

    public long getMaxNumberOfNodes() {
        return this.maxNumberOfNodes;
    }

    public void setMaxNumberOfNodes(long maxNumberOfNodes) {
        this.maxNumberOfNodes = maxNumberOfNodes;
    }

    public MethodTargetSelector getMethodTargetSelector() {
        return this.methodTargetSelector;
    }

    public ClassTargetSelector getClassTargetSelector() {
        return this.classTargetSelector;
    }

    public void setSelector(MethodTargetSelector x) {
        this.methodTargetSelector = x;
    }

    public void setSelector(ClassTargetSelector x) {
        this.classTargetSelector = x;
    }

    public int getMinEquationsForTopSort() {
        return this.minEquationsForTopSort;
    }

    public void setMinEquationsForTopSort(int i) {
        this.minEquationsForTopSort = i;
    }

    public int getMaxEvalBetweenTopo() {
        return this.maxEvalBetweenTopo;
    }

    public double getTopologicalGrowthFactor() {
        return this.topologicalGrowthFactor;
    }

    public void setMaxEvalBetweenTopo(int i) {
        this.maxEvalBetweenTopo = i;
    }

    public void setTopologicalGrowthFactor(double d) {
        this.topologicalGrowthFactor = d;
    }

    public SSAOptions getSSAOptions() {
        return this.ssaOptions;
    }

    public void setSSAOptions(SSAOptions ssaOptions) {
        this.ssaOptions = ssaOptions;
    }

    public boolean getUseConstantSpecificKeys() {
        return this.useConstantSpecificKeys;
    }

    public void setUseConstantSpecificKeys(boolean useConstantSpecificKeys) {
        this.useConstantSpecificKeys = useConstantSpecificKeys;
    }

    public boolean getUseStacksForLexicalScoping() {
        return this.useStacksForLexicalScoping;
    }

    public void setUseStacksForLexicalScoping(boolean v) {
        this.useStacksForLexicalScoping = v;
    }

    public boolean getUseLexicalScopingForGlobals() {
        return this.useLexicalScopingForGlobals;
    }

    public void setUseLexicalScopingForGlobals(boolean v) {
        this.useLexicalScopingForGlobals = v;
    }

    public void setTraceStringConstants(boolean v) {
        this.traceStringConstants = v;
    }

    public boolean getTraceStringConstants() {
        return this.traceStringConstants;
    }

    public ReflectionOptions getReflectionOptions() {
        return this.reflectionOptions;
    }

    public void setReflectionOptions(ReflectionOptions reflectionOptions) {
        this.reflectionOptions = reflectionOptions;
    }

    public boolean getHandleStaticInit() {
        return this.handleStaticInit;
    }

    public void setHandleStaticInit(boolean handleStaticInit) {
        this.handleStaticInit = handleStaticInit;
    }

    public static enum ReflectionOptions {
        FULL("full", Integer.MAX_VALUE, false, false, false),
        APPLICATION_GET_METHOD("application_get_method", Integer.MAX_VALUE, false, false, true),
        NO_FLOW_TO_CASTS("no_flow_to_casts", 0, false, false, false),
        NO_FLOW_TO_CASTS_APPLICATION_GET_METHOD("no_flow_to_casts_application_get_method", 0, false, false, true),
        NO_METHOD_INVOKE("no_method_invoke", Integer.MAX_VALUE, true, false, false),
        NO_FLOW_TO_CASTS_NO_METHOD_INVOKE("no_flow_to_casts_no_method_invoke", 0, true, false, false),
        ONE_FLOW_TO_CASTS_NO_METHOD_INVOKE("one_flow_to_casts_no_method_invoke", 1, true, false, false),
        ONE_FLOW_TO_CASTS_APPLICATION_GET_METHOD("one_flow_to_casts_application_get_method", 1, false, false, true),
        NO_STRING_CONSTANTS("no_string_constants", Integer.MAX_VALUE, false, true, false),
        NONE("none", 0, true, true, true);

        private final String name;
        private final int numFlowToCastIterations;
        private final boolean ignoreMethodInvoke;
        private final boolean applicationClassesOnly;
        private final boolean ignoreStringConstants;

        private ReflectionOptions(String name, int numFlowToCastIterations, boolean ignoreMethodInvoke, boolean ignoreInterpretCalls, boolean applicationClassesOnly) {
            this.name = name;
            this.numFlowToCastIterations = numFlowToCastIterations;
            this.ignoreMethodInvoke = ignoreMethodInvoke;
            this.ignoreStringConstants = ignoreInterpretCalls;
            this.applicationClassesOnly = applicationClassesOnly;
        }

        public String getName() {
            return this.name;
        }

        public int getNumFlowToCastIterations() {
            return this.numFlowToCastIterations;
        }

        public boolean isIgnoreMethodInvoke() {
            return this.ignoreMethodInvoke;
        }

        public boolean isIgnoreStringConstants() {
            return this.ignoreStringConstants;
        }

        public boolean isApplicationClassesOnly() {
            return this.applicationClassesOnly;
        }
    }
}

