/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.util;

import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SymbolTable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PointerParamValueNumIterator
implements Iterator<Integer> {
    final TypeInference ti;
    final SymbolTable symbolTable;
    final int numParams;
    int paramInd;
    int nextParameter;

    public PointerParamValueNumIterator(CGNode node) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        IR ir = node.getIR();
        this.ti = TypeInference.make(ir, false);
        this.symbolTable = ir.getSymbolTable();
        this.numParams = this.symbolTable.getNumberOfParameters();
        this.paramInd = 0;
        this.setNextParameter();
    }

    private void setNextParameter() {
        int i = this.paramInd;
        while (i < this.numParams) {
            int parameter = this.symbolTable.getParameter(i);
            TypeAbstraction t = this.ti.getType(parameter);
            if (t != null) {
                this.nextParameter = parameter;
                break;
            }
            ++i;
        }
        this.paramInd = ++i;
    }

    @Override
    public boolean hasNext() {
        return this.paramInd <= this.numParams;
    }

    @Override
    public Integer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int ret = this.nextParameter;
        this.setNextParameter();
        return ret;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

