/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg.refinepolicy;

import com.ibm.wala.demandpa.alg.refinepolicy.CallGraphRefinePolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.FieldRefinePolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.RefinementPolicy;
import java.util.Arrays;

public abstract class AbstractRefinementPolicy
implements RefinementPolicy {
    protected static final int DEFAULT_NUM_PASSES = 4;
    protected static final int LONGER_PASS_BUDGET = 12000;
    private static final int SHORTER_PASS_BUDGET = 1000;
    private static final int[] DEFAULT_BUDGET_PER_PASS;
    protected final FieldRefinePolicy fieldRefinePolicy;
    protected final CallGraphRefinePolicy cgRefinePolicy;
    protected final int numPasses;
    protected final int[] budgetPerPass;

    static {
        int[] tmp = new int[4];
        tmp[0] = 1000;
        Arrays.fill(tmp, 1, 4, 12000);
        DEFAULT_BUDGET_PER_PASS = tmp;
    }

    public AbstractRefinementPolicy(FieldRefinePolicy fieldRefinePolicy, CallGraphRefinePolicy cgRefinePolicy, int numPasses, int[] budgetPerPass) {
        this.fieldRefinePolicy = fieldRefinePolicy;
        this.cgRefinePolicy = cgRefinePolicy;
        this.numPasses = numPasses;
        this.budgetPerPass = budgetPerPass;
    }

    public AbstractRefinementPolicy(FieldRefinePolicy fieldRefinePolicy, CallGraphRefinePolicy cgRefinePolicy) {
        this(fieldRefinePolicy, cgRefinePolicy, 4, DEFAULT_BUDGET_PER_PASS);
    }

    @Override
    public int getBudgetForPass(int passNum) {
        return this.budgetPerPass[passNum];
    }

    @Override
    public CallGraphRefinePolicy getCallGraphRefinePolicy() {
        return this.cgRefinePolicy;
    }

    @Override
    public FieldRefinePolicy getFieldRefinePolicy() {
        return this.fieldRefinePolicy;
    }

    @Override
    public int getNumPasses() {
        return this.numPasses;
    }

    @Override
    public boolean nextPass() {
        boolean fieldNextPass = this.fieldRefinePolicy.nextPass();
        boolean callNextPass = this.cgRefinePolicy.nextPass();
        return fieldNextPass || callNextPass;
    }
}

