/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.ShrikeCFG;
import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.classLoader.JavaLanguage;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSABuilder;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.ShrikeIndirectionData;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.ssa.analysis.DeadAssignmentElimination;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.WalaRuntimeException;
import java.util.Collection;

public class ShrikeIRFactory
implements IRFactory<IBytecodeMethod> {
    public static final boolean buildLocalMap = true;

    public ControlFlowGraph makeCFG(IBytecodeMethod method, Context C) {
        return ShrikeCFG.make(method);
    }

    @Override
    public IR makeIR(final IBytecodeMethod method, Context C, SSAOptions options) throws IllegalArgumentException {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        IInstruction[] shrikeInstructions = null;
        try {
            shrikeInstructions = method.getInstructions();
        }
        catch (InvalidClassFileException e) {
            throw new WalaRuntimeException("bad method bytecodes", (Throwable)e);
        }
        ShrikeCFG shrikeCFG = (ShrikeCFG)this.makeCFG(method, C);
        final SymbolTable symbolTable = new SymbolTable(method.getNumberOfParameters());
        final SSAInstruction[] newInstrs = new SSAInstruction[shrikeInstructions.length];
        SSACFG newCfg = new SSACFG(method, shrikeCFG, newInstrs);
        return new IR(method, newInstrs, symbolTable, newCfg, options, newCfg, shrikeCFG, options){
            private final IR.SSA2LocalMap localMap;
            private final ShrikeIndirectionData indirectionData;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
                SSABuilder builder = SSABuilder.make(iBytecodeMethod, sSACFG, shrikeCFG, sSAInstructionArray, symbolTable2, true, sSAOptions.getPiNodePolicy());
                builder.build();
                this.localMap = builder.getLocalMap();
                this.indirectionData = builder.getIndirectionData();
                this.eliminateDeadPhis();
                this.pruneExceptionsForSafeArrayCreations();
                this.setupLocationMap();
            }

            private void eliminateDeadPhis() {
                DeadAssignmentElimination.perform(this);
            }

            private void pruneExceptionsForSafeArrayCreations() {
                DefUse du = new DefUse(this);
                int i = 0;
                while (i < newInstrs.length) {
                    SSANewInstruction newInstr;
                    SSAInstruction instr = newInstrs[i];
                    if (instr instanceof SSANewInstruction && (newInstr = (SSANewInstruction)instr).getConcreteType().isArrayType()) {
                        boolean isSafe = true;
                        int[] params = new int[newInstr.getNumberOfUses()];
                        int u = 0;
                        while (u < newInstr.getNumberOfUses()) {
                            int vLength;
                            params[u] = vLength = newInstr.getUse(u);
                            isSafe &= this.isNonNegativeConstant(vLength) || this.isDefdByArrayLength(vLength, du);
                            ++u;
                        }
                        if (isSafe) {
                            newInstrs[i] = new SSANewInstruction(newInstr.iindex, newInstr.getDef(), newInstr.getNewSite(), params){

                                @Override
                                public Collection<TypeReference> getExceptionTypes() {
                                    return JavaLanguage.getNewSafeArrayExceptions();
                                }
                            };
                        }
                    }
                    ++i;
                }
            }

            private boolean isNonNegativeConstant(int vLength) {
                return symbolTable.isIntegerConstant(vLength) && symbolTable.getIntValue(vLength) >= 0;
            }

            private boolean isDefdByArrayLength(int vLength, DefUse du) {
                return du.getDef(vLength) instanceof SSAArrayLengthInstruction;
            }

            @Override
            protected String instructionPosition(int instructionIndex) {
                int lineNumber;
                block3: {
                    try {
                        int bcIndex = method.getBytecodeIndex(instructionIndex);
                        lineNumber = method.getLineNumber(bcIndex);
                        if (lineNumber != -1) break block3;
                        return "";
                    }
                    catch (InvalidClassFileException invalidClassFileException) {
                        return "";
                    }
                }
                return "(line " + lineNumber + ")";
            }

            @Override
            public IR.SSA2LocalMap getLocalMap() {
                return this.localMap;
            }

            protected ShrikeIndirectionData getIndirectionData() {
                return this.indirectionData;
            }
        };
    }

    @Override
    public boolean contextIsIrrelevant(IBytecodeMethod method) {
        return true;
    }
}

