/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg.exc.intra;

import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import java.util.Arrays;
import java.util.Collection;

public class OperatorUtil {

    public static class UnaryOperatorSequence<T extends IVariable>
    extends UnaryOperator<T> {
        final UnaryOperator<T>[] operators;

        public UnaryOperatorSequence(Collection<UnaryOperator<T>> operators) {
            if (operators.size() == 0) {
                throw new IllegalArgumentException("Empty Operator-Sequence");
            }
            this.operators = operators.toArray(new UnaryOperator[operators.size()]);
        }

        public UnaryOperatorSequence(UnaryOperator<T> ... operators) {
            if (operators.length == 0) {
                throw new IllegalArgumentException("Empty Operator-Sequence");
            }
            this.operators = Arrays.copyOf(operators, operators.length);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            UnaryOperatorSequence other = (UnaryOperatorSequence)((Object)o);
            return this.operators.equals(other.operators);
        }

        public int hashCode() {
            return this.operators.hashCode();
        }

        public String toString() {
            return Arrays.toString(this.operators);
        }

        public byte evaluate(T lhs, T rhs) {
            assert (this.operators.length > 0);
            int result = this.operators[0].evaluate(lhs, rhs);
            int i = 1;
            while (i < this.operators.length) {
                byte changed = this.operators[i].evaluate(lhs, lhs);
                result = (result | changed) & 1 | (result | changed) & 4 | result & changed & 2;
                ++i;
            }
            return (byte)result;
        }
    }
}

