/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.GetMethodContext;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.summaries.SyntheticIR;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRView;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class GetMethodContextInterpreter
implements SSAContextInterpreter {
    public static final MethodReference GET_METHOD = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
    public static final MethodReference GET_DECLARED_METHOD = MethodReference.findOrCreate(TypeReference.JavaLangClass, "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
    private static final boolean DEBUG = false;

    @Override
    public IR getIR(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(node));
        IMethod method = node.getMethod();
        GetMethodContext context = (GetMethodContext)node.getContext();
        HashMap constants = HashMapFactory.make();
        if (method.getReference().equals(GET_METHOD)) {
            Atom name = Atom.findOrCreateAsciiAtom(context.getName());
            SSAInstruction[] instrs = this.makeGetMethodStatements(context, constants, name);
            return new SyntheticIR(method, context, new InducedCFG(instrs, method, context), instrs, SSAOptions.defaultOptions(), constants);
        }
        if (method.getReference().equals(GET_DECLARED_METHOD)) {
            Atom name = Atom.findOrCreateAsciiAtom(context.getName());
            SSAInstruction[] instrs = this.makeGetDeclaredMethodStatements(context, constants, name);
            return new SyntheticIR(method, context, new InducedCFG(instrs, method, context), instrs, SSAOptions.defaultOptions(), constants);
        }
        Assertions.UNREACHABLE((String)("Unexpected method " + node));
        return null;
    }

    @Override
    public IRView getIRView(CGNode node) {
        return this.getIR(node);
    }

    @Override
    public int getNumberOfStatements(CGNode node) {
        assert (this.understands(node));
        return this.getIR(node).getInstructions().length;
    }

    @Override
    public boolean understands(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (!(node.getContext() instanceof GetMethodContext)) {
            return false;
        }
        MethodReference mRef = node.getMethod().getReference();
        return mRef.equals(GET_METHOD) || mRef.equals(GET_DECLARED_METHOD);
    }

    @Override
    public Iterator<NewSiteReference> iterateNewSites(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(node));
        GetMethodContext context = (GetMethodContext)node.getContext();
        TypeReference tr = context.getType().getTypeReference();
        if (tr != null) {
            return new NonNullSingletonIterator((Object)NewSiteReference.make(0, tr));
        }
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<CallSiteReference> iterateCallSites(CGNode node) {
        assert (this.understands(node));
        return EmptyIterator.instance();
    }

    private Collection<IMethod> getDeclaredNormalMethods(IClass cls, Atom name) {
        HashSet result = HashSetFactory.make();
        for (IMethod m : cls.getDeclaredMethods()) {
            if (m.isInit() || m.isClinit() || !m.getSelector().getName().equals(name)) continue;
            result.add(m);
        }
        return result;
    }

    private Collection<IMethod> getAllNormalPublicMethods(IClass cls, Atom name) {
        HashSet result = HashSetFactory.make();
        Collection<IMethod> allMethods = null;
        allMethods = cls.getAllMethods();
        for (IMethod m : allMethods) {
            if (m.isInit() || m.isClinit() || !m.isPublic() || !m.getSelector().getName().equals(name)) continue;
            result.add(m);
        }
        return result;
    }

    private SSAInstruction[] getParticularMethodStatements(MethodReference ref, Collection<IMethod> returnValues, GetMethodContext context, Map<Integer, ConstantValue> constants) {
        ArrayList<SSAReturnInstruction> statements = new ArrayList<SSAReturnInstruction>();
        int nextLocal = ref.getNumberOfParameters() + 2;
        IClass cls = context.getType().getType();
        SSAInstructionFactory insts = context.getType().getType().getClassLoader().getInstructionFactory();
        if (cls != null) {
            for (IMethod m : returnValues) {
                int c = nextLocal++;
                constants.put(c, new ConstantValue(m));
                SSAReturnInstruction R = insts.ReturnInstruction(statements.size(), c, false);
                statements.add(R);
            }
        }
        SSAInstruction[] result = new SSAInstruction[statements.size()];
        Iterator it = statements.iterator();
        int i = 0;
        while (i < result.length) {
            result[i] = (SSAInstruction)it.next();
            ++i;
        }
        return result;
    }

    private SSAInstruction[] makeGetMethodStatements(GetMethodContext context, Map<Integer, ConstantValue> constants, Atom name) {
        IClass cls = context.getType().getType();
        if (cls == null) {
            return this.getParticularMethodStatements(GET_METHOD, null, context, constants);
        }
        return this.getParticularMethodStatements(GET_METHOD, this.getAllNormalPublicMethods(cls, name), context, constants);
    }

    private SSAInstruction[] makeGetDeclaredMethodStatements(GetMethodContext context, Map<Integer, ConstantValue> constants, Atom name) {
        IClass cls = context.getType().getType();
        if (cls == null) {
            return this.getParticularMethodStatements(GET_DECLARED_METHOD, null, context, constants);
        }
        return this.getParticularMethodStatements(GET_DECLARED_METHOD, this.getDeclaredNormalMethods(cls, name), context, constants);
    }

    @Override
    public boolean recordFactoryType(CGNode node, IClass klass) {
        return false;
    }

    @Override
    public Iterator<FieldReference> iterateFieldsRead(CGNode node) {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<FieldReference> iterateFieldsWritten(CGNode node) {
        return EmptyIterator.instance();
    }

    @Override
    public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG(CGNode N) {
        return this.getIR(N).getControlFlowGraph();
    }

    @Override
    public DefUse getDU(CGNode node) {
        return new DefUse(this.getIR(node));
    }
}

