/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.nullpointer;

import com.ibm.wala.analysis.nullpointer.RelevantVariableFinder;
import com.ibm.wala.cfg.exc.intra.NullPointerFrameWork;
import com.ibm.wala.cfg.exc.intra.NullPointerSolver;
import com.ibm.wala.cfg.exc.intra.NullPointerState;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;

public class IntraproceduralNullPointerAnalysis {
    private static final MonitorUtil.IProgressMonitor NO_PROGRESS_MONITOR = null;
    private final NullPointerSolver<ISSABasicBlock> solver;
    private final IR ir;

    public IntraproceduralNullPointerAnalysis(IR ir) {
        if (ir == null || ir.isEmptyIR()) {
            throw new IllegalArgumentException("IR may not be null or empty.");
        }
        this.ir = ir;
        int maxVarNum = ir.getSymbolTable().getMaxValueNumber();
        int[] paramValNum = ir.getParameterValueNumbers();
        SSACFG cfg = ir.getControlFlowGraph();
        NullPointerFrameWork<ISSABasicBlock> problem = new NullPointerFrameWork<ISSABasicBlock>(cfg, ir);
        this.solver = new NullPointerSolver<SSACFG.BasicBlock>(problem, maxVarNum, paramValNum, ir, cfg.entry());
        try {
            this.solver.solve(NO_PROGRESS_MONITOR);
        }
        catch (CancelException cancelException) {}
    }

    public NullPointerState.State nullPointerExceptionThrowState(SSAInstruction instruction) {
        assert (instruction != null);
        if (instruction.isPEI() && instruction.getExceptionTypes().contains(TypeReference.JavaLangNullPointerException)) {
            NullPointerState blockState = (NullPointerState)this.solver.getIn(this.ir.getBasicBlockForInstruction(instruction));
            RelevantVariableFinder finder = new RelevantVariableFinder(instruction);
            assert (finder.getVarNum() >= 0);
            return blockState.getState(finder.getVarNum());
        }
        return NullPointerState.State.NOT_NULL;
    }
}

