/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.arraybounds;

import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;

public class ConditionNormalizer {
    private final int lhs;
    private int rhs;
    private IConditionalBranchInstruction.Operator op;

    public ConditionNormalizer(SSAConditionalBranchInstruction cnd, int lhs, boolean branchIsTaken) {
        this.lhs = lhs;
        if (cnd.getNumberOfUses() != 2) {
            throw new IllegalArgumentException("Condition uses not exactly two variables.");
        }
        this.op = (IConditionalBranchInstruction.Operator)cnd.getOperator();
        int i = 0;
        while (i < cnd.getNumberOfUses()) {
            int var = cnd.getUse(i);
            if (var != lhs) {
                if (cnd.getUse((i + 1) % 2) != lhs) {
                    throw new IllegalArgumentException("Lhs not contained in condition.");
                }
                if (i == 0) {
                    this.op = this.swapOperator(this.op);
                }
                if (!branchIsTaken) {
                    this.op = this.negateOperator(this.op);
                }
                this.rhs = var;
            }
            ++i;
        }
    }

    public int getLhs() {
        return this.lhs;
    }

    public IConditionalBranchInstruction.Operator getOp() {
        return this.op;
    }

    public int getRhs() {
        return this.rhs;
    }

    private IConditionalBranchInstruction.Operator negateOperator(IConditionalBranchInstruction.Operator op) {
        switch (op) {
            case EQ: {
                return IConditionalBranchInstruction.Operator.NE;
            }
            case NE: {
                return IConditionalBranchInstruction.Operator.EQ;
            }
            case LT: {
                return IConditionalBranchInstruction.Operator.GE;
            }
            case GE: {
                return IConditionalBranchInstruction.Operator.LT;
            }
            case GT: {
                return IConditionalBranchInstruction.Operator.LE;
            }
            case LE: {
                return IConditionalBranchInstruction.Operator.GT;
            }
        }
        throw new RuntimeException("Programming Error: Got unknown operator.");
    }

    private IConditionalBranchInstruction.Operator swapOperator(IConditionalBranchInstruction.Operator op) {
        switch (op) {
            case EQ: {
                return op;
            }
            case NE: {
                return op;
            }
            case LT: {
                return IConditionalBranchInstruction.Operator.GT;
            }
            case GE: {
                return IConditionalBranchInstruction.Operator.LE;
            }
            case GT: {
                return IConditionalBranchInstruction.Operator.LT;
            }
            case LE: {
                return IConditionalBranchInstruction.Operator.GE;
            }
        }
        throw new RuntimeException("Programming Error: Got unknown operator.");
    }
}

