/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.arraybounds;

import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSABinaryOpInstruction;

public class BinaryOpWithConstant {
    private final IBinaryOpInstruction.IOperator op;
    private final Integer other;
    private final Integer value;
    private final Integer assigned;

    public static BinaryOpWithConstant create(SSABinaryOpInstruction instruction, IR ir) {
        BinaryOpWithConstant result = null;
        if (instruction.mayBeIntegerOp()) {
            assert (instruction.getNumberOfUses() == 2);
            Integer other = null;
            Integer value = null;
            int constantPos = -1;
            int i = 0;
            while (i < instruction.getNumberOfUses()) {
                int constant = instruction.getUse(i);
                if (ir.getSymbolTable().isIntegerConstant(constant)) {
                    other = instruction.getUse((i + 1) % 2);
                    value = ir.getSymbolTable().getIntValue(constant);
                    constantPos = i;
                }
                ++i;
            }
            IBinaryOpInstruction.IOperator op = instruction.getOperator();
            if (constantPos != -1 && (op == IBinaryOpInstruction.Operator.ADD || op == IBinaryOpInstruction.Operator.SUB && constantPos == 1)) {
                result = new BinaryOpWithConstant(op, other, value, instruction.getDef());
            }
        }
        return result;
    }

    private BinaryOpWithConstant(IBinaryOpInstruction.IOperator op, Integer other, Integer value, Integer assigned) {
        this.op = op;
        this.other = other;
        this.value = value;
        this.assigned = assigned;
    }

    public Integer getAssignedVar() {
        return this.assigned;
    }

    public Integer getConstantValue() {
        return this.value;
    }

    public IBinaryOpInstruction.IOperator getOp() {
        return this.op;
    }

    public Integer getOtherVar() {
        return this.other;
    }
}

