/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.arraybounds;

import com.ibm.wala.analysis.arraybounds.ArrayBoundsGraph;
import com.ibm.wala.analysis.arraybounds.ArrayBoundsGraphBuilder;
import com.ibm.wala.analysis.arraybounds.hypergraph.HyperNode;
import com.ibm.wala.analysis.arraybounds.hypergraph.algorithms.ShortestPath;
import com.ibm.wala.analysis.arraybounds.hypergraph.weight.NormalOrder;
import com.ibm.wala.analysis.arraybounds.hypergraph.weight.ReverseOrder;
import com.ibm.wala.analysis.arraybounds.hypergraph.weight.Weight;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAArrayReferenceInstruction;
import com.ibm.wala.util.ssa.InstructionByIIndexMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ArrayOutOfBoundsAnalysis {
    private ArrayBoundsGraph lowerBoundGraph;
    private ArrayBoundsGraph upperBoundGraph;
    private final Map<SSAArrayReferenceInstruction, UnnecessaryCheck> boundsCheckUnnecessary = new InstructionByIIndexMap<SSAArrayReferenceInstruction, UnnecessaryCheck>();

    public ArrayOutOfBoundsAnalysis(IR ir) {
        this.buildInequalityGraphs(ir);
        this.computeLowerBound();
        this.computeUpperBounds();
        this.lowerBoundGraph = null;
        this.upperBoundGraph = null;
    }

    private void addUnnecessaryCheck(SSAArrayReferenceInstruction instruction, UnnecessaryCheck checkToAdd) {
        UnnecessaryCheck oldCheck = this.boundsCheckUnnecessary.get(instruction);
        UnnecessaryCheck newCheck = oldCheck.union(checkToAdd);
        this.boundsCheckUnnecessary.put(instruction, newCheck);
    }

    private void buildInequalityGraphs(IR ir) {
        ArrayBoundsGraphBuilder builder = new ArrayBoundsGraphBuilder(ir);
        this.lowerBoundGraph = builder.getLowerBoundGraph();
        this.upperBoundGraph = builder.getUpperBoundGraph();
        for (SSAArrayReferenceInstruction instruction : builder.getArrayReferenceInstructions()) {
            this.boundsCheckUnnecessary.put(instruction, UnnecessaryCheck.NONE);
        }
        builder = null;
    }

    private void computeLowerBound() {
        HyperNode zero = this.lowerBoundGraph.getNodes().get(ArrayBoundsGraph.ZERO);
        ShortestPath.compute(this.lowerBoundGraph, zero, new NormalOrder());
        for (SSAArrayReferenceInstruction instruction : this.boundsCheckUnnecessary.keySet()) {
            Weight weight = this.lowerBoundGraph.getVariableWeight(instruction.getIndex());
            if (weight.getType() != Weight.Type.NUMBER || weight.getNumber() < 0) continue;
            this.addUnnecessaryCheck(instruction, UnnecessaryCheck.LOWER);
        }
    }

    private void computeUpperBounds() {
        HashMap<Integer, Integer> arrayLengths = this.upperBoundGraph.getArrayLength();
        for (Integer array : arrayLengths.keySet()) {
            HyperNode arrayNode = this.upperBoundGraph.getNodes().get(arrayLengths.get(array));
            ShortestPath.compute(this.upperBoundGraph, arrayNode, new ReverseOrder());
            for (SSAArrayReferenceInstruction instruction : this.boundsCheckUnnecessary.keySet()) {
                Weight weight;
                if (instruction.getArrayRef() != array.intValue() || (weight = this.upperBoundGraph.getVariableWeight(instruction.getIndex())).getType() != Weight.Type.NUMBER || weight.getNumber() > -1) continue;
                this.addUnnecessaryCheck(instruction, UnnecessaryCheck.UPPER);
            }
        }
    }

    public Map<SSAArrayReferenceInstruction, UnnecessaryCheck> getBoundsCheckNecessary() {
        return this.boundsCheckUnnecessary;
    }

    public static enum UnnecessaryCheck {
        NONE,
        UPPER,
        LOWER,
        BOTH;


        public UnnecessaryCheck union(UnnecessaryCheck other) {
            HashSet<UnnecessaryCheck> set = new HashSet<UnnecessaryCheck>();
            set.add(this);
            set.add(other);
            set.remove((Object)NONE);
            if (set.contains((Object)BOTH) || set.contains((Object)UPPER) && set.contains((Object)LOWER)) {
                return BOTH;
            }
            if (set.size() == 0) {
                return NONE;
            }
            if (set.size() == 1) {
                return (UnnecessaryCheck)((Object)set.iterator().next());
            }
            throw new RuntimeException("Case that should not happen, this method is implemented wrong.");
        }
    }
}

