/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.controller;

import com.ibm.safe.controller.AbstractSafeController;
import com.ibm.safe.controller.AbstractSafeJavaApplication;
import com.ibm.safe.controller.GenericSafeController;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.internal.exceptions.SafeException;
import com.ibm.safe.internal.reporting.ReporterFactory;
import com.ibm.safe.lightweight.options.LightweightProperties;
import com.ibm.safe.options.WholeProgramProperties;
import com.ibm.safe.properties.CommonProperties;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.safe.rules.IRule;
import com.ibm.safe.typestate.options.TypestateProperties;
import com.ibm.safe.utils.SafeLogger;
import com.ibm.wala.util.WalaException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SAFEJavaApplication
extends AbstractSafeJavaApplication {
    public static void main(String[] args) throws PropertiesException, WalaException {
        LightweightProperties.register();
        TypestateProperties.register();
        SAFEJavaApplication sja = new SAFEJavaApplication();
        sja.run(args, PropertiesManager.initFromCommandLine((String[])args));
    }

    protected void run(String[] args, PropertiesManager properties) {
        block6: {
            if (this.requiresHelp(args)) {
                this.displayUsage();
            }
            this.initLoggerProperty();
            try {
                AbstractSafeController runner = this.createController(properties);
                IRule[] rules = runner.getRules();
                String analysisResultFile = String.valueOf(properties.getPathValue((PropertiesManager.IPropertyDescriptor)CommonProperties.Props.OUTPUT_DIR)) + File.separator + properties.getStringValue((PropertiesManager.IPropertyDescriptor)CommonProperties.Props.RESULT_FILENAME);
                assert (analysisResultFile != null);
                runner.execute(rules, ReporterFactory.createDefaultReporter((String)analysisResultFile), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (SafeException except) {
                except.printStackTrace();
                SafeLogger.severe((String)except.getMessage());
                if (except.getCause() != null) {
                    SafeLogger.severe((String)except.getCause().getMessage());
                }
            }
            catch (Exception except) {
                except.printStackTrace();
                SafeLogger.severe((String)this.getStackStrace(except));
                if (except.getCause() == null) break block6;
                SafeLogger.severe((String)this.getStackStrace(except.getCause()));
            }
        }
    }

    protected AbstractSafeController createController(PropertiesManager propertiesManager) {
        return new GenericSafeController(propertiesManager);
    }

    protected void displaySpecificLauncherOptions() {
        this.displayUsage("Structural Options", (PropertiesManager.IPropertyDescriptor[])LightweightProperties.Props.values());
        ArrayList<Object> properties = new ArrayList<Object>();
        properties.addAll(Arrays.asList(WholeProgramProperties.Props.values()));
        properties.addAll(Arrays.asList(TypestateProperties.Props.values()));
        this.displayUsage("Typestate Options", properties.toArray(new PropertiesManager.IPropertyDescriptor[properties.size()]));
        properties = new ArrayList();
        properties.addAll(Arrays.asList(CommonProperties.Props.values()));
        properties.addAll(Arrays.asList(WholeProgramProperties.Props.values()));
        this.displayUsage("Null-dereference Options", properties.toArray(new PropertiesManager.IPropertyDescriptor[properties.size()]));
    }
}

