/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ide.ui;

import com.ibm.wala.ide.ui.SWTTreeViewer;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.viz.PDFViewUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ViewIRAction
extends Action {
    private final SWTTreeViewer viewer;
    private final CallGraph cg;
    private final String psFile;
    private final String dotFile;
    private final String dotExe;
    private final String gvExe;

    public ViewIRAction(SWTTreeViewer viewer, CallGraph cg, String psFile, String dotFile, String dotExe, String gvExe) {
        if (viewer == null) {
            throw new IllegalArgumentException("null viewer");
        }
        this.viewer = viewer;
        this.cg = cg;
        this.psFile = psFile;
        this.dotFile = dotFile;
        this.dotExe = dotExe;
        this.gvExe = gvExe;
        this.setText("View IR");
    }

    public void run() {
        IR ir = this.getIRForSelection();
        System.err.println("Spawn IR Viewer for " + ir.getMethod());
        try {
            PDFViewUtil.ghostviewIR((IClassHierarchy)this.cg.getClassHierarchy(), (IR)ir, (String)this.psFile, (String)this.dotFile, (String)this.dotExe, (String)this.gvExe);
        }
        catch (WalaException e) {
            e.printStackTrace();
        }
    }

    protected IR getIRForSelection() {
        IStructuredSelection selection = this.viewer.getSelection();
        if (selection.size() != 1) {
            throw new UnsupportedOperationException("did not expect selection of size " + selection.size());
        }
        CGNode first = (CGNode)selection.getFirstElement();
        return first.getIR();
    }

    protected CGNode getNodeForSelection() {
        IStructuredSelection selection = this.viewer.getSelection();
        if (selection.size() != 1) {
            throw new UnsupportedOperationException("did not expect selection of size " + selection.size());
        }
        CGNode first = (CGNode)selection.getFirstElement();
        return first;
    }

    protected SWTTreeViewer getViewer() {
        return this.viewer;
    }

    protected CallGraph getCg() {
        return this.cg;
    }

    protected String getDotExe() {
        return this.dotExe;
    }

    protected String getDotFile() {
        return this.dotFile;
    }

    protected String getGvExe() {
        return this.gvExe;
    }

    protected String getPsFile() {
        return this.psFile;
    }
}

