/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ide.ui;

import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.dataflow.IFDS.TabulationResult;
import com.ibm.wala.ide.ui.SWTTreeViewer;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.GraphSlicer;
import com.ibm.wala.viz.DotUtil;
import com.ibm.wala.viz.NodeDecorator;
import com.ibm.wala.viz.PDFViewUtil;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ViewIFDSLocalAction<T, P, F>
extends Action {
    private final SWTTreeViewer viewer;
    private final ISupergraph<T, P> supergraph;
    private final String pdfFile;
    private final String dotFile;
    private final String dotExe;
    private final String pdfViewExe;
    private final NodeDecorator labels;

    public ViewIFDSLocalAction(SWTTreeViewer viewer, TabulationResult<T, P, F> result, String pdfFile, String dotFile, String dotExe, String pdfViewExe, NodeDecorator labels) {
        if (result == null) {
            throw new IllegalArgumentException("null result");
        }
        this.viewer = viewer;
        this.supergraph = result.getProblem().getSupergraph();
        this.pdfFile = pdfFile;
        this.dotFile = dotFile;
        this.dotExe = dotExe;
        this.pdfViewExe = pdfViewExe;
        this.labels = labels;
        this.setText("View Local Supergraph");
    }

    public ViewIFDSLocalAction(SWTTreeViewer viewer, TabulationResult<T, P, F> result, String psFile, String dotFile, String dotExe, String gvExe) {
        if (result == null) {
            throw new IllegalArgumentException("null result");
        }
        this.viewer = viewer;
        this.supergraph = result.getProblem().getSupergraph();
        this.pdfFile = psFile;
        this.dotFile = dotFile;
        this.dotExe = dotExe;
        this.pdfViewExe = gvExe;
        this.labels = new Labels<T, P, F>(result);
        this.setText("View Local Supergraph");
    }

    public static String stringify(SSAInstruction s) {
        if (s == null) {
            return null;
        }
        if (s instanceof SSAAbstractInvokeInstruction) {
            SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)s;
            String def = call.hasDef() ? Integer.valueOf(call.getDef()) + "=" : "";
            String result = String.valueOf(def) + "call " + call.getDeclaredTarget().getDeclaringClass().getName().getClassName() + "." + call.getDeclaredTarget().getName();
            result = String.valueOf(result) + " exc:" + call.getException();
            int i = 0;
            while (i < s.getNumberOfUses()) {
                result = String.valueOf(result) + " ";
                result = String.valueOf(result) + s.getUse(i);
                ++i;
            }
            return result;
        }
        if (s instanceof SSAGetInstruction) {
            SSAGetInstruction g = (SSAGetInstruction)s;
            String fieldName = g.getDeclaredField().getName().toString();
            StringBuffer result = new StringBuffer();
            result.append(g.getDef());
            result.append(":=");
            result.append(g.isStatic() ? "getstatic " : "getfield ");
            result.append(fieldName);
            if (!g.isStatic()) {
                result.append(" ");
                result.append(g.getUse(0));
            }
            return result.toString();
        }
        return s.toString();
    }

    public void run() {
        try {
            final P proc = this.getProcedureForSelection();
            Predicate filter = new Predicate<T>(){

                public boolean test(T o) {
                    return ViewIFDSLocalAction.this.supergraph.getProcOf(o).equals(proc);
                }
            };
            Graph localGraph = GraphSlicer.prune(this.supergraph, (Predicate)filter);
            System.err.println("Spawn Viewer for " + proc);
            DotUtil.dotify((Graph)localGraph, (NodeDecorator)this.labels, (String)this.dotFile, (String)this.pdfFile, (String)this.dotExe);
            if (DotUtil.getOutputType() == DotUtil.DotOutputType.PDF) {
                PDFViewUtil.launchPDFView((String)this.pdfFile, (String)this.pdfViewExe);
            }
        }
        catch (WalaException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    protected P getProcedureForSelection() {
        IStructuredSelection selection = this.viewer.getSelection();
        if (selection.size() != 1) {
            throw new UnsupportedOperationException("did not expect selection of size " + selection.size());
        }
        Object first = selection.getFirstElement();
        return (P)first;
    }

    protected SWTTreeViewer getViewer() {
        return this.viewer;
    }

    protected ISupergraph<T, P> getSupergraph() {
        return this.supergraph;
    }

    protected String getDotExe() {
        return this.dotExe;
    }

    protected String getDotFile() {
        return this.dotFile;
    }

    protected String getGvExe() {
        return this.pdfViewExe;
    }

    protected String getPsFile() {
        return this.pdfFile;
    }

    private static class Labels<T, P, F>
    implements NodeDecorator {
        private TabulationResult<T, P, F> result;

        Labels(TabulationResult<T, P, F> result) {
            this.result = result;
        }

        public String getLabel(Object o) throws WalaException {
            BasicBlockInContext bb;
            Object t = o;
            if (t instanceof BasicBlockInContext && (bb = (BasicBlockInContext)t).getDelegate() instanceof IExplodedBasicBlock) {
                IExplodedBasicBlock delegate = (IExplodedBasicBlock)bb.getDelegate();
                String s = String.valueOf(delegate.getNumber()) + " " + this.result.getResult(t) + "\\n" + ViewIFDSLocalAction.stringify(delegate.getInstruction());
                Iterator phis = delegate.iteratePhis();
                while (phis.hasNext()) {
                    SSAPhiInstruction phi = (SSAPhiInstruction)phis.next();
                    s = String.valueOf(s) + " " + phi;
                }
                if (delegate.isCatchBlock()) {
                    s = String.valueOf(s) + " " + delegate.getCatchInstruction();
                }
                return s;
            }
            return t + " " + this.result.getResult(t);
        }
    }
}

