/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ide.classloader;

import com.ibm.wala.classLoader.FileModule;
import com.ibm.wala.classLoader.SourceDirectoryTreeModule;
import com.ibm.wala.ide.classloader.EclipseSourceFileModule;
import com.ibm.wala.ide.util.EclipseProjectPath;
import java.io.File;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class EclipseSourceDirectoryTreeModule
extends SourceDirectoryTreeModule {
    private final IPath rootIPath;
    private final Pattern[] excludePatterns;

    private static Pattern interpretPattern(IPath pattern) {
        return Pattern.compile("^" + pattern.toString().replace(".", "\\.").replace("**", "~~~").replace("*", "[^/]*").replace("~~~", ".*") + "$");
    }

    private static Pattern[] interpretExcludes(IPath[] excludes) {
        if (excludes == null) {
            return null;
        }
        Pattern[] stuff = new Pattern[excludes.length];
        int i = 0;
        while (i < excludes.length) {
            stuff[i] = EclipseSourceDirectoryTreeModule.interpretPattern(excludes[i]);
            ++i;
        }
        return stuff;
    }

    public EclipseSourceDirectoryTreeModule(IPath root, IPath[] excludePaths) {
        super(EclipseProjectPath.makeAbsolute(root).toFile());
        this.rootIPath = root;
        this.excludePatterns = EclipseSourceDirectoryTreeModule.interpretExcludes(excludePaths);
    }

    public EclipseSourceDirectoryTreeModule(IPath root, IPath[] excludePaths, String fileExt) {
        super(EclipseProjectPath.makeAbsolute(root).toFile(), fileExt);
        this.rootIPath = root;
        this.excludePatterns = EclipseSourceDirectoryTreeModule.interpretExcludes(excludePaths);
    }

    protected FileModule makeFile(File file) {
        IPath p = this.rootIPath.append(file.getPath().substring(this.root.getPath().length()));
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = ws.getRoot();
        IFile ifile = root.getFile(p);
        assert (ifile.exists());
        return EclipseSourceFileModule.createEclipseSourceFileModule(ifile);
    }

    protected boolean includeFile(File file) {
        if (!super.includeFile(file)) {
            return false;
        }
        if (this.excludePatterns != null) {
            IPath p = this.rootIPath.append(file.getPath().substring(this.root.getPath().length()));
            Pattern[] patternArray = this.excludePatterns;
            int n = this.excludePatterns.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern exclude = patternArray[n2];
                if (exclude.matcher(p.toOSString()).matches()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public String toString() {
        return "EclipseSourceDirectoryTreeModule:" + this.rootIPath;
    }
}

