/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.AttributeReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class AnnotationsReader
extends AttributeReader {
    protected final int beginOffset;

    public AnnotationsReader(ClassReader.AttrIterator iter, String label) throws InvalidClassFileException {
        super(iter, label);
        this.beginOffset = this.attr;
    }

    public int getAnnotationCount() throws InvalidClassFileException {
        int offset = this.beginOffset + 6;
        this.checkSize(offset, 2);
        return this.cr.getUShort(offset);
    }

    public int getAttributeSize() throws InvalidClassFileException {
        int offset = this.beginOffset + 2;
        this.checkSize(offset, 4);
        return this.cr.getInt(offset) + 6;
    }

    protected String getUtf8ConstantPoolValue(int offset) throws InvalidClassFileException {
        this.checkSize(offset, 2);
        int cpOffset = this.cr.getUShort(offset);
        return this.cr.getCP().getCPUtf8(cpOffset);
    }

    public AnnotationAttribute[] getAllAnnotations() throws InvalidClassFileException {
        AnnotationAttribute[] result = new AnnotationAttribute[this.getAnnotationCount()];
        int offset = this.beginOffset + 8;
        int i = 0;
        while (i < result.length) {
            Pair<AnnotationAttribute, Integer> attributeAndSize = this.getAttributeAndSize(offset);
            result[i] = (AnnotationAttribute)attributeAndSize.fst;
            offset += ((Integer)attributeAndSize.snd).intValue();
            ++i;
        }
        return result;
    }

    public AnnotationAttribute[][] getAllParameterAnnotations() throws InvalidClassFileException {
        int numParamOffset = this.beginOffset + 6;
        this.checkSize(numParamOffset, 1);
        byte paramCount = this.cr.getByte(numParamOffset);
        AnnotationAttribute[][] result = new AnnotationAttribute[paramCount][];
        int offset = this.beginOffset + 7;
        int i = 0;
        while (i < result.length) {
            this.checkSize(offset, 2);
            result[i] = new AnnotationAttribute[this.cr.getUShort(offset)];
            offset += 2;
            int j = 0;
            while (j < result[i].length) {
                Pair<AnnotationAttribute, Integer> attributeAndSize = this.getAttributeAndSize(offset);
                result[i][j] = (AnnotationAttribute)attributeAndSize.fst;
                offset += ((Integer)attributeAndSize.snd).intValue();
                ++j;
            }
            ++i;
        }
        return result;
    }

    protected Pair<AnnotationAttribute, Integer> getAttributeAndSize(int begin) throws InvalidClassFileException {
        String type = this.getUtf8ConstantPoolValue(begin);
        int numElementValuePairs = this.cr.getUShort(begin + 2);
        int size = 4;
        int offset = begin + 4;
        HashMap elementName2Val = HashMapFactory.make();
        int i = 0;
        while (i < numElementValuePairs) {
            String elementName = this.getUtf8ConstantPoolValue(offset);
            Pair<ElementValue, Integer> elementValAndSize = this.readElementValueAndSize(offset += 2);
            offset += ((Integer)elementValAndSize.snd).intValue();
            size += (Integer)elementValAndSize.snd + 2;
            elementName2Val.put(elementName, (ElementValue)elementValAndSize.fst);
            ++i;
        }
        return Pair.make((Object)new AnnotationAttribute(type, elementName2Val), (Object)size);
    }

    protected Pair<ElementValue, Integer> readElementValueAndSize(int offset) throws IllegalArgumentException, InvalidClassFileException {
        char tag = (char)this.cr.getByte(offset);
        int nextShort = this.cr.getUShort(offset + 1);
        switch (tag) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return Pair.make((Object)new ConstantElementValue(this.cr.getCP().getCPInt(nextShort)), (Object)3);
            }
            case 'J': {
                return Pair.make((Object)new ConstantElementValue(this.cr.getCP().getCPLong(nextShort)), (Object)3);
            }
            case 'D': {
                return Pair.make((Object)new ConstantElementValue(this.cr.getCP().getCPDouble(nextShort)), (Object)3);
            }
            case 'F': {
                return Pair.make((Object)new ConstantElementValue(Float.valueOf(this.cr.getCP().getCPFloat(nextShort))), (Object)3);
            }
            case 'c': 
            case 's': {
                return Pair.make((Object)new ConstantElementValue(this.cr.getCP().getCPUtf8(nextShort)), (Object)3);
            }
            case 'e': {
                return Pair.make((Object)new EnumElementValue(this.cr.getCP().getCPUtf8(nextShort), this.cr.getCP().getCPUtf8(this.cr.getUShort(offset + 3))), (Object)5);
            }
            case '[': {
                int numValues = nextShort;
                int numArrayBytes = 3;
                ElementValue[] vals = new ElementValue[numValues];
                int curArrayOffset = offset + 3;
                int i = 0;
                while (i < numValues) {
                    Pair<ElementValue, Integer> arrayElemValueAndSize = this.readElementValueAndSize(curArrayOffset);
                    vals[i] = (ElementValue)arrayElemValueAndSize.fst;
                    curArrayOffset += ((Integer)arrayElemValueAndSize.snd).intValue();
                    numArrayBytes += ((Integer)arrayElemValueAndSize.snd).intValue();
                    ++i;
                }
                return Pair.make((Object)new ArrayElementValue(vals), (Object)numArrayBytes);
            }
            case '@': {
                Pair<AnnotationAttribute, Integer> attributeAndSize = this.getAttributeAndSize(offset + 1);
                return Pair.make((Object)((ElementValue)attributeAndSize.fst), (Object)((Integer)attributeAndSize.snd + 1));
            }
        }
        assert (false);
        return null;
    }

    public static boolean isKnownAnnotation(String name) {
        AnnotationType[] annotationTypeArray = AnnotationType.values();
        int n = annotationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationType t = annotationTypeArray[n2];
            if (t.name().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static AnnotationsReader getReaderForAnnotation(AnnotationType type, ClassReader.AttrIterator iter) {
        String attrName = type.toString();
        try {
            while (iter.isValid()) {
                if (iter.getName().equals(attrName)) {
                    return new AnnotationsReader(iter, attrName);
                }
                iter.advance();
            }
        }
        catch (InvalidClassFileException invalidClassFileException) {
            Assertions.UNREACHABLE();
        }
        return null;
    }

    public static class AnnotationAttribute
    implements ElementValue {
        public final String type;
        public final Map<String, ElementValue> elementValues;

        public AnnotationAttribute(String type, Map<String, ElementValue> elementValues) {
            this.type = type;
            this.elementValues = elementValues;
        }

        public String toString() {
            return "AnnotationElementValue [type=" + this.type + ", elementValues=" + this.elementValues + "]";
        }
    }

    public static enum AnnotationType {
        RuntimeVisibleAnnotations,
        RuntimeInvisibleAnnotations,
        RuntimeVisibleParameterAnnotations,
        RuntimeInvisibleParameterAnnotations;

    }

    public static class ArrayElementValue
    implements ElementValue {
        public final ElementValue[] vals;

        public ArrayElementValue(ElementValue[] vals) {
            this.vals = vals;
        }

        public String toString() {
            return "ArrayElementValue [vals=" + Arrays.toString(this.vals) + "]";
        }
    }

    public static class ConstantElementValue
    implements ElementValue {
        public final Object val;

        public ConstantElementValue(Object val) {
            this.val = val;
        }

        public String toString() {
            return String.valueOf(this.val);
        }
    }

    public static interface ElementValue {
    }

    public static class EnumElementValue
    implements ElementValue {
        public final String enumType;
        public final String enumVal;

        public EnumElementValue(String enumType, String enumVal) {
            this.enumType = enumType;
            this.enumVal = enumVal;
        }

        public String toString() {
            return "EnumElementValue [type=" + this.enumType + ", val=" + this.enumVal + "]";
        }
    }
}

