/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT.tools;

import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.InvokeDynamicInstruction;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;

public class BootstrapDumper {
    private final PrintWriter w;

    public BootstrapDumper(PrintWriter w) {
        this.w = w;
    }

    public static void main(String[] args) throws Exception {
        OfflineInstrumenter oi = new OfflineInstrumenter(true);
        String[] classpathEntries = oi.parseStandardArgs(args);
        PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
        BootstrapDumper p = new BootstrapDumper(w);
        URL[] urls = new URL[classpathEntries.length - 1];
        int i = 1;
        while (i < classpathEntries.length) {
            System.err.println(classpathEntries[i]);
            File f = new File(classpathEntries[i]);
            assert (f.exists());
            urls[i - 1] = f.toURI().toURL();
            ++i;
        }
        Throwable throwable = null;
        Object var7_9 = null;
        try (URLClassLoader image = URLClassLoader.newInstance(urls, BootstrapDumper.class.getClassLoader().getParent());){
            ClassInstrumenter ci;
            System.err.println(image);
            oi.beginTraversal();
            while ((ci = oi.nextClass()) != null) {
                try {
                    p.doClass(image, ci.getReader());
                }
                finally {
                    w.flush();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        oi.close();
    }

    private void dumpAttributes(Class cl, ClassReader cr, int i, ClassReader.AttrIterator attrs) throws InvalidClassFileException, Decoder.InvalidBytecodeException, IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        while (attrs.isValid()) {
            String name = attrs.getName();
            if (name.equals("Code")) {
                IInstruction[] insts;
                CodeReader code = new CodeReader(attrs);
                CTDecoder decoder = new CTDecoder(code);
                decoder.decode();
                IInstruction[] iInstructionArray = insts = decoder.getInstructions();
                int n = insts.length;
                int n2 = 0;
                while (n2 < n) {
                    IInstruction inst = iInstructionArray[n2];
                    if (inst instanceof InvokeDynamicInstruction) {
                        CallSite target = ((InvokeDynamicInstruction)inst).bootstrap(cl);
                        this.w.println(target.dynamicInvoker());
                        this.w.println(target.getTarget());
                    }
                    ++n2;
                }
            }
            attrs.advance();
        }
    }

    public void doClass(ClassLoader image, ClassReader cr) throws InvalidClassFileException, Decoder.InvalidBytecodeException, IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        if (cr == null) {
            throw new IllegalArgumentException("cr is null");
        }
        ClassReader.AttrIterator attrs = new ClassReader.AttrIterator();
        cr.initClassAttributeIterator(attrs);
        int methodCount = cr.getMethodCount();
        int i = 0;
        while (i < methodCount) {
            cr.initMethodAttributeIterator(i, attrs);
            this.dumpAttributes(Class.forName(cr.getName().replace('/', '.'), false, image), cr, i, attrs);
            ++i;
        }
    }
}

