/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class ShiftInstruction
extends Instruction
implements IShiftInstruction {
    private static final ShiftInstruction[] preallocated = ShiftInstruction.preallocate();

    protected ShiftInstruction(short opcode) {
        super(opcode);
    }

    private static ShiftInstruction[] preallocate() {
        ShiftInstruction[] r = new ShiftInstruction[6];
        int i = 0;
        while (i < r.length) {
            r[i] = new ShiftInstruction((short)(i + 120));
            ++i;
        }
        return r;
    }

    public static ShiftInstruction make(String type, IShiftInstruction.Operator operator) throws IllegalArgumentException {
        if (operator == null) {
            throw new IllegalArgumentException("operator is null");
        }
        int t = Util.getTypeIndex(type);
        if (t < 0 || t > 1) {
            throw new IllegalArgumentException("Cannot apply shift to type " + type);
        }
        return preallocated[(operator.ordinal() - IShiftInstruction.Operator.SHL.ordinal()) * 2 + t];
    }

    public boolean equals(Object o) {
        if (o instanceof ShiftInstruction) {
            ShiftInstruction i = (ShiftInstruction)o;
            return i.opcode == this.opcode;
        }
        return false;
    }

    @Override
    public IShiftInstruction.Operator getOperator() {
        return IShiftInstruction.Operator.values()[(this.opcode - 120) / 2];
    }

    public int hashCode() {
        return this.opcode;
    }

    @Override
    public int getPoppedCount() {
        return 2;
    }

    @Override
    public String getPushedType(String[] types) {
        return this.getType();
    }

    @Override
    public byte getPushedWordSize() {
        return Util.getWordSize(this.getType());
    }

    @Override
    public String getType() {
        return indexedTypes[this.opcode - 120 & 1];
    }

    @Override
    public void visit(IInstruction.Visitor v) throws NullPointerException {
        v.visitShift(this);
    }

    @Override
    public String toString() {
        return "Shift(" + this.getType() + "," + this.getOperator() + ")";
    }

    @Override
    public boolean isPEI() {
        return false;
    }

    @Override
    public boolean isUnsigned() {
        return false;
    }
}

