/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrikeBT.ArrayLoadInstruction;
import com.ibm.wala.shrikeBT.ArrayStoreInstruction;
import com.ibm.wala.shrikeBT.BinaryOpInstruction;
import com.ibm.wala.shrikeBT.CheckCastInstruction;
import com.ibm.wala.shrikeBT.ComparisonInstruction;
import com.ibm.wala.shrikeBT.ConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.shrikeBT.ConversionInstruction;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.GetInstruction;
import com.ibm.wala.shrikeBT.GotoInstruction;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.InstanceofInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.InvokeDynamicInstruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.PutInstruction;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.ShiftInstruction;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.SwapInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeBT.UnaryOpInstruction;
import com.ibm.wala.shrikeBT.Util;
import java.util.ArrayList;

public abstract class Decoder
implements Constants {
    private static final int UNSEEN = -1;
    private static final int INSIDE_INSTRUCTION = -2;
    private static final ExceptionHandler[] noHandlers = new ExceptionHandler[0];
    private static final Instruction[] simpleInstructions = Decoder.makeSimpleInstructions();
    private static final Instruction makeZero = ConstantInstruction.make(0);
    private IInstruction[] instructions;
    private ExceptionHandler[][] handlers;
    private int[] instructionsToBytecodes;
    private final ConstantPoolReader constantPool;
    private final byte[] code;
    private final int[] rawHandlers;
    private int[] decodedOffset;
    private byte[] decodedSize;
    private ArrayList<Instruction> decoded;
    private int[] belongsToSub;
    private int[] JSRs;
    private RetInfo[] retInfo;

    private static int skip(int a, int b) {
        return a < b ? a : a + 1;
    }

    private static Instruction[] makeSimpleInstructions() {
        Instruction[] table = new Instruction[256];
        table[1] = ConstantInstruction.make("L;", null);
        int i = 2;
        while (i <= 8) {
            table[i] = ConstantInstruction.make("I", new Integer(i - 2 - 1));
            ++i;
        }
        i = 9;
        while (i <= 10) {
            table[i] = ConstantInstruction.make("J", new Long(i - 9));
            ++i;
        }
        i = 11;
        while (i <= 13) {
            table[i] = ConstantInstruction.make("F", new Float(i - 11));
            ++i;
        }
        i = 14;
        while (i <= 15) {
            table[i] = ConstantInstruction.make("D", new Double(i - 14));
            ++i;
        }
        i = 26;
        while (i <= 45) {
            table[i] = LoadInstruction.make(indexedTypes[(i - 26) / 4], (i - 26) % 4);
            ++i;
        }
        i = 46;
        while (i <= 53) {
            table[i] = ArrayLoadInstruction.make(indexedTypes[i - 46]);
            ++i;
        }
        i = 59;
        while (i <= 78) {
            table[i] = StoreInstruction.make(indexedTypes[(i - 59) / 4], (i - 59) % 4);
            ++i;
        }
        i = 79;
        while (i <= 86) {
            table[i] = ArrayStoreInstruction.make(indexedTypes[i - 79]);
            ++i;
        }
        table[87] = PopInstruction.make(1);
        table[89] = DupInstruction.make(1, 0);
        table[90] = DupInstruction.make(1, 1);
        table[95] = SwapInstruction.make();
        i = 96;
        while (i <= 115) {
            table[i] = BinaryOpInstruction.make(indexedTypes[(i - 96) % 4], IBinaryOpInstruction.Operator.values()[(i - 96) / 4]);
            ++i;
        }
        i = 116;
        while (i <= 119) {
            table[i] = UnaryOpInstruction.make(indexedTypes[i - 116], IUnaryOpInstruction.Operator.NEG);
            ++i;
        }
        i = 120;
        while (i <= 125) {
            table[i] = ShiftInstruction.make(indexedTypes[(i - 120) % 2], IShiftInstruction.Operator.values()[(i - 120) / 2]);
            ++i;
        }
        i = 126;
        while (i <= 131) {
            table[i] = BinaryOpInstruction.make(indexedTypes[(i - 126) % 2], IBinaryOpInstruction.Operator.values()[IBinaryOpInstruction.Operator.AND.ordinal() + (i - 126) / 2]);
            ++i;
        }
        i = 133;
        while (i <= 144) {
            table[i] = ConversionInstruction.make(indexedTypes[(i - 133) / 3], indexedTypes[Decoder.skip((i - 133) % 3, (i - 133) / 3)]);
            ++i;
        }
        i = 145;
        while (i <= 147) {
            table[i] = ConversionInstruction.make("I", indexedTypes[5 + (i - 145)]);
            ++i;
        }
        table[148] = ComparisonInstruction.make("J", IComparisonInstruction.Operator.CMP);
        i = 149;
        while (i <= 152) {
            table[i] = ComparisonInstruction.make(indexedTypes[2 + (i - 149) / 2], IComparisonInstruction.Operator.values()[IComparisonInstruction.Operator.CMPL.ordinal() + (i - 149) % 2]);
            ++i;
        }
        i = 172;
        while (i <= 176) {
            table[i] = ReturnInstruction.make(indexedTypes[i - 172]);
            ++i;
        }
        table[177] = ReturnInstruction.make("V");
        table[191] = ThrowInstruction.make(false);
        table[194] = MonitorInstruction.make(true);
        table[195] = MonitorInstruction.make(false);
        table[190] = ArrayLengthInstruction.make();
        return table;
    }

    protected Decoder(byte[] code, int[] rawHandlers, ConstantPoolReader cp) {
        this.code = code;
        this.rawHandlers = rawHandlers;
        this.constantPool = cp;
    }

    public ConstantPoolReader getConstantPool() {
        return this.constantPool;
    }

    private int decodeShort(int index) {
        return this.code[index] << 8 | this.code[index + 1] & 0xFF;
    }

    private int decodeUShort(int index) {
        return (this.code[index] & 0xFF) << 8 | this.code[index + 1] & 0xFF;
    }

    private int decodeInt(int index) {
        return this.code[index] << 24 | (this.code[index + 1] & 0xFF) << 16 | (this.code[index + 2] & 0xFF) << 8 | this.code[index + 3] & 0xFF;
    }

    private Instruction makeConstantPoolLoad(int index) throws InvalidBytecodeException {
        ConstantInstruction ci = ConstantInstruction.make(this.constantPool, index);
        if (ci == null) {
            throw new InvalidBytecodeException("Constant pool item at index " + index + " (type " + this.constantPool.getConstantPoolItemType(index) + ") cannot be loaded");
        }
        return ci;
    }

    private static int elemCount(byte[] stack, int stackPtr) throws InvalidBytecodeException {
        if (stackPtr < 0) {
            throw new InvalidBytecodeException("Stack underflow");
        }
        if (stack[stackPtr] == 2) {
            return 1;
        }
        if (stackPtr < 1) {
            throw new InvalidBytecodeException("Stack underflow");
        }
        if (stack[stackPtr - 1] != 1) {
            throw new InvalidBytecodeException("Trying to manipulate a pair of one-word items but one of them is two words");
        }
        return 2;
    }

    private String getPrimitiveType(int t) throws InvalidBytecodeException {
        switch (t) {
            case 4: {
                return "Z";
            }
            case 5: {
                return "C";
            }
            case 6: {
                return "F";
            }
            case 7: {
                return "D";
            }
            case 8: {
                return "B";
            }
            case 9: {
                return "S";
            }
            case 10: {
                return "I";
            }
            case 11: {
                return "J";
            }
        }
        throw new InvalidBytecodeException("Unknown primitive type " + t);
    }

    private boolean doesSubroutineReturn(int sub) {
        int j = 0;
        while (j < this.retInfo.length) {
            if (this.retInfo[j] != null && this.retInfo[j].sub == sub) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private int findReturnToVar(int v, int addr, boolean[] visited) throws InvalidBytecodeException {
        while (!visited[addr]) {
            if (this.retInfo[addr] != null && this.retInfo[addr].retVar == v) {
                return addr;
            }
            int offset = this.decodedOffset[addr];
            if (offset == -1) {
                return 0;
            }
            byte size = this.decodedSize[addr];
            Instruction instr = null;
            visited[addr] = true;
            int j = 0;
            while (j < this.rawHandlers.length) {
                if (this.rawHandlers[j] <= addr && addr < this.rawHandlers[j + 1]) {
                    int r;
                    int handlerAddr = this.rawHandlers[j + 2];
                    if (this.decodedOffset[handlerAddr] < 0) {
                        byte[] stackWords = new byte[this.code.length * 2];
                        stackWords[0] = 1;
                        this.decodeAt(handlerAddr, 1, stackWords);
                    }
                    if ((r = this.findReturnToVar(v, handlerAddr, visited)) != 0) {
                        return r;
                    }
                }
                j += 4;
            }
            if (this.JSRs[addr] != 0) {
                if (!this.doesSubroutineReturn(this.JSRs[addr])) {
                    return 0;
                }
            } else {
                j = 0;
                while (j < size) {
                    instr = this.decoded.get(offset + j);
                    if (instr instanceof StoreInstruction && ((StoreInstruction)instr).getVarIndex() == v) {
                        return 0;
                    }
                    int[] targets = instr.getBranchTargets();
                    int k = 0;
                    while (k < targets.length) {
                        int r;
                        if (targets[k] >= 0 && (r = this.findReturnToVar(v, targets[k], visited)) != 0) {
                            return r;
                        }
                        ++k;
                    }
                    ++j;
                }
                if (instr != null && !instr.isFallThrough()) {
                    return 0;
                }
            }
            while (this.decodedOffset[++addr] == -2) {
            }
        }
        return 0;
    }

    private int findReturn(int subAddr) throws InvalidBytecodeException {
        if (this.decodedSize[subAddr] < 1) {
            throw new InvalidBytecodeException("Subroutine at " + subAddr + " does not start with an astore or pop instruction");
        }
        Instruction instr = this.decoded.get(this.decodedOffset[subAddr]);
        if (instr instanceof PopInstruction) {
            return 0;
        }
        if (!(instr instanceof StoreInstruction)) {
            throw new InvalidBytecodeException("Subroutine at " + subAddr + " does not start with an astore or pop instruction");
        }
        int localIndex = ((StoreInstruction)instr).getVarIndex();
        while (this.decodedOffset[++subAddr] == -2) {
        }
        return this.findReturnToVar(localIndex, subAddr, new boolean[this.code.length]);
    }

    private void decodeSubroutine(int jsrAddr, int retToAddr, int subAddr, int stackLen, byte[] stackWords) throws InvalidBytecodeException {
        int retAddr;
        if (this.JSRs == null) {
            this.JSRs = new int[this.code.length];
            this.retInfo = new RetInfo[this.code.length];
        }
        this.JSRs[jsrAddr] = subAddr;
        if (this.decodedOffset[subAddr] < 0) {
            stackWords[stackLen] = 1;
            this.decodeAt(subAddr, ++stackLen, stackWords);
        }
        if ((retAddr = this.findReturn(subAddr)) > 0) {
            RetInfo r = this.retInfo[retAddr];
            r.sub = subAddr;
            byte[] cloneStackWords = new byte[r.stackWords.length];
            System.arraycopy(r.stackWords, 0, cloneStackWords, 0, cloneStackWords.length);
            this.decodeAt(retToAddr, r.stackLen, cloneStackWords);
        }
    }

    private void assignReachablesToSubroutine(int addr, int sub) {
        while (this.belongsToSub[addr] < 0) {
            byte size = this.decodedSize[addr];
            this.belongsToSub[addr] = sub;
            int j = 0;
            while (j < this.rawHandlers.length) {
                if (this.rawHandlers[j] <= addr && addr < this.rawHandlers[j + 1]) {
                    this.assignReachablesToSubroutine(this.rawHandlers[j + 2], sub);
                }
                j += 4;
            }
            Instruction instr = null;
            if (size > 0 && this.JSRs[addr] == 0) {
                int offset = this.decodedOffset[addr];
                instr = this.decoded.get(offset + size - 1);
                int[] targets = instr.getBranchTargets();
                int k = 0;
                while (k < targets.length) {
                    if (targets[k] >= 0) {
                        this.assignReachablesToSubroutine(targets[k], sub);
                    }
                    ++k;
                }
            }
            if (instr != null && !instr.isFallThrough()) {
                return;
            }
            if (this.JSRs[addr] != 0 && !this.doesSubroutineReturn(this.JSRs[addr])) {
                return;
            }
            while (this.decodedOffset[++addr] < 0) {
            }
        }
    }

    private void assignSubroutine(int sub) {
        this.assignReachablesToSubroutine(sub, sub);
        int i = 0;
        while (i < this.belongsToSub.length) {
            if (this.JSRs[i] > 0 && this.belongsToSub[i] == sub && this.belongsToSub[this.JSRs[i]] < 0) {
                this.assignSubroutine(this.JSRs[i]);
            }
            ++i;
        }
    }

    private void computeSubroutineMap() {
        this.belongsToSub = new int[this.code.length];
        int i = 0;
        while (i < this.belongsToSub.length) {
            this.belongsToSub[i] = -1;
            ++i;
        }
        this.assignSubroutine(0);
    }

    private int decodeBytecodeInstruction(int index, int stackLen, byte[] stackWords) throws InvalidBytecodeException {
        int opcode = this.code[index] & 0xFF;
        Instruction i = simpleInstructions[opcode];
        if (i != null) {
            this.decoded.add(i);
            return index + 1;
        }
        boolean wide = false;
        block39: while (true) {
            ++index;
            switch (opcode) {
                case 0: {
                    break block39;
                }
                case 16: {
                    i = ConstantInstruction.make(this.code[index]);
                    ++index;
                    break block39;
                }
                case 17: {
                    i = ConstantInstruction.make(this.decodeShort(index));
                    index += 2;
                    break block39;
                }
                case 18: {
                    i = this.makeConstantPoolLoad(this.code[index] & 0xFF);
                    ++index;
                    break block39;
                }
                case 19: {
                    i = this.makeConstantPoolLoad(this.decodeShort(index));
                    index += 2;
                    break block39;
                }
                case 20: {
                    i = this.makeConstantPoolLoad(this.decodeShort(index));
                    index += 2;
                    break block39;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    i = LoadInstruction.make(indexedTypes[opcode - 21], wide ? this.decodeUShort(index) : this.code[index] & 0xFF);
                    index += wide ? 2 : 1;
                    break block39;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    i = StoreInstruction.make(indexedTypes[opcode - 54], wide ? this.decodeUShort(index) : this.code[index] & 0xFF);
                    index += wide ? 2 : 1;
                    break block39;
                }
                case 88: {
                    i = PopInstruction.make(Decoder.elemCount(stackWords, stackLen - 1));
                    break block39;
                }
                case 91: {
                    i = DupInstruction.make(1, Decoder.elemCount(stackWords, stackLen - 2));
                    break block39;
                }
                case 92: {
                    i = DupInstruction.make(Decoder.elemCount(stackWords, stackLen - 1), 0);
                    break block39;
                }
                case 93: {
                    i = DupInstruction.make(Decoder.elemCount(stackWords, stackLen - 1), 1);
                    break block39;
                }
                case 94: {
                    i = DupInstruction.make(Decoder.elemCount(stackWords, stackLen - 1), Decoder.elemCount(stackWords, stackLen - 2));
                    break block39;
                }
                case 132: {
                    int v = wide ? this.decodeUShort(index) : this.code[index] & 0xFF;
                    int c = wide ? this.decodeShort(index + 2) : this.code[index + 1];
                    this.decoded.add(LoadInstruction.make("I", v));
                    this.decoded.add(ConstantInstruction.make(c));
                    this.decoded.add(BinaryOpInstruction.make("I", IBinaryOpInstruction.Operator.ADD));
                    i = StoreInstruction.make("I", v);
                    index += wide ? 4 : 2;
                    break block39;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: {
                    this.decoded.add(makeZero);
                    i = ConditionalBranchInstruction.make("I", IConditionalBranchInstruction.Operator.values()[opcode - 153], index - 1 + this.decodeShort(index));
                    index += 2;
                    break block39;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    i = ConditionalBranchInstruction.make((short)opcode, index - 1 + this.decodeShort(index));
                    index += 2;
                    break block39;
                }
                case 165: 
                case 166: {
                    i = ConditionalBranchInstruction.make("Ljava/lang/Object;", IConditionalBranchInstruction.Operator.values()[opcode - 165], index - 1 + this.decodeShort(index));
                    index += 2;
                    break block39;
                }
                case 167: {
                    i = GotoInstruction.make(index - 1 + this.decodeShort(index));
                    index += 2;
                    break block39;
                }
                case 168: {
                    index += 2;
                    break block39;
                }
                case 201: {
                    index += 4;
                    break block39;
                }
                case 169: {
                    int v = wide ? this.decodeUShort(index) : this.code[index] & 0xFF;
                    i = GotoInstruction.make(-1 - v);
                    if (this.retInfo == null) {
                        throw new InvalidBytecodeException("'ret' outside of subroutine");
                    }
                    this.retInfo[index - (wide ? 2 : 1)] = new RetInfo(-1, v, stackLen, stackWords);
                    index += wide ? 2 : 1;
                    break block39;
                }
                case 170: {
                    int start = index - 1;
                    while ((index & 3) != 0) {
                        ++index;
                    }
                    int def = start + this.decodeInt(index);
                    int low = this.decodeInt(index + 4);
                    int high = this.decodeInt(index + 8);
                    int[] t = new int[(high - low + 1) * 2];
                    int j = 0;
                    while (j < t.length) {
                        t[j] = j / 2 + low;
                        t[j + 1] = start + this.decodeInt(index + 12 + j * 2);
                        j += 2;
                    }
                    i = SwitchInstruction.make(t, def);
                    index += 12 + (high - low + 1) * 4;
                    break block39;
                }
                case 171: {
                    int start = index - 1;
                    while ((index & 3) != 0) {
                        ++index;
                    }
                    int def = start + this.decodeInt(index);
                    int n = this.decodeInt(index + 4);
                    int[] t = new int[n * 2];
                    int j = 0;
                    while (j < t.length) {
                        t[j] = this.decodeInt(index + 8 + j * 4);
                        t[j + 1] = start + this.decodeInt(index + 12 + j * 4);
                        j += 2;
                    }
                    i = SwitchInstruction.make(t, def);
                    index += 8 + n * 8;
                    break block39;
                }
                case 178: 
                case 180: {
                    int f = this.decodeUShort(index);
                    i = GetInstruction.make(this.constantPool, f, opcode == 178);
                    index += 2;
                    break block39;
                }
                case 179: 
                case 181: {
                    int f = this.decodeUShort(index);
                    i = PutInstruction.make(this.constantPool, f, opcode == 179);
                    index += 2;
                    break block39;
                }
                case 182: 
                case 183: 
                case 184: {
                    int m = this.decodeUShort(index);
                    i = InvokeInstruction.make(this.constantPool, m, opcode);
                    index += 2;
                    break block39;
                }
                case 185: {
                    int m = this.decodeUShort(index);
                    i = InvokeInstruction.make(this.constantPool, m, opcode);
                    index += 4;
                    break block39;
                }
                case 186: {
                    int m = this.decodeUShort(index);
                    i = InvokeDynamicInstruction.make(this.constantPool, m, opcode);
                    index += 4;
                    break block39;
                }
                case 187: {
                    i = NewInstruction.make(this.constantPool.getConstantPoolClassType(this.decodeUShort(index)), 0);
                    index += 2;
                    break block39;
                }
                case 188: {
                    i = NewInstruction.make(Util.makeArray(this.getPrimitiveType(this.code[index])), 1);
                    ++index;
                    break block39;
                }
                case 189: {
                    i = NewInstruction.make(Util.makeArray(this.constantPool.getConstantPoolClassType(this.decodeUShort(index))), 1);
                    index += 2;
                    break block39;
                }
                case 192: {
                    i = CheckCastInstruction.make(this.constantPool.getConstantPoolClassType(this.decodeUShort(index)));
                    index += 2;
                    break block39;
                }
                case 193: {
                    i = InstanceofInstruction.make(this.constantPool.getConstantPoolClassType(this.decodeUShort(index)));
                    index += 2;
                    break block39;
                }
                case 196: {
                    wide = true;
                    opcode = this.code[index] & 0xFF;
                    continue block39;
                }
                case 197: {
                    i = NewInstruction.make(this.constantPool.getConstantPoolClassType(this.decodeUShort(index)), this.code[index + 2] & 0xFF);
                    index += 3;
                    break block39;
                }
                case 198: 
                case 199: {
                    this.decoded.add(ConstantInstruction.make("Ljava/lang/Object;", null));
                    i = ConditionalBranchInstruction.make("Ljava/lang/Object;", IConditionalBranchInstruction.Operator.values()[opcode - 198], index - 1 + this.decodeShort(index));
                    index += 2;
                    break block39;
                }
                case 200: {
                    i = GotoInstruction.make(index - 1 + this.decodeInt(index));
                    index += 4;
                    break block39;
                }
                default: {
                    throw new InvalidBytecodeException("Unknown opcode " + opcode);
                }
            }
            break;
        }
        if (i != null) {
            this.decoded.add(i);
        }
        return index;
    }

    private int applyInstructionToStack(Instruction i, int stackLen, byte[] stackWords) throws InvalidBytecodeException {
        if ((stackLen -= i.getPoppedCount()) < 0) {
            throw new InvalidBytecodeException("Stack underflow");
        }
        if (i instanceof DupInstruction) {
            DupInstruction d = (DupInstruction)i;
            int delta = d.getDelta();
            int size = d.getSize();
            System.arraycopy(stackWords, stackLen + delta, stackWords, stackLen + size + delta, size);
            System.arraycopy(stackWords, stackLen, stackWords, stackLen + size, delta);
            System.arraycopy(stackWords, stackLen + size + delta, stackWords, stackLen, size);
            stackLen += size * 2 + delta;
        } else if (i instanceof SwapInstruction) {
            if (stackWords[stackLen] != stackWords[stackLen + 1]) {
                throw new Error("OP_swap must always be swapping the same size, 1");
            }
            stackLen += 2;
        } else {
            byte pushedWords = i.getPushedWordSize();
            if (pushedWords > 0) {
                stackWords[stackLen] = pushedWords;
                ++stackLen;
            }
        }
        return stackLen;
    }

    /*
     * Unable to fully structure code
     */
    private void decodeAt(int index, int stackLen, byte[] stackWords) throws InvalidBytecodeException {
        if (index >= 0 && index < this.decodedOffset.length) ** GOTO lbl55
        throw new InvalidBytecodeException(index, "Branch index " + index + " out of range");
lbl-1000:
        // 1 sources

        {
            this.decodedOffset[index] = s = this.decoded.size();
            try {
                newIndex = this.decodeBytecodeInstruction(index, stackLen, stackWords);
                instrCount = this.decoded.size() - s;
                this.decodedSize[index] = (byte)instrCount;
                i = index + 1;
                while (i < newIndex) {
                    this.decodedOffset[i] = -2;
                    ++i;
                }
                if (instrCount > 0) {
                    i = s;
                    while (i < s + instrCount) {
                        stackLen = this.applyInstructionToStack(this.decoded.get(i), stackLen, stackWords);
                        ++i;
                    }
                    instr = this.decoded.get(s + instrCount - 1);
                    targets = instr.getBranchTargets();
                    i = 0;
                    while (i < targets.length) {
                        t = targets[i];
                        if (t >= 0) {
                            this.decodeAt(t, stackLen, (byte[])stackWords.clone());
                        }
                        ++i;
                    }
                    if (!instr.isFallThrough()) {
                        return;
                    }
                } else {
                    jIndex = index;
                    opcode = this.code[jIndex] & 255;
                    if (opcode == 196) {
                        opcode = this.code[++jIndex] & 255;
                    }
                    if (opcode == 168 || opcode == 201) {
                        offset = opcode == 201 ? this.decodeInt(jIndex) : this.decodeShort(++jIndex);
                        this.decoded.add(GotoInstruction.make(0));
                        this.decodedSize[index] = 1;
                        this.decodeSubroutine(index, newIndex, index + offset, stackLen, stackWords);
                        return;
                    }
                }
            }
            catch (InvalidBytecodeException ex) {
                ex.setIndex(index);
                throw ex;
            }
            catch (Error ex) {
                System.err.println("Fatal error at index " + index);
                throw ex;
            }
            catch (RuntimeException ex) {
                System.err.println("Fatal error at index " + index);
                throw ex;
            }
            index = newIndex;
            if (index < this.decodedOffset.length) continue;
            throw new InvalidBytecodeException(index, "Fell off end of bytecode array");
lbl55:
            // 2 sources

            ** while (this.decodedOffset[index] < 0)
        }
lbl56:
        // 1 sources

    }

    private ExceptionHandler[] makeHandlers(int i, int[] addrMap) {
        int numHandlers = 0;
        int j = 0;
        while (j < this.rawHandlers.length) {
            if (this.rawHandlers[j] <= i && i < this.rawHandlers[j + 1]) {
                ++numHandlers;
            }
            j += 4;
        }
        return this.makeHandlers(i, numHandlers, addrMap);
    }

    private ExceptionHandler[] makeHandlers(int i, int numHandlers, int[] addrMap) {
        if (numHandlers == 0) {
            return noHandlers;
        }
        ExceptionHandler[] hs = new ExceptionHandler[numHandlers];
        numHandlers = 0;
        int j = 0;
        while (j < this.rawHandlers.length) {
            if (this.rawHandlers[j] <= i && i < this.rawHandlers[j + 1]) {
                int classIndex = this.rawHandlers[j + 3];
                String catchClass = classIndex == 0 ? null : this.constantPool.getConstantPoolClassType(classIndex);
                hs[numHandlers] = new ExceptionHandler(addrMap[this.rawHandlers[j + 2]], catchClass);
                ++numHandlers;
            }
            j += 4;
        }
        return hs;
    }

    private int computeSubroutineLength(int sub) {
        int len = 1;
        int i = sub;
        while (i < this.belongsToSub.length) {
            if (this.belongsToSub[i] == sub) {
                len += this.decodedSize[i];
                if (this.JSRs[i] > 0) {
                    len += this.computeSubroutineLength(this.JSRs[i]);
                }
            }
            ++i;
        }
        return len;
    }

    private int appendSubroutineCode(int callSite, int newCodeIndex, int[] callerMap) {
        int sub;
        this.instructions[callerMap[callSite]] = GotoInstruction.make(newCodeIndex);
        this.instructions[newCodeIndex] = ConstantInstruction.make("Ljava/lang/Object;", null);
        int subStart = ++newCodeIndex;
        int[] map = (int[])callerMap.clone();
        int i = sub = this.JSRs[callSite];
        while (i < this.belongsToSub.length) {
            if (this.belongsToSub[i] == sub) {
                int s = this.decodedSize[i];
                int offset = this.decodedOffset[i];
                map[i] = newCodeIndex;
                int j = 0;
                while (j < s) {
                    Instruction instr = this.decoded.get(offset + j);
                    this.instructions[newCodeIndex] = instr;
                    this.instructionsToBytecodes[newCodeIndex] = i;
                    ++newCodeIndex;
                    ++j;
                }
            }
            ++i;
        }
        i = subStart;
        while (i < newCodeIndex) {
            IInstruction instr = this.instructions[i];
            this.instructions[i] = instr instanceof GotoInstruction && ((GotoInstruction)instr).getLabel() < 0 ? GotoInstruction.make(callerMap[callSite] + 1) : instr.redirectTargets(map);
            this.handlers[i] = this.makeHandlers(this.instructionsToBytecodes[i], map);
            ++i;
        }
        this.handlers[subStart - 1] = this.handlers[subStart];
        i = sub;
        while (i < this.belongsToSub.length) {
            if (this.belongsToSub[i] == sub && this.JSRs[i] > 0) {
                newCodeIndex = this.appendSubroutineCode(i, newCodeIndex, map);
            }
            ++i;
        }
        return newCodeIndex;
    }

    public final void decode() throws InvalidBytecodeException {
        byte[] stackWords = new byte[this.code.length * 2];
        this.decoded = new ArrayList();
        this.decodedOffset = new int[this.code.length];
        int i = 0;
        while (i < this.decodedOffset.length) {
            this.decodedOffset[i] = -1;
            ++i;
        }
        this.decodedSize = new byte[this.code.length];
        this.decodeAt(0, 0, stackWords);
        i = 0;
        while (i < this.rawHandlers.length) {
            stackWords[0] = 1;
            this.decodeAt(this.rawHandlers[i + 2], 1, stackWords);
            i += 4;
        }
        if (this.retInfo != null) {
            this.computeSubroutineMap();
            this.retInfo = null;
        }
        int instructionsLen = this.decoded.size();
        if (this.belongsToSub != null) {
            int i2 = 0;
            while (i2 < this.belongsToSub.length) {
                if (this.belongsToSub[i2] == 0) {
                    if (this.JSRs[i2] > 0) {
                        instructionsLen += this.computeSubroutineLength(this.JSRs[i2]);
                    }
                } else if (this.belongsToSub[i2] > 0) {
                    instructionsLen -= this.decodedSize[i2];
                }
                ++i2;
            }
        }
        this.instructions = new Instruction[instructionsLen];
        this.instructionsToBytecodes = new int[instructionsLen];
        this.handlers = new ExceptionHandler[instructionsLen][];
        int p = 0;
        int i3 = 0;
        while (i3 < this.decodedOffset.length) {
            int offset = this.decodedOffset[i3];
            if (offset >= 0 && (this.belongsToSub == null || this.belongsToSub[i3] == 0)) {
                this.decodedOffset[i3] = p;
                int s = this.decodedSize[i3];
                int j = 0;
                while (j < s) {
                    this.instructions[p] = this.decoded.get(offset + j);
                    this.instructionsToBytecodes[p] = i3;
                    ++p;
                    ++j;
                }
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < p) {
            this.instructions[i3] = this.instructions[i3].redirectTargets(this.decodedOffset);
            ++i3;
        }
        if (this.JSRs != null) {
            i3 = 0;
            while (i3 < this.JSRs.length) {
                if (this.JSRs[i3] > 0 && this.belongsToSub[i3] == 0) {
                    p = this.appendSubroutineCode(i3, p, this.decodedOffset);
                }
                ++i3;
            }
        }
        if (this.rawHandlers.length > 0) {
            ExceptionHandler[] hs = null;
            int handlersValidBefore = -1;
            p = 0;
            int i4 = 0;
            while (i4 < this.decodedOffset.length) {
                if (this.decodedOffset[i4] >= 0 && (this.belongsToSub == null || this.belongsToSub[i4] == 0)) {
                    int j;
                    if (i4 >= handlersValidBefore) {
                        int numHandlers = 0;
                        handlersValidBefore = Integer.MAX_VALUE;
                        j = 0;
                        while (j < this.rawHandlers.length) {
                            if (this.rawHandlers[j] <= i4) {
                                if (i4 < this.rawHandlers[j + 1]) {
                                    ++numHandlers;
                                    handlersValidBefore = Math.min(handlersValidBefore, this.rawHandlers[j + 1]);
                                }
                            } else {
                                handlersValidBefore = Math.min(handlersValidBefore, this.rawHandlers[j]);
                            }
                            j += 4;
                        }
                        hs = this.makeHandlers(i4, numHandlers, this.decodedOffset);
                    }
                    int s = this.decodedSize[i4];
                    j = 0;
                    while (j < s) {
                        this.handlers[p] = hs;
                        ++p;
                        ++j;
                    }
                }
                ++i4;
            }
        } else {
            i3 = 0;
            while (i3 < this.handlers.length) {
                this.handlers[i3] = noHandlers;
                ++i3;
            }
        }
        this.decoded = null;
        this.decodedOffset = null;
        this.decodedSize = null;
        this.belongsToSub = null;
        this.JSRs = null;
    }

    public final IInstruction[] getInstructions() {
        if (this.instructions == null) {
            throw new Error("Call decode() before calling getInstructions()");
        }
        return this.instructions;
    }

    public final ExceptionHandler[][] getHandlers() {
        if (this.handlers == null) {
            throw new Error("Call decode() before calling getHandlers()");
        }
        return this.handlers;
    }

    public final int[] getInstructionsToBytecodes() {
        if (this.instructionsToBytecodes == null) {
            throw new Error("Call decode() before calling getInstructionsToBytecodes()");
        }
        return this.instructionsToBytecodes;
    }

    public final boolean containsSubroutines() {
        if (this.instructions == null) {
            throw new Error("Call decode() before calling containsSubroutines()");
        }
        return this.JSRs != null;
    }

    public static class InvalidBytecodeException
    extends Exception {
        private static final long serialVersionUID = -8807125136613458111L;
        private int index;

        InvalidBytecodeException(String s) {
            super(s);
            this.index = -1;
        }

        InvalidBytecodeException(int i, String s) {
            super(s);
            this.index = i;
        }

        void setIndex(int i) {
            if (this.index < 0) {
                this.index = i;
            }
        }

        public int getIndex() {
            return this.index;
        }
    }

    private static class RetInfo {
        int sub;
        final int retVar;
        final int stackLen;
        final byte[] stackWords;

        RetInfo(int sub, int retVar, int stackLen, byte[] stackWords) {
            this.sub = sub;
            this.retVar = retVar;
            this.stackLen = stackLen;
            this.stackWords = stackWords;
        }
    }
}

