/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.instrumentation;

import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.SourceFileReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;

public class CodeScraper
implements ClassFileTransformer {
    private static final String prefix = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "loggedClasses" + File.separator + System.currentTimeMillis();

    static {
        System.err.println("scraping to " + prefix);
        new File(prefix).mkdirs();
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            block16: {
                String sourceFile = null;
                ClassReader reader = new ClassReader(classfileBuffer);
                ClassReader.AttrIterator attrs = new ClassReader.AttrIterator();
                reader.initClassAttributeIterator(attrs);
                while (attrs.isValid()) {
                    if (attrs.getName().equals("SourceFile")) {
                        SourceFileReader file = new SourceFileReader(attrs);
                        int index = file.getSourceFileCPIndex();
                        sourceFile = reader.getCP().getCPUtf8(index);
                    }
                    attrs.advance();
                }
                if (className != null && sourceFile != null) {
                    sourceFile.endsWith("java");
                }
                try {
                    String log = String.valueOf(prefix) + File.separator + reader.getName() + ".class";
                    new File(log).getParentFile().mkdirs();
                    Throwable throwable = null;
                    Object var11_15 = null;
                    try (FileOutputStream f = new FileOutputStream(log);){
                        f.write(classfileBuffer);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block16;
                    throw new AssertionError((Object)e);
                }
            }
            return classfileBuffer;
        }
        catch (InvalidClassFileException e1) {
            e1.printStackTrace();
            throw new IllegalClassFormatException(e1.getLocalizedMessage());
        }
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        inst.addTransformer(new CodeScraper());
    }
}

