/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.cg;

import com.ibm.wala.util.config.FileOfClasses;
import com.ibm.wala.util.config.SetOfClasses;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Stack;
import java.util.zip.GZIPOutputStream;

public class Runtime {
    private static final Runtime runtime = new Runtime(System.getProperty("dynamicCGFile"), System.getProperty("dynamicCGFilter"), System.getProperty("policyClass", "com.ibm.wala.shrike.cg.Runtime$DefaultPolicy"));
    private PrintWriter output;
    private SetOfClasses filter;
    private Policy handleCallback;
    private String currentSite;
    private ThreadLocal<Stack<String>> callStacks = new ThreadLocal<Stack<String>>(){

        @Override
        protected Stack<String> initialValue() {
            Stack<String> callStack = new Stack<String>();
            callStack.push("root");
            return callStack;
        }
    };
    public static Object NULL_TAG = new Object(){

        public String toString() {
            return "NULL TAG";
        }
    };

    private Runtime(String fileName, String filterFileName, String policyClassName) {
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileInputStream in = new FileInputStream(filterFileName);){
                this.filter = new FileOfClasses((InputStream)in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            this.filter = null;
        }
        try {
            this.output = new PrintWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(fileName)), "UTF-8"));
        }
        catch (IOException iOException) {
            this.output = new PrintWriter(System.err);
        }
        try {
            this.handleCallback = (Policy)Class.forName(policyClassName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            this.handleCallback = new DefaultCallbackPolicy();
        }
        java.lang.Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Runtime.endTrace();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endTrace() {
        Runtime runtime = Runtime.runtime;
        synchronized (runtime) {
            if (Runtime.runtime.output != null) {
                Runtime.runtime.output.close();
                Runtime.runtime.output = null;
            }
        }
    }

    public static String bashToDescriptor(String className) {
        if (className.startsWith("class ")) {
            className = className.substring(6);
        }
        if (className.indexOf(46) >= 0) {
            className = className.replace('.', '/');
        }
        return className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execution(String klass, String method, Object receiver) {
        Runtime.runtime.currentSite = null;
        if (!(Runtime.runtime.filter != null && Runtime.runtime.filter.contains(Runtime.bashToDescriptor(klass)) || Runtime.runtime.output == null)) {
            StackTraceElement callerFrame;
            StackTraceElement[] stack;
            String caller = Runtime.runtime.callStacks.get().peek();
            if (!(Runtime.runtime.handleCallback == null || (stack = new Throwable().getStackTrace()).length <= 2 || caller.contains((callerFrame = stack[2]).getMethodName()) && caller.contains(Runtime.bashToDescriptor(callerFrame.getClassName())))) {
                Runtime.runtime.handleCallback.callback(stack, klass, method, receiver);
            } else {
                String line = String.valueOf(method.contains("<clinit>") ? "clinit" : String.valueOf(caller)) + "\t" + Runtime.bashToDescriptor(klass) + "\t" + String.valueOf(method) + "\n";
                Runtime runtime = Runtime.runtime;
                synchronized (runtime) {
                    if (Runtime.runtime.output != null) {
                        Runtime.runtime.output.printf(line, new Object[0]);
                        Runtime.runtime.output.flush();
                    }
                }
            }
        }
        Runtime.runtime.callStacks.get().push(String.valueOf(Runtime.bashToDescriptor(klass)) + "\t" + method);
    }

    public static void termination(String klass, String method, Object receiver, boolean exception) {
        Runtime.runtime.callStacks.get().pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pop(String klass, String method) {
        if (Runtime.runtime.currentSite != null) {
            Runtime runtime = Runtime.runtime;
            synchronized (runtime) {
                if (Runtime.runtime.output != null) {
                    Runtime.runtime.output.printf("return from " + Runtime.runtime.currentSite + "\n", new Object[0]);
                    Runtime.runtime.output.flush();
                }
            }
            Runtime.runtime.currentSite = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToCallStack(String klass, String method, Object receiver) {
        Runtime.runtime.currentSite = String.valueOf(klass) + "\t" + method + "\t" + receiver;
        Runtime runtime = Runtime.runtime;
        synchronized (runtime) {
            if (Runtime.runtime.output != null) {
                Runtime.runtime.output.printf("call to " + Runtime.runtime.currentSite + "\n", new Object[0]);
                Runtime.runtime.output.flush();
            }
        }
    }

    private static class DefaultCallbackPolicy
    implements Policy {
        private DefaultCallbackPolicy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callback(StackTraceElement[] stack, String klass, String method, Object receiver) {
            String root = "<clinit>".equals(stack[1].getMethodName()) ? "clinit" : ("finalize".equals(stack[1].getMethodName()) ? "root" : "callbacks");
            String line = String.valueOf(root) + "\t" + Runtime.bashToDescriptor(klass) + "\t" + String.valueOf(method) + "\n";
            Runtime runtime = runtime;
            synchronized (runtime) {
                if (runtime.output != null) {
                    runtime.output.printf(line, new Object[0]);
                    runtime.output.flush();
                }
            }
        }
    }

    public static interface Policy {
        public void callback(StackTraceElement[] var1, String var2, String var3, Object var4);
    }
}

