/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.hunter.streamrefactoring.ui.handlers;

import edu.cuny.hunter.streamrefactoring.ui.messages.Messages;
import edu.cuny.hunter.streamrefactoring.ui.wizards.OptimizeStreamRefactoringWizard;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class OptimizeStreamHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Optional.empty();
        ISelection currentSelection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        List list = SelectionUtil.toList((ISelection)currentSelection);
        HashSet<IJavaProject> javaProjectSet = new HashSet<IJavaProject>();
        if (list != null) {
            try {
                for (Object obj : list) {
                    if (!(obj instanceof IJavaElement)) continue;
                    IJavaElement jElem = (IJavaElement)obj;
                    switch (jElem.getElementType()) {
                        case 2: {
                            javaProjectSet.add((IJavaProject)jElem);
                        }
                    }
                }
                Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
                if (javaProjectSet.isEmpty()) {
                    MessageDialog.openError((Shell)shell, (String)Messages.Name, (String)Messages.NoProjects);
                } else {
                    OptimizeStreamRefactoringWizard.startRefactoring(javaProjectSet.toArray(new IJavaProject[javaProjectSet.size()]), shell, Optional.empty());
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log((Throwable)e);
                throw new ExecutionException("Failed to start refactoring", (Throwable)e);
            }
        }
        return null;
    }
}

