/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.tables;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.SimpleVector;
import com.ibm.wala.util.intset.BitVector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Table<T> {
    protected final ArrayList<SimpleVector<T>> rows = new ArrayList();
    protected final SimpleVector<String> columnHeadings = new SimpleVector();

    public Table() {
    }

    public Table(Table<T> t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        int i = 0;
        while (i < t.getNumberOfColumns()) {
            this.columnHeadings.set(i, t.getColumnHeading(i));
            ++i;
        }
    }

    public Table(String[] columns) throws IllegalArgumentException {
        if (columns == null) {
            throw new IllegalArgumentException("columns == null");
        }
        int i = 0;
        while (i < columns.length) {
            if (columns[i] == null) {
                throw new IllegalArgumentException("columns[" + i + "] is null");
            }
            this.columnHeadings.set(i, columns[i]);
            ++i;
        }
    }

    public String toString() {
        int[] format = this.computeColumnWidths();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.getNumberOfColumns()) {
            StringBuffer heading = new StringBuffer(this.getColumnHeading(i));
            Table.padWithSpaces(heading, format[i]);
            result.append(heading);
            ++i;
        }
        result.append("\n");
        int j = 0;
        while (j < this.getNumberOfRows()) {
            int i2 = 0;
            while (i2 < this.getNumberOfColumns()) {
                T e = this.getElement(j, i2);
                StringBuffer element = e == null ? new StringBuffer() : new StringBuffer(e.toString());
                Table.padWithSpaces(element, format[i2]);
                result.append(element);
                ++i2;
            }
            result.append("\n");
            ++j;
        }
        return result.toString();
    }

    public synchronized T getElement(int row, int column) {
        try {
            SimpleVector<T> r = this.rows.get(row);
            return r.get(column);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("row: " + row + " column: " + column);
        }
    }

    public synchronized String getColumnHeading(int i) {
        return this.columnHeadings.get(i);
    }

    public int[] computeColumnWidths() {
        int[] result = new int[this.getNumberOfColumns()];
        int i = 0;
        while (i < this.getNumberOfColumns()) {
            result[i] = this.columnHeadings.get(i).length() + 1;
            ++i;
        }
        int j = 0;
        while (j < this.getNumberOfRows()) {
            int i2 = 0;
            while (i2 < this.getNumberOfColumns()) {
                T element = this.getElement(j, i2);
                result[i2] = element == null ? result[i2] : Math.max(result[i2], element.toString().length() + 1);
                ++i2;
            }
            ++j;
        }
        return result;
    }

    public synchronized int getNumberOfColumns() {
        return this.columnHeadings.getMaxIndex() + 1;
    }

    public synchronized int getNumberOfRows() {
        return this.rows.size();
    }

    public synchronized Map<String, T> row2Map(int row) {
        HashMap<String, T> result = HashMapFactory.make();
        int j = 0;
        while (j < this.getNumberOfColumns()) {
            result.put(this.getColumnHeading(j), this.getElement(row, j));
            ++j;
        }
        return result;
    }

    public synchronized void addRow(Map<String, T> p) {
        if (p == null) {
            throw new IllegalArgumentException("null p " + p);
        }
        SimpleVector<T> r = new SimpleVector<T>();
        this.rows.add(r);
        int i = 0;
        while (i < this.getNumberOfColumns()) {
            r.set(i, p.get(this.getColumnHeading(i)));
            ++i;
        }
    }

    public synchronized void removeRow(Map<String, T> p) {
        if (p == null) {
            throw new IllegalArgumentException("p is null");
        }
        BitVector toRemove = new BitVector();
        int i = 0;
        while (i < this.rows.size()) {
            Map<String, T> row = this.row2Map(i);
            if (row.equals(p)) {
                toRemove.set(i);
            }
            ++i;
        }
        i = 0;
        while (i < this.rows.size()) {
            if (toRemove.get(i)) {
                this.rows.remove(i);
            }
            ++i;
        }
    }

    public static void padWithSpaces(StringBuffer b, int length) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (b.length() < length) {
            int i = b.length();
            while (i < length) {
                b.append(" ");
                ++i;
            }
        }
    }
}

