/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class TemporaryFile {
    private static final String outputDir;

    static {
        String dir = System.getProperty("java.io.tmpdir");
        while (dir.endsWith(File.separator)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        outputDir = dir = String.valueOf(dir) + File.separator;
    }

    public static File urlToFile(String fileName, URL input) throws IOException {
        File F = new File(String.valueOf(outputDir) + File.separator + fileName);
        return TemporaryFile.urlToFile(F, input);
    }

    public static File urlToFile(File F, URL input) throws IOException {
        return TemporaryFile.streamToFile(F, input.openStream());
    }

    public static File streamToFile(File F, InputStream ... inputs) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream output = new FileOutputStream(F);){
            byte[] buffer = new byte[1024];
            InputStream[] inputStreamArray = inputs;
            int n = inputs.length;
            int n2 = 0;
            while (n2 < n) {
                int read;
                InputStream input = inputStreamArray[n2];
                while ((read = input.read(buffer)) != -1) {
                    output.write(buffer, 0, read);
                }
                input.close();
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return F;
    }

    public static File stringToFile(File F, String ... inputs) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream output = new FileOutputStream(F);){
            String[] stringArray = inputs;
            int n = inputs.length;
            int n2 = 0;
            while (n2 < n) {
                String input = stringArray[n2];
                output.write(input.getBytes());
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return F;
    }
}

