/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.io;

import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.functions.VoidFunction;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;

public class FileUtil {
    public static Collection<File> listFiles(String dir, String regex, boolean recurse) {
        if (dir == null) {
            throw new IllegalArgumentException("dir is null");
        }
        File d = new File(dir);
        Pattern p = null;
        if (regex != null) {
            p = Pattern.compile(regex);
        }
        return FileUtil.listFiles(d, recurse, p);
    }

    private static Collection<File> listFiles(File directory, boolean recurse, Pattern p) {
        File[] files = directory.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        HashSet<File> result = HashSetFactory.make();
        int i = 0;
        while (i < files.length) {
            if (p == null || p.matcher(files[i].getAbsolutePath()).matches()) {
                result.add(files[i]);
            }
            if (recurse && files[i].isDirectory()) {
                result.addAll(FileUtil.listFiles(files[i], recurse, p));
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copy(String srcFileName, String destFileName) throws IOException {
        if (srcFileName == null) {
            throw new IllegalArgumentException("srcFileName is null");
        }
        if (destFileName == null) {
            throw new IllegalArgumentException("destFileName is null");
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream srcStream = new FileInputStream(srcFileName);
            try {
                block26: {
                    FileOutputStream dstStream = new FileOutputStream(destFileName);
                    try {
                        block25: {
                            FileChannel src = srcStream.getChannel();
                            try {
                                try (FileChannel dest = dstStream.getChannel();){
                                    long n = src.size();
                                    MappedByteBuffer buf = src.map(FileChannel.MapMode.READ_ONLY, 0L, n);
                                    dest.write(buf);
                                }
                                if (src == null) break block25;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (src == null) throw throwable;
                                src.close();
                                throw throwable;
                            }
                            src.close();
                        }
                        if (dstStream == null) break block26;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (dstStream == null) throw throwable;
                        dstStream.close();
                        throw throwable;
                    }
                    dstStream.close();
                }
                if (srcStream == null) return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (srcStream == null) throw throwable;
                srcStream.close();
                throw throwable;
            }
            srcStream.close();
            return;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    public static void deleteContents(String directory) throws IOException {
        File f = new File(directory);
        if (!f.exists()) {
            return;
        }
        if (!f.isDirectory()) {
            throw new IOException(String.valueOf(directory) + " is not a vaid directory");
        }
        String[] stringArray = f.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            FileUtil.deleteRecursively(new File(f, s));
            ++n2;
        }
    }

    private static void deleteRecursively(File f) throws IOException {
        boolean b;
        if (f.isDirectory()) {
            String[] stringArray = f.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                FileUtil.deleteRecursively(new File(f, s));
                ++n2;
            }
        }
        if (!(b = f.delete())) {
            throw new IOException("failed to delete " + f);
        }
    }

    public static final FileOutputStream createFile(String fileName) throws IOException {
        boolean result;
        if (fileName == null) {
            throw new IllegalArgumentException("null file");
        }
        File f = new File(fileName);
        if (f.getParentFile() != null && !f.getParentFile().exists() && !(result = f.getParentFile().mkdirs())) {
            throw new IOException("failed to create " + f.getParentFile());
        }
        if (f.exists()) {
            f.delete();
        }
        if (!(result = f.createNewFile())) {
            throw new IOException("failed to create " + f);
        }
        return new FileOutputStream(f);
    }

    public static byte[] readBytes(InputStream s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("null s");
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] b = new byte[1024];
            int n = s.read(b);
            while (n != -1) {
                out.write(b, 0, n);
                n = s.read(b);
            }
            byte[] bb = out.toByteArray();
            return bb;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void writeFile(File f, String content) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter fw = new FileWriter(f);){
            fw.append(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void recurseFiles(VoidFunction<File> action, final Predicate<File> filter, File top) {
        if (top.isDirectory()) {
            File[] fileArray = top.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return filter.test(file) || file.isDirectory();
                }
            });
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                FileUtil.recurseFiles(action, filter, f);
                ++n2;
            }
        } else {
            action.apply(top);
        }
    }
}

