/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.intset.SimpleIntVector;

public class Path
extends SimpleIntVector {
    final int size;

    private Path(int defaultValue, int size) {
        super(defaultValue, size);
        this.size = size;
    }

    public static Path make(int value) {
        return new Path(value, 1);
    }

    public static Path prepend(int x, Path p) {
        if (p == null) {
            throw new IllegalArgumentException("null p");
        }
        Path result = new Path(0, p.size + 1);
        result.set(0, x);
        int i = 0;
        while (i < p.size) {
            result.set(i + 1, p.get(i));
            ++i;
        }
        return result;
    }

    public int hashCode() {
        int result = 7;
        int i = 0;
        while (i < this.size) {
            result += 31 * (this.get(i) + 1);
            ++i;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Path) {
            Path other = (Path)obj;
            if (this.size == other.size) {
                int i = 0;
                while (i < this.size) {
                    if (this.get(i) != other.get(i)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[");
        int i = 0;
        while (i < this.size) {
            result.append(this.get(i));
            if (i < this.size - 1) {
                result.append(",");
            }
            ++i;
        }
        result.append("]");
        return result.toString();
    }
}

