/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util;

import java.io.File;
import java.util.ArrayList;

public class PlatformUtil {
    public static boolean onMacOSX() {
        String osname = System.getProperty("os.name");
        return osname.toLowerCase().contains("mac");
    }

    public static boolean onLinux() {
        String osname = System.getProperty("os.name");
        return osname.equalsIgnoreCase("linux");
    }

    public static boolean onWindows() {
        String osname = System.getProperty("os.name");
        return osname.toLowerCase().contains("windows");
    }

    public static boolean onIKVM() {
        return "IKVM.NET".equals(System.getProperty("java.runtime.name"));
    }

    public static String[] getBootClassPathJars() {
        String classpath = System.getProperty("sun.boot.class.path");
        if (classpath == null) {
            throw new IllegalStateException("could not find boot classpath");
        }
        String[] jars = classpath.split(File.pathSeparator);
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = jars;
        int n = jars.length;
        int n2 = 0;
        while (n2 < n) {
            String jar = stringArray[n2];
            if (jar.endsWith(".jar") && new File(jar).exists()) {
                result.add(jar);
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }
}

