/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.fixpoint;

import com.ibm.wala.fixpoint.AbstractStatement;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.fixpoint.UnaryOperator;

public abstract class UnaryStatement<T extends IVariable>
extends AbstractStatement<T, UnaryOperator<T>> {
    protected final T lhs;
    protected final T rhs;

    @Override
    public byte evaluate() {
        UnaryOperator op = (UnaryOperator)this.getOperator();
        return op.evaluate(this.lhs, this.rhs);
    }

    @Override
    public T getLHS() {
        return this.lhs;
    }

    public T getRightHandSide() {
        return this.rhs;
    }

    public IVariable[] getOperands() {
        IVariable[] result = new IVariable[]{this.lhs, this.rhs};
        return result;
    }

    @Override
    public boolean hasVariable(T cell) {
        if (this.lhs == cell) {
            return true;
        }
        return this.rhs == cell;
    }

    @Override
    public String toString() {
        String result = this.lhs == null ? "null lhs" : this.lhs.toString();
        result = String.valueOf(result) + " " + this.getOperator() + " " + this.rhs;
        return result;
    }

    protected UnaryStatement(T lhs, T rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof UnaryStatement) {
            UnaryStatement other = (UnaryStatement)o;
            if (!((UnaryOperator)this.getOperator()).equals(other.getOperator())) {
                return false;
            }
            if (this.lhs == null) {
                if (other.lhs != null) {
                    return false;
                }
            } else {
                if (other.lhs == null) {
                    return false;
                }
                if (!this.lhs.equals(other.lhs)) {
                    return false;
                }
            }
            if (this.rhs == null) {
                if (other.rhs != null) {
                    return false;
                }
            } else {
                if (other.rhs == null) {
                    return false;
                }
                if (!this.rhs.equals(other.rhs)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = ((UnaryOperator)this.getOperator()).hashCode() * 1381;
        if (this.lhs != null) {
            result += 1399 * this.lhs.hashCode();
        }
        if (this.rhs != null) {
            result += 1409 * this.rhs.hashCode();
        }
        return result;
    }

    @Override
    public T[] getRHS() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

