/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.hunter.streamrefactoring.core.wala;

import com.ibm.wala.classLoader.Module;
import com.ibm.wala.ide.util.EclipseProjectPath;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ZeroXInstanceKeys;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashSetFactory;
import edu.cuny.hunter.streamrefactoring.core.wala.nCFABuilderWithActualParametersInContext;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;

public final class Util {
    private static final String OS_NAME = "os.name";
    private static final String WINDOWS = "Windows";

    private static void buildScope(ClassLoaderReference loader, Collection<EclipseProjectPath> projectPaths, AnalysisScope scope, Collection<Module> seen) throws IOException {
        for (EclipseProjectPath path : projectPaths) {
            AnalysisScope pScope = path.toAnalysisScope(null);
            for (Module m : pScope.getModules(loader)) {
                if (seen.contains(m)) continue;
                seen.add(m);
                scope.addToScope(loader, m);
            }
        }
    }

    public static String getOSName() {
        return System.getProperty(OS_NAME);
    }

    public static boolean isWindows() {
        return Util.getOSName().startsWith(WINDOWS);
    }

    public static SSAPropagationCallGraphBuilder makeNCFABuilder(int n, AnalysisOptions options, AnalysisCache cache, IClassHierarchy cha, AnalysisScope scope, int nToUseForStreams) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        com.ibm.wala.ipa.callgraph.impl.Util.addDefaultSelectors((AnalysisOptions)options, (IClassHierarchy)cha);
        com.ibm.wala.ipa.callgraph.impl.Util.addDefaultBypassLogic((AnalysisOptions)options, (AnalysisScope)scope, (ClassLoader)Util.class.getClassLoader(), (IClassHierarchy)cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        nCFABuilderWithActualParametersInContext result = new nCFABuilderWithActualParametersInContext(n, cha, options, cache, appSelector, appInterpreter, nToUseForStreams);
        result.setInstanceKeys((InstanceKeyFactory)new ZeroXInstanceKeys(options, cha, result.getContextInterpreter(), 31));
        return result;
    }

    public static AnalysisScope mergeProjectPaths(Collection<EclipseProjectPath> projectPaths) throws IOException {
        AnalysisScope scope = AnalysisScope.createJavaAnalysisScope();
        HashSet seen = HashSetFactory.make();
        Util.buildScope(ClassLoaderReference.Application, projectPaths, scope, seen);
        Util.buildScope(ClassLoaderReference.Extension, projectPaths, scope, seen);
        Util.buildScope(ClassLoaderReference.Primordial, projectPaths, scope, seen);
        return scope;
    }

    private Util() {
    }
}

