/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.hunter.streamrefactoring.core.analysis;

import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.cast.java.ipa.callgraph.JavaSourceAnalysisScope;
import com.ibm.wala.cast.java.translator.jdt.JDTIdentityMapper;
import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.classLoader.SyntheticClass;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.callgraph.impl.FakeRootMethod;
import com.ibm.wala.ipa.callgraph.impl.FakeWorldClinitMethod;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.NormalAllocationInNode;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallStringContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallStringContextSelector;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.PhiValue;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.Value;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.StringStuff;
import edu.cuny.hunter.streamrefactoring.core.analysis.CannotExtractSpliteratorException;
import edu.cuny.hunter.streamrefactoring.core.analysis.InconsistentPossibleOrderingException;
import edu.cuny.hunter.streamrefactoring.core.analysis.NoninstantiableException;
import edu.cuny.hunter.streamrefactoring.core.analysis.NoniterableException;
import edu.cuny.hunter.streamrefactoring.core.analysis.OrderingInference;
import edu.cuny.hunter.streamrefactoring.core.analysis.StreamFindingVisitor;
import edu.cuny.hunter.streamrefactoring.core.wala.AnalysisUtils;
import edu.cuny.hunter.streamrefactoring.core.wala.CallStringWithReceivers;
import edu.cuny.hunter.streamrefactoring.core.wala.EclipseProjectAnalysisEngine;
import java.io.UTFDataFormatException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;

public final class Util {
    private static final String BENCHMARK_ANNOTATION_NAME = "org.openjdk.jmh.annotations.Benchmark";
    private static final String BENCHMARK_SETUP_ANNOTATION_NAME = "org.openjdk.jmh.annotations.Setup";
    private static final String ENTRYPOINT_ANNOTATION_NAME = "edu.cuny.hunter.streamrefactoring.annotations.EntryPoint";
    private static final String FXML_ANNOTATION_NAME = "javafx.fxml.FXML";
    private static final Logger LOGGER = Logger.getLogger("edu.cuny.hunter.streamrefactoring");
    private static HashSet<Value> seenValues = new HashSet();

    private static void addEntryPoint(Set<Entrypoint> result, IMethod method, IClassHierarchy classHierarchy) {
        if (method != null) {
            DefaultEntrypoint entrypoint = new DefaultEntrypoint(method, classHierarchy);
            result.add((Entrypoint)entrypoint);
        }
    }

    public static boolean allEqual(Collection<?> collection) {
        if (collection.isEmpty()) {
            return true;
        }
        Object last = null;
        for (Object object : collection) {
            if (last == null) {
                last = object;
                continue;
            }
            if (object.equals(last)) continue;
            return false;
        }
        return true;
    }

    private static boolean allFake(Set<CGNode> nodes, CallGraph callGraph) {
        for (CGNode cgNode : nodes) {
            Iterator it = callGraph.getPredNodes((Object)cgNode);
            while (it.hasNext()) {
                boolean isFakeMethod;
                CGNode predNode = (CGNode)it.next();
                IMethod predMethod = predNode.getMethod();
                boolean bl = isFakeMethod = predMethod instanceof FakeRootMethod || predMethod instanceof FakeWorldClinitMethod;
                if (isFakeMethod) continue;
                return false;
            }
        }
        return true;
    }

    public static Set<Entrypoint> findBenchmarkEntryPoints(IClassHierarchy classHierarchy) {
        return Util.findEntryPoints(classHierarchy, (TypeName tn) -> Util.isBenchmark(tn) || Util.isBenchmarkSetup(tn));
    }

    private static MethodInvocation findCorrespondingMethodInvocation(CompilationUnit unit, IMethod.SourcePosition sourcePosition, MethodReference method) {
        CorrespondingASTVisitor visitor = new CorrespondingASTVisitor(unit, sourcePosition, method);
        unit.accept((ASTVisitor)visitor);
        return visitor.getCorrespondingMethodInvocation();
    }

    public static Set<Entrypoint> findEntryPoints(IClassHierarchy classHierarchy) {
        HashSet<Entrypoint> result = new HashSet<Entrypoint>();
        for (IClass klass : classHierarchy) {
            if (AnalysisUtils.isJDKClass(klass) || AnalysisUtils.isLibraryClass(klass)) continue;
            boolean entryPointClass = false;
            boolean addedInstanceMethod = false;
            block3: for (IMethod method : klass.getDeclaredMethods()) {
                if (!(method instanceof ShrikeCTMethod)) {
                    throw new IllegalArgumentException("@EntryPoint only works for byte code.");
                }
                try {
                    for (Annotation annotation : ((ShrikeCTMethod)method).getAnnotations(true)) {
                        if (!Util.isEntryPointClass(annotation.getType().getName())) continue;
                        Util.addEntryPoint(result, method, classHierarchy);
                        entryPointClass = true;
                        if (method.isStatic()) continue block3;
                        addedInstanceMethod = true;
                        continue block3;
                    }
                }
                catch (InvalidClassFileException e) {
                    throw new IllegalArgumentException("Failed to find entry points using class hierarchy: " + classHierarchy + ".", e);
                }
            }
            if (!entryPointClass) continue;
            Util.addEntryPoint(result, klass.getClassInitializer(), classHierarchy);
            if (!addedInstanceMethod) continue;
            IMethod ctor = Util.getUniqueConstructor(klass);
            Util.addEntryPoint(result, ctor, classHierarchy);
        }
        return result;
    }

    public static Set<Entrypoint> findEntryPoints(IClassHierarchy classHierarchy, Predicate<TypeName> predicate) {
        HashSet<Entrypoint> result = new HashSet<Entrypoint>();
        for (IClass klass : classHierarchy) {
            if (AnalysisUtils.isJDKClass(klass) || AnalysisUtils.isLibraryClass(klass)) continue;
            boolean isAnnotationClass = false;
            block1: for (IMethod method : klass.getDeclaredMethods()) {
                if (!(method instanceof ShrikeCTMethod)) {
                    throw new IllegalArgumentException("@EntryPoint only works for byte code.");
                }
                for (Annotation annotation : ((ShrikeCTMethod)method).getAnnotations()) {
                    TypeName annotationName = annotation.getType().getName();
                    if (!predicate.test(annotationName)) continue;
                    Util.addEntryPoint(result, method, classHierarchy);
                    isAnnotationClass = true;
                    continue block1;
                }
            }
            if (!isAnnotationClass) continue;
            Util.addEntryPoint(result, klass.getClassInitializer(), classHierarchy);
            Util.addEntryPoint(result, klass.getMethod(MethodReference.initSelector), classHierarchy);
        }
        return result;
    }

    public static Set<Entrypoint> findEntryPoints(IClassHierarchy classHierarchy, Set<String> signatures) {
        HashSet<Entrypoint> result = new HashSet<Entrypoint>();
        for (IClass klass : classHierarchy) {
            if (AnalysisUtils.isJDKClass(klass) || AnalysisUtils.isLibraryClass(klass)) continue;
            for (IMethod method : klass.getDeclaredMethods()) {
                if (!signatures.contains(method.getSignature())) continue;
                Util.addEntryPoint(result, method, classHierarchy);
            }
        }
        return result;
    }

    public static int findIndexOfFirstClientMethod(IMethod[] methods) {
        int i = 0;
        while (i < methods.length) {
            IMethod meth = methods[i];
            if (meth.getDeclaringClass().getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Set<Entrypoint> findJavaFXEntryPoints(IClassHierarchy classHierarchy) {
        return Util.findEntryPoints(classHierarchy, (TypeName tn) -> Util.isFXML(tn));
    }

    static Set<ITypeBinding> getAllInterfaces(ITypeBinding type) {
        HashSet<ITypeBinding> ret = new HashSet<ITypeBinding>();
        ITypeBinding[] interfaces = type.getInterfaces();
        ret.addAll(Arrays.asList(interfaces));
        ITypeBinding[] iTypeBindingArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding interfaceBinding = iTypeBindingArray[n2];
            ret.addAll(Util.getAllInterfaces(interfaceBinding));
            ++n2;
        }
        return ret;
    }

    static String getBinaryName(TypeReference typeReference) {
        TypeName name = typeReference.getName();
        String slashToDot = StringStuff.slashToDot((String)(String.valueOf(name.getPackage().toString()) + "." + name.getClassName().toString()));
        return slashToDot;
    }

    public static CallStringWithReceivers getCallString(CGNode node) {
        CallStringContext context = (CallStringContext)node.getContext();
        CallStringWithReceivers callString = (CallStringWithReceivers)context.get(CallStringContextSelector.CALL_STRING);
        return callString;
    }

    public static CallStringWithReceivers getCallString(InstanceKey instance) {
        NormalAllocationInNode allocationInNode = (NormalAllocationInNode)instance;
        return Util.getCallString(allocationInNode);
    }

    public static CallStringWithReceivers getCallString(NormalAllocationInNode allocationInNode) {
        CGNode node = allocationInNode.getNode();
        return Util.getCallString(node);
    }

    public static TypeReference getEvaluationType(IMethod method) {
        if (method.isInit()) {
            return method.getDeclaringClass().getReference();
        }
        return method.getReturnType();
    }

    static Set<ITypeBinding> getImplementedInterfaces(ITypeBinding type) {
        HashSet<ITypeBinding> ret = new HashSet<ITypeBinding>();
        if (type.isInterface()) {
            ret.add(type);
        }
        ret.addAll(Util.getAllInterfaces(type));
        return ret;
    }

    public static JDTIdentityMapper getJDTIdentifyMapper(ASTNode node) {
        return new JDTIdentityMapper(JavaSourceAnalysisScope.SOURCE, node.getAST());
    }

    static int getLineNumberFromAST(SimpleName methodName) {
        CompilationUnit compilationUnit = (CompilationUnit)ASTNodes.getParent((ASTNode)methodName, (int)15);
        int lineNumberFromAST = compilationUnit.getLineNumber(methodName.getStartPosition());
        return lineNumberFromAST;
    }

    static int getLineNumberFromIR(IBytecodeMethod method, SSAInstruction instruction) throws InvalidClassFileException {
        int bytecodeIndex = method.getBytecodeIndex(instruction.iindex);
        int lineNumberFromIR = method.getLineNumber(bytecodeIndex);
        return lineNumberFromIR;
    }

    static Collection<TypeAbstraction> getPossibleTypes(int valueNumber, TypeInference inference) {
        seenValues.clear();
        return Util.getPossibleTypesInternal(valueNumber, inference);
    }

    private static Collection<TypeAbstraction> getPossibleTypesInternal(int valueNumber, TypeInference inference) {
        Value value;
        HashSet<TypeAbstraction> ret = new HashSet<TypeAbstraction>();
        try {
            value = inference.getIR().getSymbolTable().getValue(valueNumber);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.info("The value number is invalid for getting possible types.");
            return ret;
        }
        if (value instanceof PhiValue) {
            if (seenValues.contains(value)) {
                return ret;
            }
            seenValues.add(value);
            PhiValue phiValue = (PhiValue)value;
            SSAPhiInstruction phiInstruction = phiValue.getPhiInstruction();
            int numberOfUses = phiInstruction.getNumberOfUses();
            int i = 0;
            while (i < numberOfUses) {
                int use = phiInstruction.getUse(i);
                Collection<TypeAbstraction> possibleTypes = Util.getPossibleTypesInternal(use, inference);
                ret.addAll(possibleTypes);
                ++i;
            }
        } else {
            ret.add(inference.getType(valueNumber));
        }
        return ret;
    }

    public static Collection<TypeAbstraction> getPossibleTypesInterprocedurally(Collection<CGNode> nodeCollection, int valueNumber, EclipseProjectAnalysisEngine<InstanceKey> engine, OrderingInference orderingInference) throws NoniterableException, NoninstantiableException, CannotExtractSpliteratorException, UTFDataFormatException, JavaModelException {
        HashSet<TypeAbstraction> ret = new HashSet<TypeAbstraction>();
        for (CGNode node : nodeCollection) {
            PointerKey valueKey = engine.getHeapGraph().getHeapModel().getPointerKeyForLocal(node, valueNumber);
            LOGGER.fine(() -> "Value pointer key is: " + valueKey);
            OrdinalSet pointsToSet = engine.getPointerAnalysis().getPointsToSet(valueKey);
            assert (pointsToSet != null);
            LOGGER.fine(() -> "PointsTo set is: " + pointsToSet);
            for (InstanceKey instanceKey : pointsToSet) {
                IClass concreteClass = instanceKey.getConcreteType();
                if (concreteClass instanceof SyntheticClass) continue;
                LOGGER.fine(() -> "Found non-synthetic concrete type: " + concreteClass);
                TypeInference inference = TypeInference.make((IR)node.getIR(), (boolean)false);
                Collection<TypeAbstraction> returnTypes = Util.getPossibleTypes(valueNumber, inference);
                for (TypeAbstraction rType : returnTypes) {
                    PointType concreteType = new PointType(concreteClass);
                    if (rType.getType().getReference().equals((Object)TypeReference.JavaLangObject)) {
                        IMethod.SourcePosition sourcePosition;
                        int bytecodeIndex;
                        IR ir = node.getIR();
                        IMethod method = ir.getMethod();
                        IBytecodeMethod bytecodeMethod = (IBytecodeMethod)method;
                        SSAInvokeInstruction def = (SSAInvokeInstruction)node.getDU().getDef(valueNumber);
                        int instructionIndex = Util.indexOf(ir.getInstructions(), def);
                        try {
                            bytecodeIndex = bytecodeMethod.getBytecodeIndex(instructionIndex);
                        }
                        catch (InvalidClassFileException e) {
                            throw new IllegalArgumentException("Value number: " + valueNumber + " does not have a definition (" + instructionIndex + ") corresponding to a bytecode index.", e);
                        }
                        try {
                            sourcePosition = method.getSourcePosition(bytecodeIndex);
                        }
                        catch (InvalidClassFileException e) {
                            throw new IllegalArgumentException("Value number: " + valueNumber + " does not have bytecode index (" + bytecodeIndex + ") corresponding to a bytecode index.", e);
                        }
                        IJavaProject enclosingProject = engine.getProject();
                        String fqn = String.valueOf(method.getDeclaringClass().getName().getPackage().toUnicodeString()) + "." + method.getDeclaringClass().getName().getClassName().toUnicodeString();
                        IType type = enclosingProject.findType(fqn.replace('/', '.'));
                        CompilationUnit unit = RefactoringASTParser.parseWithASTProvider((ITypeRoot)type.getTypeRoot(), (boolean)true, null);
                        MethodInvocation correspondingInvocation = Util.findCorrespondingMethodInvocation(unit, sourcePosition, def.getCallSite().getDeclaredTarget());
                        ITypeBinding genericReturnType = correspondingInvocation.resolveMethodBinding().getReturnType();
                        TypeReference genericTypeRef = Util.getJDTIdentifyMapper((ASTNode)correspondingInvocation).getTypeRef(genericReturnType);
                        IClass genericClass = node.getClassHierarchy().lookupClass(genericTypeRef);
                        boolean assignableFrom = node.getClassHierarchy().isAssignableFrom(genericClass, concreteClass);
                        if (!assignableFrom) continue;
                        if (Util.wouldOrderingBeConsistent(Collections.unmodifiableCollection(ret), (TypeAbstraction)concreteType, orderingInference)) {
                            LOGGER.fine("Add type straight up: " + concreteType);
                            ret.add((TypeAbstraction)concreteType);
                            continue;
                        }
                        PointType genericType = new PointType(genericClass);
                        if (Util.wouldOrderingBeConsistent(Collections.unmodifiableCollection(ret), (TypeAbstraction)genericType, orderingInference)) {
                            LOGGER.fine("Defaulting to generic type: " + genericType);
                            ret.add((TypeAbstraction)genericType);
                            continue;
                        }
                        LOGGER.fine("Defaulting to concrete type eventhough it isn't consistent: " + concreteType);
                        ret.add((TypeAbstraction)concreteType);
                        continue;
                    }
                    LOGGER.fine("Add type straight up: " + concreteType);
                    ret.add((TypeAbstraction)concreteType);
                }
            }
        }
        return ret;
    }

    private static IMethod getUniqueConstructor(IClass klass) {
        Set allDeclaredConstructors;
        IMethod ctor = klass.getMethod(MethodReference.initSelector);
        if (ctor == null && (allDeclaredConstructors = klass.getDeclaredMethods().stream().filter(m -> m.getName().startsWith(MethodReference.initAtom)).collect(Collectors.toSet())).size() == 1) {
            ctor = (IMethod)allDeclaredConstructors.iterator().next();
        }
        return ctor;
    }

    static boolean implementsBaseStream(ITypeBinding type) {
        Set<ITypeBinding> implementedInterfaces = Util.getImplementedInterfaces(type);
        return implementedInterfaces.stream().anyMatch(i -> i.getErasure().getQualifiedName().equals("java.util.stream.BaseStream"));
    }

    public static boolean implementsBaseStream(TypeReference typeReference, IClassHierarchy classHierarchy) {
        return Util.implementsType(typeReference, classHierarchy, Util::isBaseStream);
    }

    public static boolean implementsCollector(TypeReference reference, IClassHierarchy classHierarchy) {
        return Util.implementsType(reference, classHierarchy, Util::isCollector);
    }

    public static boolean implementsIterable(TypeReference reference, IClassHierarchy classHierarchy) {
        return Util.implementsType(reference, classHierarchy, Util::isIterable);
    }

    public static boolean implementsType(TypeReference typeReference, IClassHierarchy classHierarchy, Predicate<IClass> predicate) {
        if (typeReference == null) {
            return false;
        }
        IClass clazz = classHierarchy.lookupClass(typeReference);
        if (clazz == null) {
            return false;
        }
        return predicate.test(clazz) || clazz.getAllImplementedInterfaces().stream().anyMatch(predicate);
    }

    private static int indexOf(Object[] objs, Object o) {
        int i = 0;
        while (i < objs.length) {
            if (o != null && o.equals(objs[i])) {
                return i;
            }
            if (o == null && objs[i] == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static boolean isAbstractType(Class<?> clazz) {
        if (clazz.isInterface()) {
            return true;
        }
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isBaseStream(IClass clazz) {
        return Util.isType(clazz, "java/util/stream", "BaseStream");
    }

    private static boolean isBenchmark(TypeName typeName) {
        return AnalysisUtils.walaTypeNameToJavaName(typeName).equals(BENCHMARK_ANNOTATION_NAME);
    }

    private static boolean isBenchmarkSetup(TypeName typeName) {
        return AnalysisUtils.walaTypeNameToJavaName(typeName).equals(BENCHMARK_SETUP_ANNOTATION_NAME);
    }

    public static boolean isCollector(IClass clazz) {
        return Util.isType(clazz, "java/util/stream", "Collector");
    }

    private static boolean isEntryPointClass(TypeName typeName) {
        return AnalysisUtils.walaTypeNameToJavaName(typeName).equals(ENTRYPOINT_ANNOTATION_NAME);
    }

    private static boolean isFXML(TypeName typeName) {
        return AnalysisUtils.walaTypeNameToJavaName(typeName).equals(FXML_ANNOTATION_NAME);
    }

    public static boolean isIterable(IClass clazz) {
        return Util.isType(clazz, "java/lang", "Iterable");
    }

    public static boolean isScalar(Collection<TypeAbstraction> types) {
        Boolean ret = null;
        for (TypeAbstraction typeAbstraction : types) {
            boolean scalar = Util.isScalar(typeAbstraction);
            if (ret == null) {
                ret = scalar;
                continue;
            }
            if (ret == scalar) continue;
            throw new IllegalArgumentException("Inconsistent types: " + types);
        }
        return ret;
    }

    public static boolean isScalar(TypeAbstraction typeAbstraction) {
        TypeReference typeReference = typeAbstraction.getTypeReference();
        if (typeReference.isArrayType()) {
            return false;
        }
        if (typeReference.equals((Object)TypeReference.Void)) {
            throw new IllegalArgumentException("Void is neither scalar or nonscalar.");
        }
        if (typeReference.isPrimitiveType()) {
            return true;
        }
        if (typeReference.isReferenceType()) {
            IClass type = typeAbstraction.getType();
            return !Util.isIterable(type) && type.getAllImplementedInterfaces().stream().noneMatch(Util::isIterable);
        }
        throw new IllegalArgumentException("Can't tell if type is scalar: " + typeAbstraction);
    }

    static boolean isType(IClass clazz, String packagePath, String typeName) {
        Atom compareToClass;
        Atom className;
        Atom compareToPackage;
        Atom typePackage;
        return clazz.isInterface() && (typePackage = clazz.getName().getPackage()).equals((Object)(compareToPackage = Atom.findOrCreateUnicodeAtom((String)packagePath))) && (className = clazz.getName().getClassName()).equals((Object)(compareToClass = Atom.findOrCreateUnicodeAtom((String)typeName)));
    }

    public static boolean matches(SSAInstruction instruction, MethodInvocation invocation, Optional<Logger> logger) {
        if (instruction.hasDef() && instruction.getNumberOfDefs() == 2) {
            if (instruction instanceof SSAInvokeInstruction) {
                SSAInvokeInstruction invokeInstruction = (SSAInvokeInstruction)instruction;
                if (Util.matches(invokeInstruction.getDeclaredTarget().getDeclaringClass(), invokeInstruction.getCallSite().getDeclaredTarget(), invocation)) {
                    return true;
                }
            } else {
                logger.ifPresent(l -> l.warning("Instruction: " + instruction + " is not an SSAInstruction."));
            }
        } else {
            logger.ifPresent(l -> l.warning("Instruction: " + instruction + " has no definitions."));
        }
        return false;
    }

    private static boolean matches(TypeReference methodDeclaringType, MethodReference method, MethodInvocation invocation) {
        return Util.getBinaryName(methodDeclaringType).equals(invocation.getExpression().resolveTypeBinding().getBinaryName()) && method.getName().toString().equals(invocation.resolveMethodBinding().getName());
    }

    private static boolean wouldOrderingBeConsistent(Collection<TypeAbstraction> types, TypeAbstraction additionalType, OrderingInference inference) throws NoniterableException, NoninstantiableException, CannotExtractSpliteratorException {
        ArrayList<TypeAbstraction> copy = new ArrayList<TypeAbstraction>(types);
        copy.add(additionalType);
        try {
            inference.inferOrdering(copy);
        }
        catch (InconsistentPossibleOrderingException | NoninstantiableException exception) {
            return false;
        }
        return true;
    }

    private Util() {
    }

    public static boolean isStreamNode(CGNode node, IClassHierarchy classHierarchy) {
        if (Util.isDeclaredStreamClass(node, classHierarchy)) {
            return true;
        }
        IR ir = node.getIR();
        if (ir == null || ir.isEmptyIR()) {
            return true;
        }
        SSAInstruction[] sSAInstructionArray = ir.getInstructions();
        int n = sSAInstructionArray.length;
        int n2 = 0;
        while (n2 < n) {
            SSAInstruction instruction = sSAInstructionArray[n2];
            if (instruction != null) {
                Stream uses;
                StreamFindingVisitor visitor = new StreamFindingVisitor(classHierarchy);
                instruction.visit((SSAInstruction.IVisitor)visitor);
                if (visitor.hasFoundStream()) {
                    return true;
                }
                TypeInference inference = TypeInference.make((IR)ir, (boolean)false);
                Stream defs = IntStream.range(0, instruction.getNumberOfDefs()).mapToObj(i -> instruction.getDef(i)).flatMap(d -> Util.getPossibleTypes(d, inference).stream());
                if (Stream.concat(defs, uses = IntStream.range(0, instruction.getNumberOfUses()).mapToObj(i -> instruction.getUse(i)).flatMap(u -> Util.getPossibleTypes(u, inference).stream())).anyMatch(t -> Util.implementsBaseStream(t.getTypeReference(), classHierarchy))) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private static boolean isDeclaredStreamClass(CGNode node, IClassHierarchy classHierarchy) {
        IMethod method = node.getMethod();
        return Util.implementsBaseStream(method.getDeclaringClass().getReference(), classHierarchy);
    }

    private static final class CorrespondingASTVisitor
    extends ASTVisitor {
        private MethodInvocation correspondingMethodInvocation;
        private MethodReference methodReference;
        private IMethod.SourcePosition sourcePosition;
        private CompilationUnit unit;

        public CorrespondingASTVisitor(CompilationUnit unit, IMethod.SourcePosition sourcePosition, MethodReference methodReference) {
            this.unit = unit;
            this.sourcePosition = sourcePosition;
            this.methodReference = methodReference;
        }

        public MethodInvocation getCorrespondingMethodInvocation() {
            return this.correspondingMethodInvocation;
        }

        public boolean visit(MethodInvocation node) {
            SimpleName methodName = node.getName();
            int extendedStartPosition = this.unit.getExtendedStartPosition((ASTNode)methodName);
            int lineNumber = this.unit.getLineNumber(extendedStartPosition);
            if (lineNumber == this.sourcePosition.getFirstLine() && Util.matches(this.methodReference.getDeclaringClass(), this.methodReference, node)) {
                this.correspondingMethodInvocation = node;
                return false;
            }
            return true;
        }
    }
}

