/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.hunter.streamrefactoring.core.analysis;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.ibm.safe.Factoid;
import com.ibm.safe.ICFGSupergraph;
import com.ibm.safe.controller.ISafeSolver;
import com.ibm.safe.dfa.IDFAState;
import com.ibm.safe.internal.exceptions.MaxFindingsException;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.internal.exceptions.SetUpException;
import com.ibm.safe.internal.exceptions.SolverTimeoutException;
import com.ibm.safe.options.WholeProgramProperties;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.safe.reporting.message.AggregateSolverResult;
import com.ibm.safe.rules.TypestateRule;
import com.ibm.safe.typestate.base.BaseFactoid;
import com.ibm.safe.typestate.core.AbstractWholeProgramSolver;
import com.ibm.safe.typestate.core.TypeStateProperty;
import com.ibm.safe.typestate.core.TypeStateResult;
import com.ibm.safe.typestate.options.TypeStateOptions;
import com.ibm.wala.analysis.typeInference.JavaPrimitiveType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.NormalAllocationInNode;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.pruned.PrunedCallGraph;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.strings.Atom;
import edu.cuny.hunter.streamrefactoring.core.analysis.CannotExtractSpliteratorException;
import edu.cuny.hunter.streamrefactoring.core.analysis.InconsistentPossibleOrderingException;
import edu.cuny.hunter.streamrefactoring.core.analysis.InstanceKeyNotFoundException;
import edu.cuny.hunter.streamrefactoring.core.analysis.NoninstantiableException;
import edu.cuny.hunter.streamrefactoring.core.analysis.NoniterableException;
import edu.cuny.hunter.streamrefactoring.core.analysis.Ordering;
import edu.cuny.hunter.streamrefactoring.core.analysis.OrderingInference;
import edu.cuny.hunter.streamrefactoring.core.analysis.PreconditionFailure;
import edu.cuny.hunter.streamrefactoring.core.analysis.Stream;
import edu.cuny.hunter.streamrefactoring.core.analysis.StreamAttributeTypestateRule;
import edu.cuny.hunter.streamrefactoring.core.analysis.StreamExecutionModeTypeStateRule;
import edu.cuny.hunter.streamrefactoring.core.analysis.StreamOrderingTypeStateRule;
import edu.cuny.hunter.streamrefactoring.core.analysis.UnhandledCaseException;
import edu.cuny.hunter.streamrefactoring.core.analysis.UnknownIfReduceOrderMattersException;
import edu.cuny.hunter.streamrefactoring.core.analysis.Util;
import edu.cuny.hunter.streamrefactoring.core.safe.ModifiedBenignOracle;
import edu.cuny.hunter.streamrefactoring.core.safe.NoApplicationCodeExistsInCallStringsException;
import edu.cuny.hunter.streamrefactoring.core.safe.TypestateSolverFactory;
import edu.cuny.hunter.streamrefactoring.core.wala.CallStringWithReceivers;
import edu.cuny.hunter.streamrefactoring.core.wala.EclipseProjectAnalysisEngine;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.JavaModelException;

public class StreamStateMachine {
    private static final String ARRAYS_STREAM_CREATION_METHOD_NAME = "Arrays.stream";
    private static final Logger LOGGER = Logger.getLogger("edu.cuny.hunter.streamrefactoring");
    private static final String[] STATEFUL_INTERMEDIATE_OPERATIONS = new String[]{"java.util.stream.Stream.distinct", "java.util.stream.Stream.limit", "java.util.stream.Stream.skip", "java.util.stream.DoubleStream.distinct", "java.util.stream.DoubleStream.limit", "java.util.stream.DoubleStream.skip", "java.util.stream.IntStream.distinct", "java.util.stream.IntStream.limit", "java.util.stream.IntStream.skip", "java.util.stream.LongStream.distinct", "java.util.stream.LongStream.limit", "java.util.stream.LongStream.skip"};
    private static final Atom STREAM_PACKAGE_ATOM = Atom.findOrCreateUnicodeAtom((String)"java/util/stream");
    private static final String[] TERMINAL_OPERATIONS = new String[]{"java.util.stream.DoubleStream.forEach", "java.util.stream.DoubleStream.forEachOrdered", "java.util.stream.DoubleStream.toArray", "java.util.stream.DoubleStream.reduce", "java.util.stream.DoubleStream.collect", "java.util.stream.DoubleStream.sum", "java.util.stream.DoubleStream.min", "java.util.stream.DoubleStream.max", "java.util.stream.DoubleStream.count", "java.util.stream.DoubleStream.average", "java.util.stream.DoubleStream.summaryStatistics", "java.util.stream.DoubleStream.anyMatch", "java.util.stream.DoubleStream.allMatch", "java.util.stream.DoubleStream.noneMatch", "java.util.stream.DoubleStream.findFirst", "java.util.stream.DoubleStream.findAny", "java.util.stream.IntStream.forEach", "java.util.stream.IntStream.forEachOrdered", "java.util.stream.IntStream.toArray", "java.util.stream.IntStream.reduce", "java.util.stream.IntStream.collect", "java.util.stream.IntStream.sum", "java.util.stream.IntStream.min", "java.util.stream.IntStream.max", "java.util.stream.IntStream.count", "java.util.stream.IntStream.average", "java.util.stream.IntStream.summaryStatistics", "java.util.stream.IntStream.anyMatch", "java.util.stream.IntStream.allMatch", "java.util.stream.IntStream.noneMatch", "java.util.stream.IntStream.findFirst", "java.util.stream.IntStream.findAny", "java.util.stream.LongStream.forEach", "java.util.stream.LongStream.forEachOrdered", "java.util.stream.LongStream.toArray", "java.util.stream.LongStream.reduce", "java.util.stream.LongStream.collect", "java.util.stream.LongStream.sum", "java.util.stream.LongStream.min", "java.util.stream.LongStream.max", "java.util.stream.LongStream.count", "java.util.stream.LongStream.average", "java.util.stream.LongStream.summaryStatistics", "java.util.stream.LongStream.anyMatch", "java.util.stream.LongStream.allMatch", "java.util.stream.LongStream.noneMatch", "java.util.stream.LongStream.findFirst", "java.util.stream.LongStream.findAny", "java.util.stream.Stream.forEach", "java.util.stream.Stream.forEachOrdered", "java.util.stream.Stream.toArray", "java.util.stream.Stream.reduce", "java.util.stream.Stream.collect", "java.util.stream.Stream.min", "java.util.stream.Stream.max", "java.util.stream.Stream.count", "java.util.stream.Stream.anyMatch", "java.util.stream.Stream.allMatch", "java.util.stream.Stream.noneMatch", "java.util.stream.Stream.findFirst", "java.util.stream.Stream.findAny"};
    private static final String[] TERMINAL_OPERATIONS_WERE_REDUCE_ORDERING_MATTERS = new String[]{"java.util.stream.DoubleStream.forEachOrdered", "java.util.stream.IntStream.forEachOrdered", "java.util.stream.LongStream.forEachOrdered", "java.util.stream.Stream.forEachOrdered", "java.util.stream.DoubleStream.findFirst", "java.util.stream.IntStream.findFirst", "java.util.stream.LongStream.findFirst", "java.util.stream.Stream.findFirst"};
    private static final String[] TERMINAL_OPERATIONS_WHERE_REDUCE_ORDERING_DOES_NOT_MATTER = new String[]{"java.util.stream.DoubleStream.forEach", "java.util.stream.IntStream.forEach", "java.util.stream.LongStream.forEach", "java.util.stream.Stream.forEach", "java.util.stream.DoubleStream.sum", "java.util.stream.IntStream.sum", "java.util.stream.LongStream.sum", "java.util.stream.IntStream.min", "java.util.stream.DoubleStream.min", "java.util.stream.LongStream.min", "java.util.stream.Stream.min", "java.util.stream.DoubleStream.max", "java.util.stream.IntStream.max", "java.util.stream.LongStream.max", "java.util.stream.Stream.max", "java.util.stream.DoubleStream.count", "java.util.stream.IntStream.count", "java.util.stream.LongStream.count", "java.util.stream.Stream.count", "java.util.stream.DoubleStream.average", "java.util.stream.IntStream.average", "java.util.stream.LongStream.average", "java.util.stream.DoubleStream.summaryStatistics", "java.util.stream.IntStream.summaryStatistics", "java.util.stream.LongStream.summaryStatistics", "java.util.stream.DoubleStream.anyMatch", "java.util.stream.IntStream.anyMatch", "java.util.stream.LongStream.anyMatch", "java.util.stream.Stream.anyMatch", "java.util.stream.DoubleStream.allMatch", "java.util.stream.IntStream.allMatch", "java.util.stream.LongStream.allMatch", "java.util.stream.Stream.allMatch", "java.util.stream.DoubleStream.noneMatch", "java.util.stream.IntStream.noneMatch", "java.util.stream.LongStream.noneMatch", "java.util.stream.Stream.noneMatch", "java.util.stream.DoubleStream.findAny", "java.util.stream.IntStream.findAny", "java.util.stream.LongStream.findAny", "java.util.stream.Stream.findAny"};
    private static final String[] TERMINAL_OPERATIONS_WHERE_REDUCE_ORDERING_MATTERS_IS_UNKNOWN = new String[]{"java.util.stream.DoubleStream.reduce", "java.util.stream.IntStream.reduce", "java.util.stream.LongStream.reduce", "java.util.stream.Stream.reduce", "java.util.stream.DoubleStream.collect", "java.util.stream.IntStream.collect", "java.util.stream.LongStream.collect", "java.util.stream.Stream.collect"};
    private Table<InstanceKey, BasicBlockInContext<IExplodedBasicBlock>, Map<TypestateRule, Set<IDFAState>>> instanceBlockStateTable = HashBasedTable.create();
    private Set<InstanceKey> instancesWhoseReduceOrderingPossiblyMatters = new HashSet<InstanceKey>();
    private Set<InstanceKey> instancesWithoutTerminalOperations = new HashSet<InstanceKey>();
    private Set<InstanceKey> instancesWithSideEffects = new HashSet<InstanceKey>();
    private Map<InstanceKey, Set<InstanceKey>> instanceToAllPredecessorsMap = new HashMap<InstanceKey, Set<InstanceKey>>();
    private Map<InstanceKey, Set<InstanceKey>> instanceToPredecessorsMap = new HashMap<InstanceKey, Set<InstanceKey>>();
    private Map<InstanceKey, Boolean> instanceToStatefulIntermediateOperationContainment = new HashMap<InstanceKey, Boolean>();
    private Map<InstanceKey, Stream> instanceToStreamMap = new HashMap<InstanceKey, Stream>();
    private Map<InstanceKey, Map<TypestateRule, Set<IDFAState>>> originStreamToMergedTypeStateMap = new HashMap<InstanceKey, Map<TypestateRule, Set<IDFAState>>>();
    private Map<BasicBlockInContext<IExplodedBasicBlock>, OrdinalSet<InstanceKey>> terminalBlockToPossibleReceivers = new HashMap<BasicBlockInContext<IExplodedBasicBlock>, OrdinalSet<InstanceKey>>();
    private Set<InstanceKey> trackedInstances = new HashSet<InstanceKey>();

    protected static StreamAttributeTypestateRule[] createStreamAttributeTypestateRules(IClass streamClass) {
        return new StreamAttributeTypestateRule[]{new StreamExecutionModeTypeStateRule(streamClass), new StreamOrderingTypeStateRule(streamClass)};
    }

    private static boolean deriveRomForScalarMethod(SSAInvokeInstruction invokeInstruction) throws UnknownIfReduceOrderMattersException {
        MethodReference declaredTarget = invokeInstruction.getCallSite().getDeclaredTarget();
        if (StreamStateMachine.isTerminalOperationWhereReduceOrderMattersIsUnknown(declaredTarget)) {
            throw new UnknownIfReduceOrderMattersException("Cannot decifer whether ordering matters for method: " + declaredTarget);
        }
        return StreamStateMachine.deriveRomForVoidMethod(invokeInstruction);
    }

    private static boolean deriveRomForVoidMethod(SSAInvokeInstruction invokeInstruction) throws UnknownIfReduceOrderMattersException {
        MethodReference declaredTarget = invokeInstruction.getCallSite().getDeclaredTarget();
        if (StreamStateMachine.isTerminalOperationWhereReduceOrderMatters(declaredTarget)) {
            return true;
        }
        if (StreamStateMachine.isTerminalOperationWhereReduceOrderDoesNotMatter(declaredTarget)) {
            return false;
        }
        throw new UnknownIfReduceOrderMattersException("Can't decipher ROM for method: " + declaredTarget + ".");
    }

    private static boolean filterPointerKey(PointerKey pointerKey, EclipseProjectAnalysisEngine<InstanceKey> engine) {
        Boolean ret = null;
        if (pointerKey instanceof InstanceFieldPointerKey) {
            InstanceFieldPointerKey fieldPointerKey = (InstanceFieldPointerKey)pointerKey;
            InstanceKey instanceKey = fieldPointerKey.getInstanceKey();
            Iterator creationSiteIterator = instanceKey.getCreationSites(engine.getCallGraph());
            while (creationSiteIterator.hasNext()) {
                Pair creationSite = (Pair)creationSiteIterator.next();
                TypeReference declaredType = ((NewSiteReference)creationSite.snd).getDeclaredType();
                TypeName name = declaredType.getName();
                Atom packageAtom = name.getPackage();
                if (packageAtom == null) {
                    return false;
                }
                boolean fromStreamPackage = packageAtom.startsWith(STREAM_PACKAGE_ATOM);
                if (ret == null) {
                    ret = fromStreamPackage;
                    continue;
                }
                if (ret == fromStreamPackage) continue;
                throw new IllegalArgumentException("Can't determine consistent write location package");
            }
        }
        return ret;
    }

    private static Collection<? extends InstanceKey> getAdditionalNecessaryReceiversFromPredecessors(InstanceKey instance, IClassHierarchy hierarchy, CallGraph callGraph) throws IOException, CoreException {
        HashSet<InstanceKey> ret = new HashSet<InstanceKey>();
        LOGGER.fine(() -> "Instance is: " + instance);
        CallStringWithReceivers callString = Util.getCallString(instance);
        IMethod[] iMethodArray = callString.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod calledMethod = iMethodArray[n2];
            LOGGER.fine(() -> "Called method is: " + calledMethod);
            TypeReference evaluationType = Util.getEvaluationType(calledMethod);
            LOGGER.fine(() -> "Evaluation type is: " + evaluationType);
            boolean implementsBaseStream = Util.implementsBaseStream(evaluationType, hierarchy);
            LOGGER.fine(() -> "Is it a stream? " + implementsBaseStream);
            if (implementsBaseStream) {
                NormalAllocationInNode allocationInNode = (NormalAllocationInNode)instance;
                LOGGER.fine(() -> "Predecessor count is: " + callGraph.getPredNodeCount((Object)allocationInNode.getNode()));
                Iterator predNodes = callGraph.getPredNodes((Object)allocationInNode.getNode());
                while (predNodes.hasNext()) {
                    CGNode node = (CGNode)predNodes.next();
                    LOGGER.fine(() -> "Found node: " + node);
                    CallStringWithReceivers calledMethodCallString = Util.getCallString(node);
                    Set<InstanceKey> possibleReceivers = calledMethodCallString.getPossibleReceivers();
                    LOGGER.fine(() -> "It's receivers are: " + possibleReceivers);
                    for (InstanceKey receiver : possibleReceivers) {
                        if (!Util.implementsBaseStream(receiver.getConcreteType().getReference(), hierarchy)) continue;
                        ret.add(receiver);
                    }
                }
            }
            ++n2;
        }
        return ret;
    }

    private static Optional<BasicBlockInContext<IExplodedBasicBlock>> getBasicBlockInContextForBlock(ISSABasicBlock block, CGNode cgNode, ICFGSupergraph supergraph) {
        for (BasicBlockInContext basicBlockInContext : supergraph) {
            IExplodedBasicBlock delegate;
            CGNode blockInContextProcedure = supergraph.getProcOf(basicBlockInContext);
            if (blockInContextProcedure != cgNode || (delegate = (IExplodedBasicBlock)basicBlockInContext.getDelegate()).isEntryBlock() || delegate.isExitBlock() || delegate.getOriginalNumber() != block.getNumber() || delegate.getInstruction() == null) continue;
            return Optional.of(basicBlockInContext);
        }
        return Optional.empty();
    }

    private static boolean isStatefulIntermediateOperation(MethodReference method) {
        return StreamStateMachine.signatureMatches(STATEFUL_INTERMEDIATE_OPERATIONS, method);
    }

    private static boolean isStreamCreatedFromIntermediateOperation(InstanceKey instance, IClassHierarchy hierarchy, CallGraph callGraph) throws IOException, CoreException {
        Set<InstanceKey> receivers = Util.getCallString(instance).getPossibleReceivers();
        Collection<? extends InstanceKey> additionalReceivers = StreamStateMachine.getAdditionalNecessaryReceiversFromPredecessors(instance, hierarchy, callGraph);
        receivers.addAll(additionalReceivers);
        if (receivers.isEmpty()) {
            return false;
        }
        return receivers.stream().allMatch(r -> {
            IClass type = r.getConcreteType();
            return Util.isBaseStream(type) || type.getAllImplementedInterfaces().stream().anyMatch(Util::isBaseStream);
        });
    }

    private static boolean isTerminalOperation(MethodReference method) {
        return StreamStateMachine.signatureMatches(TERMINAL_OPERATIONS, method);
    }

    private static boolean isTerminalOperationWhereReduceOrderDoesNotMatter(MethodReference method) {
        return StreamStateMachine.signatureMatches(TERMINAL_OPERATIONS_WHERE_REDUCE_ORDERING_DOES_NOT_MATTER, method);
    }

    private static boolean isTerminalOperationWhereReduceOrderMatters(MethodReference method) {
        return StreamStateMachine.signatureMatches(TERMINAL_OPERATIONS_WERE_REDUCE_ORDERING_MATTERS, method);
    }

    private static boolean isTerminalOperationWhereReduceOrderMattersIsUnknown(MethodReference method) {
        return StreamStateMachine.signatureMatches(TERMINAL_OPERATIONS_WHERE_REDUCE_ORDERING_MATTERS_IS_UNKNOWN, method);
    }

    private static boolean isVoid(Collection<TypeAbstraction> types) {
        return types.stream().map(TypeAbstraction::getTypeReference).allMatch(tr -> tr.equals((Object)TypeReference.Void));
    }

    private static Collection<? extends IDFAState> mergeTypeStates(Set<IDFAState> set1, Set<IDFAState> set2) {
        if (set1.isEmpty()) {
            return set2;
        }
        if (set2.isEmpty()) {
            return set1;
        }
        HashSet<IDFAState> ret = new HashSet<IDFAState>();
        for (IDFAState state1 : set1) {
            for (IDFAState state2 : set2) {
                ret.add(StreamStateMachine.selectState(state1, state2));
            }
        }
        return ret;
    }

    private static void outputTypeStateStatistics(AggregateSolverResult result) {
        LOGGER.info("Total instances: " + result.totalInstancesNum());
        LOGGER.info("Processed instances: " + result.processedInstancesNum());
        LOGGER.info("Skipped instances: " + result.skippedInstances());
    }

    private static IDFAState selectState(IDFAState state1, IDFAState state2) {
        if (state1.getName().equals("bottom")) {
            return state2;
        }
        return state1;
    }

    private static boolean signatureMatches(String[] operations, MethodReference method) {
        String signature = method.getSignature();
        return Arrays.stream(operations).map(o -> String.valueOf(o) + "(").anyMatch(signature::startsWith);
    }

    private Set<IDFAState> computeMergedTypeState(InstanceKey instanceKey, BasicBlockInContext<IExplodedBasicBlock> block, StreamAttributeTypestateRule rule) {
        Set<InstanceKey> predecessors = this.instanceToPredecessorsMap.get(instanceKey);
        Map ruleToStates = (Map)this.instanceBlockStateTable.get((Object)instanceKey, block);
        if (ruleToStates == null) {
            return Collections.emptySet();
        }
        Set possibleInstanceStates = (Set)ruleToStates.get((Object)rule);
        if (predecessors.isEmpty()) {
            return possibleInstanceStates;
        }
        HashSet<IDFAState> ret = new HashSet<IDFAState>();
        for (InstanceKey pred : predecessors) {
            ret.addAll(StreamStateMachine.mergeTypeStates(possibleInstanceStates, this.computeMergedTypeState(pred, block, rule)));
        }
        return ret;
    }

    private Set<InstanceKey> computePossibleOriginStreams(InstanceKey instanceKey) {
        if (instanceKey == null) {
            return Collections.emptySet();
        }
        Set<InstanceKey> predecessors = this.instanceToPredecessorsMap.get(instanceKey);
        if (predecessors.isEmpty()) {
            return Collections.singleton(instanceKey);
        }
        return predecessors.stream().map(this::computePossibleOriginStreams).flatMap(os -> os.stream()).collect(Collectors.toSet());
    }

    private boolean deriveRomForNonScalarMethod(Collection<TypeAbstraction> possibleReturnTypes, OrderingInference orderingInference) throws NoniterableException, NoninstantiableException, CannotExtractSpliteratorException {
        Ordering ordering;
        try {
            ordering = orderingInference.inferOrdering(possibleReturnTypes);
        }
        catch (InconsistentPossibleOrderingException e) {
            ordering = Ordering.ORDERED;
            LOGGER.log(Level.WARNING, "Inconsistently ordered possible return types encountered: " + possibleReturnTypes + ". Defaulting to: " + (Object)((Object)ordering), e);
        }
        LOGGER.info("Ordering of reduction type is: " + (Object)((Object)ordering));
        if (ordering == null) {
            ordering = Ordering.ORDERED;
            LOGGER.warning("Can't determine ordering for possible return types: " + possibleReturnTypes + ". Defaulting to: " + (Object)((Object)ordering));
        }
        switch (ordering) {
            case UNORDERED: {
                return false;
            }
            case ORDERED: {
                return true;
            }
        }
        throw new IllegalStateException("Logic missing ordering.");
    }

    /*
     * Unable to fully structure code
     */
    private void discoverIfReduceOrderingPossiblyMatters(EclipseProjectAnalysisEngine<InstanceKey> engine, OrderingInference orderingInference, IProgressMonitor monitor) throws UTFDataFormatException, JavaModelException, NoniterableException, NoninstantiableException, CannotExtractSpliteratorException {
        monitor.beginTask("Discovering if reduce order matters...", this.terminalBlockToPossibleReceivers.keySet().size());
        for (BasicBlockInContext<IExplodedBasicBlock> block : this.terminalBlockToPossibleReceivers.keySet()) {
            processedInstructions = 0;
            for (SSAInstruction instruction : block) {
                block15: {
                    if (instruction instanceof SSAPhiInstruction) continue;
                    if (!StreamStateMachine.$assertionsDisabled && !(instruction instanceof SSAInvokeInstruction)) {
                        throw new AssertionError((Object)("Expecting SSAInvokeInstruction, was: " + instruction.getClass()));
                    }
                    invokeInstruction = (SSAInvokeInstruction)instruction;
                    numOfRetVals = invokeInstruction.getNumberOfReturnValues();
                    if (!StreamStateMachine.$assertionsDisabled && numOfRetVals > 1) {
                        throw new AssertionError((Object)("How could you possibly return " + numOfRetVals + " values?"));
                    }
                    possibleReturnTypes /* !! */  = null;
                    if (numOfRetVals > 0) {
                        returnValue = invokeInstruction.getReturnValue(0);
                        possibleReturnTypes /* !! */  = Util.getPossibleTypesInterprocedurally(Collections.singleton(block.getNode()), returnValue, engine, orderingInference);
                        StreamStateMachine.LOGGER.fine("Possible reduce types are: " + possibleReturnTypes /* !! */ );
                    } else {
                        possibleReturnTypes /* !! */  = Collections.singleton(JavaPrimitiveType.VOID);
                    }
                    rom = null;
                    try {
                        rom = StreamStateMachine.isVoid(possibleReturnTypes /* !! */ ) ? Boolean.valueOf(StreamStateMachine.deriveRomForVoidMethod(invokeInstruction)) : ((scalar = Util.isScalar(possibleReturnTypes /* !! */ )) ? Boolean.valueOf(StreamStateMachine.deriveRomForScalarMethod(invokeInstruction)) : Boolean.valueOf(this.deriveRomForNonScalarMethod(possibleReturnTypes /* !! */ , orderingInference)));
                        break block15;
                    }
                    catch (UnknownIfReduceOrderMattersException e) {
                        receivers = this.terminalBlockToPossibleReceivers.get(block);
                        ** for (instanceKey : receivers)
                    }
lbl-1000:
                    // 1 sources

                    {
                        originStreams = this.computePossibleOriginStreams(instanceKey);
                        for (InstanceKey origin : originStreams) {
                            stream = this.instanceToStreamMap.get(origin);
                            if (stream == null) {
                                StreamStateMachine.LOGGER.warning((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$15(com.ibm.wala.ipa.callgraph.propagation.InstanceKey com.ibm.wala.ipa.callgraph.propagation.InstanceKey ), ()Ljava/lang/String;)((InstanceKey)instanceKey, (InstanceKey)origin));
                                continue;
                            }
                            StreamStateMachine.LOGGER.log(Level.WARNING, "Unable to derive ROM for: " + stream.getCreation(), e);
                            stream.addStatusEntry(PreconditionFailure.NON_DETERMINABLE_REDUCTION_ORDERING, "Cannot derive reduction ordering for stream: " + stream.getCreation() + ".");
                        }
                        continue;
                    }
                }
                if (rom != null) {
                    if (rom.booleanValue()) {
                        StreamStateMachine.LOGGER.fine((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$16(com.ibm.wala.ssa.SSAInvokeInstruction ), ()Ljava/lang/String;)((SSAInvokeInstruction)invokeInstruction));
                        possibleReceivers = this.terminalBlockToPossibleReceivers.get(block);
                        possibleReceivers.forEach((Consumer<InstanceKey>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lcom/ibm/wala/ipa/callgraph/propagation/InstanceKey;)V)(this.instancesWhoseReduceOrderingPossiblyMatters));
                    } else {
                        StreamStateMachine.LOGGER.fine((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$18(com.ibm.wala.ssa.SSAInvokeInstruction ), ()Ljava/lang/String;)((SSAInvokeInstruction)invokeInstruction));
                    }
                }
                ++processedInstructions;
            }
            if (!StreamStateMachine.$assertionsDisabled && processedInstructions != 1) {
                throw new AssertionError((Object)"Expecting to process one and only one instruction here.");
            }
            monitor.worked(1);
        }
    }

    private void discoverLambdaSideEffects(EclipseProjectAnalysisEngine<InstanceKey> engine, Map<CGNode, OrdinalSet<PointerKey>> mod, Iterable<InstanceKey> instances, MethodReference declaredTargetOfCaller, IR ir, int use) {
        DefUse defUse = engine.getCache().getDefUse(ir);
        SSAInstruction def = defUse.getDef(use);
        if (def != null) {
            if (def instanceof SSAAbstractInvokeInstruction) {
                SSAAbstractInvokeInstruction instruction = (SSAAbstractInvokeInstruction)def;
                Set nodes = engine.getCallGraph().getNodes(declaredTargetOfCaller);
                block0: for (CGNode cgNode : nodes) {
                    Iterator callSiteIt = cgNode.iterateCallSites();
                    while (callSiteIt.hasNext()) {
                        CallSiteReference callSiteReference = (CallSiteReference)callSiteIt.next();
                        if (!callSiteReference.equals((Object)instruction.getCallSite())) continue;
                        Set possibleTargets = engine.getCallGraph().getPossibleTargets(cgNode, callSiteReference);
                        LOGGER.fine(() -> "#possible targets: " + possibleTargets.size());
                        if (!possibleTargets.isEmpty()) {
                            LOGGER.fine(() -> possibleTargets.stream().map(String::valueOf).collect(Collectors.joining("\n", "Possible target: ", "")));
                        }
                        for (CGNode target : possibleTargets) {
                            OrdinalSet<PointerKey> modSet = mod.get(target);
                            LOGGER.fine(() -> "#original modified locations: " + modSet.size());
                            HashSet<PointerKey> filteredModSet = new HashSet<PointerKey>();
                            for (PointerKey pointerKey : modSet) {
                                if (StreamStateMachine.filterPointerKey(pointerKey, engine)) continue;
                                filteredModSet.add(pointerKey);
                            }
                            LOGGER.fine(() -> "#filtered modified locations: " + filteredModSet.size());
                            if (filteredModSet.isEmpty()) continue;
                            filteredModSet.forEach(pk -> LOGGER.fine(() -> "Filtered modified location: " + pk));
                            instances.forEach(this.instancesWithSideEffects::add);
                        }
                        continue block0;
                    }
                }
            } else {
                LOGGER.warning("Def was an instance of a: " + def.getClass());
            }
        }
    }

    private void discoverPossibleSideEffects(EclipseProjectAnalysisEngine<InstanceKey> engine, IProgressMonitor monitor) throws IOException, CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Discovering side-effects...", (int)100);
        ModRef modRef = ModRef.make();
        Map mod = modRef.computeMod(engine.getCallGraph(), engine.getPointerAnalysis());
        SubMonitor loopMonitor = subMonitor.split(50, 0).setWorkRemaining(this.terminalBlockToPossibleReceivers.keySet().size());
        for (BasicBlockInContext<IExplodedBasicBlock> block : this.terminalBlockToPossibleReceivers.keySet()) {
            int processedInstructions = 0;
            for (SSAInstruction instruction : block) {
                if (instruction instanceof SSAPhiInstruction) continue;
                int numberOfUses = instruction.getNumberOfUses();
                int i = 1;
                while (i < numberOfUses) {
                    int paramUse = instruction.getUse(i);
                    IR ir = engine.getCache().getIR(block.getMethod());
                    assert (instruction instanceof SSAInvokeInstruction) : "Expecting invoke instruction.";
                    MethodReference declaredTarget = block.getMethod().getReference();
                    this.discoverLambdaSideEffects(engine, mod, (Iterable)this.terminalBlockToPossibleReceivers.get(block), declaredTarget, ir, paramUse);
                    ++i;
                }
                ++processedInstructions;
            }
            assert (processedInstructions == 1) : "Expecting to process one and only one instruction here.";
            loopMonitor.worked(1);
        }
        loopMonitor = subMonitor.split(50, 0).setWorkRemaining(this.trackedInstances.size());
        for (InstanceKey instance : this.trackedInstances) {
            if (!StreamStateMachine.isStreamCreatedFromIntermediateOperation(instance, engine.getClassHierarchy(), engine.getCallGraph())) continue;
            CallStringWithReceivers callString = Util.getCallString(instance);
            assert (callString.getMethods().length >= 1) : "Expecting call sites at least one-deep.";
            IR ir = engine.getCache().getIR(callString.getMethods()[0]);
            if (ir == null) {
                LOGGER.warning("Can't find IR for target: " + callString.getMethods()[0]);
                continue;
            }
            SSAAbstractInvokeInstruction[] calls = ir.getCalls(callString.getCallSiteRefs()[0]);
            assert (calls.length == 1) : "Are we only expecting one call here?";
            if (calls[0].getNumberOfUses() == 2) {
                int use = calls[0].getUse(1);
                this.discoverLambdaSideEffects(engine, mod, Collections.singleton(instance), callString.getMethods()[0].getReference(), ir, use);
            }
            loopMonitor.worked(1);
        }
    }

    private void discoverPossibleStatefulIntermediateOperations(IClassHierarchy hierarchy, CallGraph callGraph, IProgressMonitor monitor) throws IOException, CoreException {
        monitor.beginTask("Discovering stateful intermediate operations...", this.trackedInstances.size());
        for (InstanceKey instance : this.trackedInstances) {
            if (!this.instanceToStatefulIntermediateOperationContainment.containsKey(instance)) {
                if (!StreamStateMachine.isStreamCreatedFromIntermediateOperation(instance, hierarchy, callGraph)) continue;
                CallStringWithReceivers callString = Util.getCallString(instance);
                boolean found = false;
                CallSiteReference[] callSiteReferenceArray = callString.getCallSiteRefs();
                int n = callSiteReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CallSiteReference callSiteReference = callSiteReferenceArray[n2];
                    if (StreamStateMachine.isStatefulIntermediateOperation(callSiteReference.getDeclaredTarget())) {
                        found = true;
                        break;
                    }
                    ++n2;
                }
                this.instanceToStatefulIntermediateOperationContainment.put(instance, found);
            }
            monitor.worked(1);
        }
    }

    private void discoverTerminalOperations(IProgressMonitor monitor) {
        Collection<OrdinalSet<InstanceKey>> receiverSetsThatHaveTerminalOperations = this.terminalBlockToPossibleReceivers.values();
        HashSet<InstanceKey> validStreams = new HashSet<InstanceKey>();
        monitor.beginTask("Flattening...", receiverSetsThatHaveTerminalOperations.size());
        for (OrdinalSet<InstanceKey> receiverSet : receiverSetsThatHaveTerminalOperations) {
            for (InstanceKey instance : receiverSet) {
                validStreams.add(instance);
            }
            monitor.worked(1);
        }
        this.propagateStreamInstanceProperty(validStreams);
        HashSet<InstanceKey> allStreamInstances = new HashSet<InstanceKey>(this.trackedInstances);
        allStreamInstances.removeAll(validStreams);
        HashSet<InstanceKey> badStreamInstances = allStreamInstances;
        this.instancesWithoutTerminalOperations.addAll(badStreamInstances);
    }

    private void fillInstanceToPredecessorMap(EclipseProjectAnalysisEngine<InstanceKey> engine) throws IOException, CoreException {
        for (InstanceKey instance : this.trackedInstances) {
            CallStringWithReceivers callString = Util.getCallString(instance);
            HashSet<InstanceKey> possibleReceivers = new HashSet<InstanceKey>(callString.getPossibleReceivers());
            Collection<? extends InstanceKey> additionalNecessaryReceiversFromPredecessors = StreamStateMachine.getAdditionalNecessaryReceiversFromPredecessors(instance, engine.getClassHierarchy(), engine.getCallGraph());
            LOGGER.fine(() -> "Adding additional receivers: " + additionalNecessaryReceiversFromPredecessors);
            possibleReceivers.addAll(additionalNecessaryReceiversFromPredecessors);
            this.instanceToPredecessorsMap.merge(instance, possibleReceivers, (x, y) -> {
                x.addAll(y);
                return x;
            });
        }
    }

    private void fillInstanceToStreamMap(Set<Stream> streamSet, EclipseProjectAnalysisEngine<InstanceKey> engine, IProgressMonitor monitor) throws InvalidClassFileException, IOException, CoreException {
        monitor.beginTask("Propagating...", streamSet.size());
        int skippedStreams = 0;
        for (Stream stream : streamSet) {
            InstanceKey instanceKey = null;
            try {
                instanceKey = stream.getInstanceKey(this.trackedInstances, engine);
            }
            catch (InstanceKeyNotFoundException e) {
                LOGGER.log(Level.WARNING, "Encountered unreachable code while processing: " + stream.getCreation() + ".", e);
                stream.addStatusEntry(PreconditionFailure.STREAM_CODE_NOT_REACHABLE, "Either pivital code isn't reachable for stream: " + stream.getCreation() + " or entry points are misconfigured.");
                ++skippedStreams;
                continue;
            }
            catch (UnhandledCaseException e) {
                String msg = "Encountered possible unhandled case (AIC #155) while processing: " + stream.getCreation() + ".";
                LOGGER.log(Level.WARNING, msg, e);
                stream.addStatusEntry(PreconditionFailure.CURRENTLY_NOT_HANDLED, msg);
                ++skippedStreams;
                continue;
            }
            catch (NoApplicationCodeExistsInCallStringsException e) {
                LOGGER.log(Level.WARNING, "Did not encounter application code in call strings while processing: " + stream.getCreation() + ".", e);
                stream.addStatusEntry(PreconditionFailure.NO_APPLICATION_CODE_IN_CALL_STRINGS, "No application code in the call strings generated for stream: " + stream.getCreation() + " was found. The maximum call string length may need to be increased.");
                ++skippedStreams;
                continue;
            }
            Stream oldValue = this.instanceToStreamMap.put(instanceKey, stream);
            if (oldValue != null && oldValue != stream) {
                LOGGER.warning("Reassociating stream: " + stream.getCreation() + " with: " + instanceKey + ". Old stream was: " + oldValue.getCreation() + ".");
            }
            monitor.worked(1);
        }
        if (this.instanceToStreamMap.keySet().size() != streamSet.size() - skippedStreams) {
            LOGGER.warning("Stream set of size: " + (streamSet.size() - skippedStreams) + " does not produce a bijection of instance keys of size: " + this.instanceToStreamMap.keySet().size() + ".");
        }
    }

    private Set<InstanceKey> getAllPredecessors(InstanceKey instanceKey) {
        if (!this.instanceToAllPredecessorsMap.containsKey(instanceKey)) {
            HashSet<InstanceKey> ret = new HashSet<InstanceKey>();
            ret.addAll((Collection)this.instanceToPredecessorsMap.get(instanceKey));
            ret.addAll(this.instanceToPredecessorsMap.get(instanceKey).stream().flatMap(ik -> this.getAllPredecessors((InstanceKey)ik).stream()).collect(Collectors.toSet()));
            this.instanceToAllPredecessorsMap.put(instanceKey, ret);
            return ret;
        }
        return this.instanceToAllPredecessorsMap.get(instanceKey);
    }

    public Collection<IDFAState> getStates(StreamAttributeTypestateRule rule, InstanceKey instanceKey) {
        Map<TypestateRule, Set<IDFAState>> mergedTypeState = this.originStreamToMergedTypeStateMap.get(instanceKey);
        if (mergedTypeState == null) {
            LOGGER.warning(() -> "Can't find merged type state for rule: " + (Object)((Object)rule) + " and instance key: " + instanceKey);
            return Collections.emptySet();
        }
        return mergedTypeState.get((Object)rule);
    }

    public Collection<InstanceKey> getTrackedInstances() {
        return Collections.unmodifiableCollection(this.trackedInstances);
    }

    private void propagateStreamInstanceProperty(Collection<InstanceKey> streamInstancesWithProperty) {
        streamInstancesWithProperty.addAll(streamInstancesWithProperty.stream().flatMap(ik -> this.getAllPredecessors((InstanceKey)ik).stream()).collect(Collectors.toSet()));
    }

    public Map<TypestateRule, Statistics> start(Set<Stream> streamSet, EclipseProjectAnalysisEngine<InstanceKey> engine, OrderingInference orderingInference, IProgressMonitor monitor) throws PropertiesException, CancelException, IOException, CoreException, NoniterableException, NoninstantiableException, CannotExtractSpliteratorException, InvalidClassFileException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Performing typestate analysis (may take a while)", (int)100);
        HashMap<TypestateRule, Statistics> ret = new HashMap<TypestateRule, Statistics>();
        CallGraph prunedCallGraph = StreamStateMachine.pruneCallGraph(engine.getCallGraph(), engine.getClassHierarchy());
        ModifiedBenignOracle ora = new ModifiedBenignOracle(prunedCallGraph, engine.getPointerAnalysis());
        PropertiesManager manager = PropertiesManager.initFromMap(Collections.emptyMap());
        PropertiesManager.registerProperties((PropertiesManager.IPropertyDescriptor[])new PropertiesManager.IPropertyDescriptor[]{WholeProgramProperties.Props.LIVE_ANALYSIS});
        TypeStateOptions typeStateOptions = new TypeStateOptions(manager);
        typeStateOptions.setBooleanValue(WholeProgramProperties.Props.LIVE_ANALYSIS.getName(), false);
        TypeReference typeReference = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Primordial, (String)"Ljava/util/stream/BaseStream");
        IClass streamClass = engine.getClassHierarchy().lookupClass(typeReference);
        StreamAttributeTypestateRule[] ruleArray = StreamStateMachine.createStreamAttributeTypestateRules(streamClass);
        SubMonitor ruleMonitor = subMonitor.split(70, 0).setWorkRemaining(ruleArray.length);
        StreamAttributeTypestateRule[] streamAttributeTypestateRuleArray = ruleArray;
        int n = ruleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AggregateSolverResult result;
            StreamAttributeTypestateRule rule = streamAttributeTypestateRuleArray[n2];
            TypeStateProperty dfa = new TypeStateProperty((TypestateRule)rule, engine.getClassHierarchy());
            LOGGER.info(() -> "Starting " + rule.getName() + " solver for: " + engine.getProject().getElementName());
            ISafeSolver solver = TypestateSolverFactory.getSolver(engine.getOptions(), prunedCallGraph, engine.getPointerAnalysis(), engine.getHeapGraph(), dfa, ora, typeStateOptions, null, null, null);
            try {
                result = (AggregateSolverResult)solver.perform((IProgressMonitor)ruleMonitor.split(50, 0));
            }
            catch (MaxFindingsException | SetUpException | SolverTimeoutException | WalaException e) {
                throw new RuntimeException("Exception caught during typestate analysis.", e);
            }
            StreamStateMachine.outputTypeStateStatistics(result);
            Statistics lastStatistics = ret.put(rule, new Statistics(result.processedInstancesNum(), result.skippedInstances()));
            assert (lastStatistics == null) : "Reassociating statistics.";
            SubMonitor instanceMonitor = ruleMonitor.split(20, 0).setWorkRemaining(result.totalInstancesNum());
            Iterator iterator = result.iterateInstances();
            while (iterator.hasNext()) {
                InstanceKey instanceKey = (InstanceKey)iterator.next();
                this.trackedInstances.add(instanceKey);
                TypeStateResult instanceResult = (TypeStateResult)result.getInstanceResult(instanceKey);
                ICFGSupergraph supergraph = instanceResult.getSupergraph();
                for (CGNode cgNode : prunedCallGraph) {
                    if (!cgNode.getMethod().getDeclaringClass().getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) continue;
                    LOGGER.fine(() -> "Examining client call graph node: " + cgNode);
                    Iterator callSites = cgNode.iterateCallSites();
                    while (callSites.hasNext()) {
                        CallSiteReference callSiteReference = (CallSiteReference)callSites.next();
                        MethodReference calledMethod = callSiteReference.getDeclaredTarget();
                        if (!StreamStateMachine.isTerminalOperation(calledMethod)) continue;
                        IR ir = cgNode.getIR();
                        ISSABasicBlock[] blocksForCall = ir.getBasicBlocksForCall(callSiteReference);
                        assert (blocksForCall.length == 1) : "Expecting only a single basic block for the call: " + callSiteReference;
                        ISSABasicBlock[] iSSABasicBlockArray = blocksForCall;
                        int n3 = blocksForCall.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ISSABasicBlock block = iSSABasicBlockArray[n4];
                            BasicBlockInContext<IExplodedBasicBlock> blockInContext = StreamStateMachine.getBasicBlockInContextForBlock(block, cgNode, supergraph).orElseThrow(() -> new IllegalStateException("No basic block in context for block: " + block));
                            if (!this.terminalBlockToPossibleReceivers.containsKey(blockInContext)) {
                                int processedInstructions = 0;
                                for (SSAInstruction instruction : block) {
                                    if (!(instruction instanceof SSAAbstractInvokeInstruction)) continue;
                                    int valueNumberForReceiver = instruction.getUse(0);
                                    PointerKey pointerKey = engine.getHeapGraph().getHeapModel().getPointerKeyForLocal(cgNode, valueNumberForReceiver);
                                    OrdinalSet pointsToSet = engine.getPointerAnalysis().getPointsToSet(pointerKey);
                                    assert (pointsToSet != null) : "The points-to set (I think) should not be null for pointer: " + pointerKey;
                                    OrdinalSet<InstanceKey> previousReceivers = this.terminalBlockToPossibleReceivers.put(blockInContext, (OrdinalSet<InstanceKey>)pointsToSet);
                                    assert (previousReceivers == null) : "Reassociating a blockInContext: " + blockInContext + " with a new points-to set: " + pointsToSet + " that was originally: " + previousReceivers;
                                    ++processedInstructions;
                                }
                                assert (processedInstructions == 1) : "Expecting to process one and only one instruction here.";
                            }
                            IntSet resultingFacts = instanceResult.getResult().getResult(blockInContext);
                            IntIterator factIterator = resultingFacts.intIterator();
                            while (factIterator.hasNext()) {
                                Factoid factoid;
                                HashSet<IDFAState> stateSet;
                                int fact = factIterator.next();
                                HashMap ruleToStates = (HashMap)this.instanceBlockStateTable.get((Object)instanceKey, blockInContext);
                                if (ruleToStates == null) {
                                    ruleToStates = new HashMap();
                                    this.instanceBlockStateTable.put((Object)instanceKey, blockInContext, ruleToStates);
                                }
                                if ((stateSet = (HashSet<IDFAState>)ruleToStates.get((Object)rule)) == null) {
                                    stateSet = new HashSet<IDFAState>();
                                    ruleToStates.put(rule, stateSet);
                                }
                                if ((factoid = (Factoid)instanceResult.getDomain().getMappedObject(fact)) == AbstractWholeProgramSolver.DUMMY_ZERO) continue;
                                BaseFactoid baseFactoid = (BaseFactoid)factoid;
                                assert (baseFactoid.instance.equals(instanceKey)) : "Sanity check that the fact instance should be the same as the instance being examined.";
                                LOGGER.fine(() -> "Adding state: " + baseFactoid.state + " for instance: " + baseFactoid.instance + " for block: " + block + " for rule: " + rule.getName());
                                stateSet.add(baseFactoid.state);
                            }
                            ++n4;
                        }
                    }
                }
                instanceMonitor.worked(1);
            }
            if (this.instanceToPredecessorsMap.isEmpty()) {
                this.fillInstanceToPredecessorMap(engine);
            }
            for (BasicBlockInContext<IExplodedBasicBlock> block : this.terminalBlockToPossibleReceivers.keySet()) {
                OrdinalSet<InstanceKey> possibleReceivers = this.terminalBlockToPossibleReceivers.get(block);
                for (InstanceKey instanceKey : possibleReceivers) {
                    Set<IDFAState> possibleStates = this.computeMergedTypeState(instanceKey, block, rule);
                    Set<InstanceKey> possibleOriginStreams = this.computePossibleOriginStreams(instanceKey);
                    possibleOriginStreams.forEach(os -> {
                        HashMap ruleToStates = new HashMap();
                        ruleToStates.put(rule, new HashSet(possibleStates));
                        this.originStreamToMergedTypeStateMap.merge((InstanceKey)os, ruleToStates, (m1, m2) -> {
                            HashSet states1 = (HashSet)m1.get((Object)rule);
                            Set states2 = (Set)m2.get((Object)rule);
                            if (states1 == null) {
                                states1 = new HashSet();
                                m1.put(rule, states1);
                            }
                            if (states2 != null) {
                                states1.addAll(states2);
                            }
                            return m1;
                        });
                    });
                }
            }
            ruleMonitor.worked(1);
            ++n2;
        }
        this.fillInstanceToStreamMap(streamSet, engine, (IProgressMonitor)subMonitor.split(5, 0));
        this.discoverTerminalOperations((IProgressMonitor)subMonitor.split(5, 0));
        this.discoverPossibleSideEffects(engine, (IProgressMonitor)subMonitor.split(5, 0));
        this.discoverPossibleStatefulIntermediateOperations(engine.getClassHierarchy(), prunedCallGraph, (IProgressMonitor)subMonitor.split(5, 0));
        this.discoverIfReduceOrderingPossiblyMatters(engine, orderingInference, (IProgressMonitor)subMonitor.split(5, 0));
        this.propagateStreamInstanceProperty(this.instancesWithSideEffects);
        BinaryOperator remappingFunction = (v1, v2) -> {
            if (v1 == v2) {
                return v2;
            }
            return true;
        };
        this.instanceToStatefulIntermediateOperationContainment.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).flatMap(ik -> this.getAllPredecessors((InstanceKey)ik).stream()).collect(Collectors.toMap(Function.identity(), v -> true, remappingFunction)).forEach((k, v) -> {
            Boolean bl = this.instanceToStatefulIntermediateOperationContainment.merge((InstanceKey)k, (Boolean)v, remappingFunction);
        });
        this.propagateStreamInstanceProperty(this.instancesWhoseReduceOrderingPossiblyMatters);
        for (InstanceKey streamInstanceKey : this.instanceToStreamMap.keySet()) {
            Stream stream = this.instanceToStreamMap.get(streamInstanceKey);
            stream.setHasPossibleSideEffects(this.instancesWithSideEffects.contains(streamInstanceKey));
            stream.setHasPossibleStatefulIntermediateOperations(this.instanceToStatefulIntermediateOperationContainment.getOrDefault(streamInstanceKey, false));
            stream.setHasNoTerminalOperation(this.instancesWithoutTerminalOperations.contains(streamInstanceKey));
            if (stream.hasNoTerminalOperation()) continue;
            StreamAttributeTypestateRule[] streamAttributeTypestateRuleArray2 = ruleArray;
            int n5 = ruleArray.length;
            int n6 = 0;
            while (n6 < n5) {
                StreamAttributeTypestateRule rule = streamAttributeTypestateRuleArray2[n6];
                Collection<IDFAState> states = this.getStates(rule, streamInstanceKey);
                rule.addPossibleAttributes(stream, states);
                ++n6;
            }
            stream.setReduceOrderingPossiblyMatters(this.instancesWhoseReduceOrderingPossiblyMatters.contains(streamInstanceKey));
        }
        return ret;
    }

    private static CallGraph pruneCallGraph(CallGraph callGraph, IClassHierarchy classHierarchy) {
        int numberOfNodesInCallGraph = callGraph.getNumberOfNodes();
        LOGGER.info("The number of nodes in the call graph: " + numberOfNodesInCallGraph);
        HashSet<CGNode> keep = new HashSet<CGNode>();
        for (CGNode node : callGraph) {
            if (!Util.isStreamNode(node, classHierarchy)) continue;
            keep.add(node);
        }
        PrunedCallGraph prunedCallGraph = new PrunedCallGraph(callGraph, keep);
        int numberOfNodesInPrunedCallGraph = prunedCallGraph.getNumberOfNodes();
        LOGGER.info("The number of nodes in partial graph: " + numberOfNodesInPrunedCallGraph + ". The number of saved nodes: " + (numberOfNodesInCallGraph - numberOfNodesInPrunedCallGraph));
        return prunedCallGraph;
    }

    private static /* synthetic */ String lambda$15(InstanceKey instanceKey, InstanceKey instanceKey2) {
        return "Can't find Stream instance for instance key: " + instanceKey + " using origin: " + instanceKey2;
    }

    private static /* synthetic */ String lambda$16(SSAInvokeInstruction sSAInvokeInstruction) {
        return "Reduce ordering matters for: " + sSAInvokeInstruction;
    }

    private static /* synthetic */ String lambda$18(SSAInvokeInstruction sSAInvokeInstruction) {
        return "Reduce ordering doesn't matter for: " + sSAInvokeInstruction;
    }

    public class Statistics {
        private int numberOfStreamInstancesProcessed;
        private int numberOfStreamInstancesSkipped;

        public Statistics(int numberOfStreamInstancesProcessed, int numberOfStreamInstancesSkipped) {
            this.numberOfStreamInstancesProcessed = numberOfStreamInstancesProcessed;
            this.numberOfStreamInstancesSkipped = numberOfStreamInstancesSkipped;
        }

        public int getNumberOfStreamInstancesProcessed() {
            return this.numberOfStreamInstancesProcessed;
        }

        public int getNumberOfStreamInstancesSkipped() {
            return this.numberOfStreamInstancesSkipped;
        }
    }
}

