/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.hunter.streamrefactoring.core.analysis;

import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.types.TypeReference;
import edu.cuny.hunter.streamrefactoring.core.analysis.Util;
import java.util.Arrays;

public class StreamFindingVisitor
extends SSAInstruction.Visitor {
    private IClassHierarchy classHierarchy;
    private boolean foundStream = false;

    public StreamFindingVisitor(IClassHierarchy classHierarchy) {
        this.classHierarchy = classHierarchy;
    }

    protected IClassHierarchy getClassHierarchy() {
        return this.classHierarchy;
    }

    public boolean hasFoundStream() {
        return this.foundStream;
    }

    private void processType(TypeReference type) {
        if (Util.implementsBaseStream(type, this.getClassHierarchy())) {
            this.setFoundStream(true);
        }
    }

    protected void setFoundStream(boolean foundStream) {
        this.foundStream = foundStream;
    }

    public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
        this.processType(instruction.getElementType());
    }

    public void visitArrayStore(SSAArrayStoreInstruction instruction) {
        this.processType(instruction.getElementType());
    }

    public void visitCheckCast(SSACheckCastInstruction instruction) {
        Arrays.stream(instruction.getDeclaredResultTypes()).forEach(this::processType);
    }

    public void visitConditionalBranch(SSAConditionalBranchInstruction instruction) {
        this.processType(instruction.getType());
    }

    public void visitConversion(SSAConversionInstruction instruction) {
        this.processType(instruction.getToType());
        this.processType(instruction.getFromType());
    }

    public void visitGet(SSAGetInstruction instruction) {
        this.processType(instruction.getDeclaredFieldType());
    }

    public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
    }

    public void visitInstanceof(SSAInstanceofInstruction instruction) {
        this.processType(instruction.getCheckedType());
    }

    public void visitInvoke(SSAInvokeInstruction instruction) {
        this.processType(instruction.getDeclaredResultType());
    }

    public void visitLoadMetadata(SSALoadMetadataInstruction instruction) {
        this.processType(instruction.getType());
    }

    public void visitNew(SSANewInstruction instruction) {
        this.processType(instruction.getConcreteType());
    }

    public void visitPut(SSAPutInstruction instruction) {
        this.processType(instruction.getDeclaredFieldType());
    }
}

