/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.hunter.streamrefactoring.core.analysis;

import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.rules.TypestateRule;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraphBuilderCancelException;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.scope.JUnitEntryPoints;
import edu.cuny.hunter.streamrefactoring.core.analysis.CannotExtractSpliteratorException;
import edu.cuny.hunter.streamrefactoring.core.analysis.NoninstantiableException;
import edu.cuny.hunter.streamrefactoring.core.analysis.NoniterableException;
import edu.cuny.hunter.streamrefactoring.core.analysis.OrderingInference;
import edu.cuny.hunter.streamrefactoring.core.analysis.PreconditionFailure;
import edu.cuny.hunter.streamrefactoring.core.analysis.Stream;
import edu.cuny.hunter.streamrefactoring.core.analysis.StreamCreationNotConsideredException;
import edu.cuny.hunter.streamrefactoring.core.analysis.StreamStateMachine;
import edu.cuny.hunter.streamrefactoring.core.analysis.UnhandledCaseException;
import edu.cuny.hunter.streamrefactoring.core.analysis.Util;
import edu.cuny.hunter.streamrefactoring.core.messages.Messages;
import edu.cuny.hunter.streamrefactoring.core.utils.TimeCollector;
import edu.cuny.hunter.streamrefactoring.core.wala.EclipseProjectAnalysisEngine;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public class StreamAnalyzer
extends ASTVisitor {
    private static final String ENTRY_POINT_FILENAME = "entry_points.txt";
    private static final Logger LOGGER = Logger.getLogger("edu.cuny.hunter.streamrefactoring");
    private static final int N_FOR_STREAMS_DEFAULT = 2;
    private Map<EclipseProjectAnalysisEngine<InstanceKey>, Collection<Entrypoint>> enginesWithBuiltCallGraphsToEntrypointsUsed = new HashMap<EclipseProjectAnalysisEngine<InstanceKey>, Collection<Entrypoint>>();
    private boolean findImplicitBenchmarkEntryPoints;
    private boolean findImplicitEntryPoints = true;
    private boolean findImplicitJavaFXEntryPoints;
    private boolean findImplicitTestEntryPoints;
    private int nForStreams = 2;
    private int numberOfProcessedStreamInstances;
    private int numberOfSkippedStreamInstances;
    private Set<Stream> streamSet = new HashSet<Stream>();

    private static void addImplicitEntryPoints(Collection<Entrypoint> target, Iterable<Entrypoint> source) {
        for (Entrypoint implicitEntryPoint : source) {
            if (!target.add(implicitEntryPoint)) continue;
            LOGGER.info(() -> "Adding implicit entry point: " + implicitEntryPoint);
        }
    }

    private static Set<Entrypoint> findEntryPointsFromFile(IClassHierarchy classHierarchy, File file) throws IOException {
        HashSet<String> signatures = new HashSet<String>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Scanner scanner = new Scanner(file);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                signatures.add(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Set<Entrypoint> entrypoints = Util.findEntryPoints(classHierarchy, signatures);
        return entrypoints;
    }

    private static File getEntryPointsFile(IPath directory, String fileName) {
        File file;
        Path directoryPath = Paths.get(directory.toString(), new String[0]);
        do {
            file = new File(directoryPath.resolve(ENTRY_POINT_FILENAME).toString());
            directoryPath = directoryPath.getParent();
        } while (!file.exists() && directoryPath != null);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public StreamAnalyzer() {
        this(false);
    }

    public StreamAnalyzer(boolean visitDocTags) {
        super(visitDocTags);
    }

    public StreamAnalyzer(boolean visitDocTags, boolean findImplicitEntryPoints) {
        this(visitDocTags);
        this.findImplicitEntryPoints = findImplicitEntryPoints;
    }

    public StreamAnalyzer(boolean visitDocTags, boolean findImplicitEntryPoints, boolean findImplicitTestEntryPoints, boolean findImplicitBenchmarkEntryPoints, boolean findImplicitJavaFXEntryPoints) {
        this(visitDocTags, findImplicitEntryPoints);
        this.findImplicitTestEntryPoints = findImplicitTestEntryPoints;
        this.findImplicitBenchmarkEntryPoints = findImplicitBenchmarkEntryPoints;
        this.findImplicitJavaFXEntryPoints = findImplicitJavaFXEntryPoints;
    }

    public StreamAnalyzer(boolean visitDocTags, int nForStreams) {
        super(visitDocTags);
        this.nForStreams = nForStreams;
    }

    public StreamAnalyzer(boolean visitDocTags, int nForStreams, boolean findImplicitEntryPoints) {
        this(visitDocTags, findImplicitEntryPoints);
        this.nForStreams = nForStreams;
    }

    public StreamAnalyzer(boolean visitDocTags, int nForStreams, boolean findImplicitEntryPoints, boolean findImplicitTestEntryPoints, boolean findImplicitBenchmarkEntryPoints, boolean findImplicitJavaFXEntryPoints) {
        this(visitDocTags, findImplicitEntryPoints, findImplicitTestEntryPoints, findImplicitBenchmarkEntryPoints, findImplicitJavaFXEntryPoints);
        this.nForStreams = nForStreams;
    }

    public Map<IJavaProject, Collection<Entrypoint>> analyze() throws CoreException {
        return this.analyze(Optional.empty(), (IProgressMonitor)new NullProgressMonitor());
    }

    public Map<IJavaProject, Collection<Entrypoint>> analyze(Optional<TimeCollector> collector, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Analyzing...", (int)-1);
        LOGGER.fine(() -> "Using N = " + this.getNForStreams() + ".");
        HashMap<IJavaProject, Collection<Entrypoint>> ret = new HashMap<IJavaProject, Collection<Entrypoint>>();
        Map projectToStreams = this.getStreamSet().stream().filter(s -> s.getStatus().isOK()).collect(Collectors.groupingBy(Stream::getCreationJavaProject, Collectors.toSet()));
        subMonitor.beginTask("Processing projects ...", projectToStreams.keySet().size());
        for (IJavaProject project : projectToStreams.keySet()) {
            collector.ifPresent(TimeCollector::start);
            EclipseProjectAnalysisEngine<InstanceKey> engine = null;
            try {
                engine = new EclipseProjectAnalysisEngine<InstanceKey>(project, this.getNForStreams());
                engine.buildAnalysisScope();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Could not create analysis engine for: " + project.getElementName(), e);
                throw new RuntimeException(e);
            }
            collector.ifPresent(TimeCollector::stop);
            Collection<Entrypoint> entryPoints = null;
            try {
                entryPoints = this.buildCallGraph(engine, collector, (IProgressMonitor)subMonitor.split(-1, 0));
            }
            catch (CancelException | IOException | CoreException e) {
                LOGGER.log(Level.SEVERE, "Exception encountered while building call graph for: " + project.getElementName() + ".", e);
                throw new RuntimeException(e);
            }
            ret.put(project, entryPoints);
            Set streamSet = projectToStreams.get(project);
            if (entryPoints.isEmpty()) {
                for (Stream stream : streamSet) {
                    stream.addStatusEntry(PreconditionFailure.NO_ENTRY_POINT, "Project: " + engine.getProject().getElementName() + " has no entry points.");
                }
                return ret;
            }
            OrderingInference orderingInference = new OrderingInference(engine.getClassHierarchy());
            subMonitor.beginTask("Inferring initial stream attributes...", streamSet.size());
            Iterator iterator = streamSet.iterator();
            while (iterator.hasNext()) {
                Stream stream = (Stream)iterator.next();
                try {
                    stream.inferInitialAttributes(engine, orderingInference);
                }
                catch (InvalidClassFileException | IOException e) {
                    LOGGER.log(Level.SEVERE, "Exception encountered while processing: " + stream.getCreation() + ".", e);
                    throw new RuntimeException(e);
                }
                catch (UnhandledCaseException e) {
                    LOGGER.log(Level.WARNING, "Unhandled case encountered while processing: " + stream.getCreation(), e);
                    stream.addStatusEntry(PreconditionFailure.CURRENTLY_NOT_HANDLED, "Stream: " + stream.getCreation() + " has an unhandled case: " + e.getMessage());
                }
                catch (StreamCreationNotConsideredException e) {
                    LOGGER.log(Level.WARNING, "Unconsidered case encountered while processing: " + stream.getCreation(), e);
                    iterator.remove();
                    this.getStreamSet().remove(stream);
                }
                subMonitor.worked(1);
            }
            StreamStateMachine stateMachine = new StreamStateMachine();
            try {
                Map<TypestateRule, StreamStateMachine.Statistics> ruleToStats = stateMachine.start(streamSet.parallelStream().filter(s -> s.getStatus().isOK()).collect(Collectors.toSet()), engine, orderingInference, (IProgressMonitor)subMonitor.split(-1, 0));
                assert (!ruleToStats.isEmpty()) : "Should have stats available.";
                StreamStateMachine.Statistics statistics = ruleToStats.values().iterator().next();
                this.setNumberOfProcessedStreamInstances(statistics.getNumberOfStreamInstancesProcessed());
                this.setNumberOfSkippedStreamInstances(statistics.getNumberOfStreamInstancesSkipped());
            }
            catch (PropertiesException | InvalidClassFileException | CancelException | CannotExtractSpliteratorException | NoninstantiableException | NoniterableException | IOException e) {
                LOGGER.log(Level.SEVERE, "Error while starting state machine.", e);
                throw new RuntimeException(e);
            }
            SubMonitor checkMonitor = subMonitor.split(-1, 0);
            checkMonitor.beginTask(Messages.CheckingPreconditions, streamSet.size());
            for (Stream stream : streamSet.parallelStream().filter(s -> s.getStatus().isOK()).collect(Collectors.toSet())) {
                stream.check();
                checkMonitor.worked(1);
            }
            subMonitor.worked(1);
        }
        return ret;
    }

    protected Collection<Entrypoint> buildCallGraph(EclipseProjectAnalysisEngine<InstanceKey> engine, Optional<TimeCollector> collector, IProgressMonitor monitor) throws IOException, CoreException, CallGraphBuilderCancelException, CancelException {
        if (!this.enginesWithBuiltCallGraphsToEntrypointsUsed.keySet().contains(engine)) {
            Set<Entrypoint> entryPoints;
            collector.ifPresent(TimeCollector::start);
            File entryPointFile = StreamAnalyzer.getEntryPointsFile(engine.getProject().getResource().getLocation(), ENTRY_POINT_FILENAME);
            if (entryPointFile != null) {
                entryPoints = StreamAnalyzer.findEntryPointsFromFile(engine.getClassHierarchy(), entryPointFile);
                entryPoints.forEach(ep -> LOGGER.info(() -> "Adding explicit entry point from file: " + ep));
            } else {
                Set<Entrypoint> benchmarkEntryPoints;
                entryPoints = Util.findEntryPoints(engine.getClassHierarchy());
                entryPoints.forEach(ep -> LOGGER.info(() -> "Adding explicit entry point: " + ep));
                if (this.shouldFindImplicitEntryPoints()) {
                    Iterable mainEntrypoints = com.ibm.wala.ipa.callgraph.impl.Util.makeMainEntrypoints((AnalysisScope)engine.getClassHierarchy().getScope(), (IClassHierarchy)engine.getClassHierarchy());
                    StreamAnalyzer.addImplicitEntryPoints(entryPoints, mainEntrypoints);
                }
                if (this.shouldFindImplicitTestEntryPoints()) {
                    Iterable jUnitEntryPoints = JUnitEntryPoints.make((IClassHierarchy)engine.getClassHierarchy());
                    StreamAnalyzer.addImplicitEntryPoints(entryPoints, jUnitEntryPoints);
                }
                if (this.shouldFindImplicitBenchmarkEntryPoints()) {
                    benchmarkEntryPoints = Util.findBenchmarkEntryPoints(engine.getClassHierarchy());
                    StreamAnalyzer.addImplicitEntryPoints(entryPoints, benchmarkEntryPoints);
                }
                if (this.shouldFindImplicitJavaFXEntryPoints()) {
                    benchmarkEntryPoints = Util.findJavaFXEntryPoints(engine.getClassHierarchy());
                    StreamAnalyzer.addImplicitEntryPoints(entryPoints, benchmarkEntryPoints);
                }
            }
            if (entryPoints.isEmpty()) {
                LOGGER.warning(() -> "Project: " + engine.getProject().getElementName() + " has no entry points.");
                return entryPoints;
            }
            collector.ifPresent(TimeCollector::stop);
            AnalysisOptions options = engine.getDefaultOptions(entryPoints);
            options.setReflectionOptions(AnalysisOptions.ReflectionOptions.NONE);
            options.getSSAOptions().setPiNodePolicy(SSAOptions.getAllBuiltInPiNodes());
            try {
                engine.buildSafeCallGraph(options, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (String)"Building call graph", (int)1));
            }
            catch (IllegalStateException e) {
                LOGGER.log(Level.SEVERE, e, () -> "Exception encountered while building call graph for project: " + engine.getProject().getElementName());
                throw e;
            }
            this.enginesWithBuiltCallGraphsToEntrypointsUsed.put(engine, entryPoints);
        }
        return this.enginesWithBuiltCallGraphsToEntrypointsUsed.get(engine);
    }

    public int getNForStreams() {
        return this.nForStreams;
    }

    public int getNumberOfProcessedStreamInstances() {
        return this.numberOfProcessedStreamInstances;
    }

    public int getNumberOfSkippedStreamInstances() {
        return this.numberOfSkippedStreamInstances;
    }

    public Set<Stream> getStreamSet() {
        return this.streamSet;
    }

    public void setFindImplicitBenchmarkEntryPoints(boolean findImplicitBenchmarkEntryPoints) {
        this.findImplicitBenchmarkEntryPoints = findImplicitBenchmarkEntryPoints;
    }

    public void setFindImplicitEntryPoints(boolean findImplicitEntryPoints) {
        this.findImplicitEntryPoints = findImplicitEntryPoints;
    }

    public void setFindImplicitJavaFXEntryPoints(boolean findImplicitJavaFXEntryPoints) {
        this.findImplicitJavaFXEntryPoints = findImplicitJavaFXEntryPoints;
    }

    public void setFindImplicitTestEntryPoints(boolean findImplicitTestEntryPoints) {
        this.findImplicitTestEntryPoints = findImplicitTestEntryPoints;
    }

    protected void setNForStreams(int nForStreams) {
        this.nForStreams = nForStreams;
    }

    protected void setNumberOfProcessedStreamInstances(int numberOfProcessedStreamInstances) {
        this.numberOfProcessedStreamInstances = numberOfProcessedStreamInstances;
    }

    protected void setNumberOfSkippedStreamInstances(int numberOfSkippedStreamInstances) {
        this.numberOfSkippedStreamInstances = numberOfSkippedStreamInstances;
    }

    public boolean shouldFindImplicitBenchmarkEntryPoints() {
        return this.findImplicitBenchmarkEntryPoints;
    }

    public boolean shouldFindImplicitEntryPoints() {
        return this.findImplicitEntryPoints;
    }

    public boolean shouldFindImplicitJavaFXEntryPoints() {
        return this.findImplicitJavaFXEntryPoints;
    }

    public boolean shouldFindImplicitTestEntryPoints() {
        return this.findImplicitTestEntryPoints;
    }

    public boolean visit(MethodInvocation node) {
        boolean intermediateOperation;
        IMethodBinding methodBinding = node.resolveMethodBinding();
        ITypeBinding returnType = methodBinding.getReturnType();
        boolean returnTypeImplementsBaseStream = Util.implementsBaseStream(returnType);
        ITypeBinding declaringClass = methodBinding.getDeclaringClass();
        boolean declaringClassImplementsBaseStream = Util.implementsBaseStream(declaringClass);
        String[] declaringClassPackageNameComponents = declaringClass.getPackage().getNameComponents();
        boolean isFromAPI = declaringClassPackageNameComponents.length > 0 && declaringClassPackageNameComponents[0].equals("java");
        boolean instanceMethod = !JdtFlags.isStatic((IMethodBinding)methodBinding);
        boolean bl = intermediateOperation = instanceMethod && declaringClassImplementsBaseStream;
        if (returnTypeImplementsBaseStream && !intermediateOperation && isFromAPI) {
            Stream stream = null;
            try {
                stream = new Stream(node);
            }
            catch (ClassHierarchyException | InvalidClassFileException | CancelException | IOException | CoreException e) {
                LOGGER.log(Level.SEVERE, "Encountered exception while processing: " + node, e);
                throw new RuntimeException(e);
            }
            this.getStreamSet().add(stream);
        }
        return super.visit(node);
    }
}

