/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.citytech.refactoring.common.tests;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.logging.Logger;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class RefactoringTest
extends org.eclipse.jdt.ui.tests.refactoring.RefactoringTest {
    private static final String REPLACE_EXPECTED_WITH_ACTUAL_KEY = "edu.cuny.citytech.refactoring.common.tests.replaceExpectedWithActual";
    private static final String RESOURCE_PATH = "resources";
    private boolean replaceExpectedWithActual;

    public RefactoringTest(String name, boolean replaceExpectedWithActual) {
        super(name);
        this.replaceExpectedWithActual = replaceExpectedWithActual;
    }

    public RefactoringTest(String name) {
        super(name);
        String replaceProperty = System.getenv(REPLACE_EXPECTED_WITH_ACTUAL_KEY);
        if (replaceProperty != null) {
            this.replaceExpectedWithActual = Boolean.valueOf(replaceProperty);
        }
    }

    private static void assertFailedPrecondition(RefactoringStatus initialStatus, RefactoringStatus finalStatus) {
        RefactoringTest.assertTrue((String)"Precondition was supposed to fail.", (!initialStatus.isOK() || !finalStatus.isOK() ? 1 : 0) != 0);
    }

    protected void assertFailedPrecondition(IMethod ... methods) throws CoreException {
        Refactoring refactoring = this.getRefactoring(methods);
        RefactoringStatus initialStatus = refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        this.getLogger().info("Initial status: " + initialStatus);
        RefactoringStatus finalStatus = refactoring.checkFinalConditions((IProgressMonitor)new NullProgressMonitor());
        this.getLogger().info("Final status: " + finalStatus);
        RefactoringTest.assertFailedPrecondition(initialStatus, finalStatus);
    }

    protected abstract Logger getLogger();

    protected abstract Refactoring getRefactoring(IMethod ... var1) throws JavaModelException;

    public String getFileContents(String fileName) throws IOException {
        Path absolutePath = this.getAbsolutionPath(fileName);
        byte[] encoded = Files.readAllBytes(absolutePath);
        return new String(encoded, Charset.defaultCharset());
    }

    private Path getAbsolutionPath(String fileName) {
        Path path = Paths.get(RESOURCE_PATH, fileName);
        Path absolutePath = path.toAbsolutePath();
        return absolutePath;
    }

    public void setFileContents(String fileName, String contents) throws IOException {
        Path absolutePath = this.getAbsolutionPath(fileName);
        Files.write(absolutePath, contents.getBytes(), new OpenOption[0]);
    }

    protected ICompilationUnit createCUfromTestFile(IPackageFragment pack, String cuName) throws Exception {
        ICompilationUnit unit = super.createCUfromTestFile(pack, cuName);
        if (!unit.isStructureKnown()) {
            throw new IllegalArgumentException(String.valueOf(cuName) + " has structural errors.");
        }
        return unit;
    }

    private void helperFail(String typeName, String outerMethodName, String[] outerSignature, String innerTypeName, String[] methodNames, String[][] signatures) throws Exception {
        ICompilationUnit cu = this.createCUfromTestFile(this.getPackageP(), typeName);
        IType type = this.getType(cu, typeName);
        if (outerMethodName != null) {
            IMethod method = type.getMethod(outerMethodName, outerSignature);
            type = innerTypeName != null ? method.getType(innerTypeName, 1) : method.getType("", 1);
        } else if (innerTypeName != null) {
            type = type.getType(innerTypeName);
        }
        IMethod[] methods = RefactoringTest.getMethods((IType)type, (String[])methodNames, (String[][])signatures);
        this.assertFailedPrecondition(methods);
    }

    protected void helperFail(String outerMethodName, String[] outerSignature, String innerTypeName, String[] methodNames, String[][] signatures) throws Exception {
        this.helperFail("A", outerMethodName, outerSignature, innerTypeName, methodNames, signatures);
    }

    protected void helperFail(String outerMethodName, String[] outerSignature, String[] methodNames, String[][] signatures) throws Exception {
        this.helperFail("A", outerMethodName, outerSignature, null, methodNames, signatures);
    }

    protected void helperFail(String innerTypeName, String[] methodNames, String[][] signatures) throws Exception {
        this.helperFail("A", null, null, innerTypeName, methodNames, signatures);
    }

    protected void helperPass(String innerTypeName, String[] methodNames, String[][] signatures) throws Exception {
        this.helperPass("A", null, null, innerTypeName, methodNames, signatures);
    }

    protected void helperFail(String[] methodNames, String[][] signatures) throws Exception {
        this.helperFail("A", null, null, null, methodNames, signatures);
    }

    protected void helperFail() throws Exception {
        this.helperFail("A", null, null);
    }

    protected void helperPass(String[] methodNames, String[][] signatures) throws Exception {
        this.helperPass(methodNames, signatures, true);
    }

    protected void helperPass(String[] methodNames, String[][] signatures, boolean testCompilation) throws Exception {
        ICompilationUnit cu = this.createCUfromTestFile(this.getPackageP(), "A");
        IType type = this.getType(cu, "A");
        IMethod[] methods = RefactoringTest.getMethods((IType)type, (String[])methodNames, (String[][])signatures);
        this.helperPass(cu, methods, testCompilation);
    }

    private void helperPass(ICompilationUnit cu, IMethod[] methods) throws JavaModelException, CoreException, Exception, IOException {
        this.helperPass(cu, methods, true);
    }

    private void helperPass(ICompilationUnit cu, IMethod[] methods, boolean testCompilation) throws JavaModelException, CoreException, Exception, IOException {
        Refactoring refactoring = this.getRefactoring(methods);
        RefactoringStatus initialStatus = refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        this.getLogger().info("Initial status: " + initialStatus);
        RefactoringStatus finalStatus = refactoring.checkFinalConditions((IProgressMonitor)new NullProgressMonitor());
        this.getLogger().info("Final status: " + finalStatus);
        RefactoringTest.assertTrue((String)"Precondition was supposed to pass.", (initialStatus.isOK() && finalStatus.isOK() ? 1 : 0) != 0);
        this.performChange(refactoring, false);
        String outputTestFileName = this.getOutputTestFileName("A");
        String actual = cu.getSource();
        if (testCompilation) {
            RefactoringTest.assertTrue((String)"Actual output should compile.", (boolean)RefactoringTest.compiles(actual));
        }
        if (this.replaceExpectedWithActual) {
            this.setFileContents(outputTestFileName, actual);
        }
        String expected = this.getFileContents(outputTestFileName);
        RefactoringTest.assertEqualLines((String)expected, (String)actual);
    }

    private static boolean compiles(String source) throws IOException {
        Path root = Files.createTempDirectory(null, new FileAttribute[0]);
        File sourceFile = new File(root.toFile(), "p/A.java");
        sourceFile.getParentFile().mkdirs();
        Files.write(sourceFile.toPath(), source.getBytes(), new OpenOption[0]);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        return compiler.run(null, null, null, sourceFile.getPath()) == 0;
    }

    private void helperPass(String typeName, String outerMethodName, String[] outerSignature, String innerTypeName, String[] methodNames, String[][] signatures) throws Exception {
        ICompilationUnit cu = this.createCUfromTestFile(this.getPackageP(), typeName);
        IType type = this.getType(cu, typeName);
        if (outerMethodName != null) {
            IMethod method = type.getMethod(outerMethodName, outerSignature);
            type = innerTypeName != null ? method.getType(innerTypeName, 1) : method.getType("", 1);
        } else if (innerTypeName != null) {
            type = type.getType(innerTypeName);
        }
        IMethod[] methods = RefactoringTest.getMethods((IType)type, (String[])methodNames, (String[][])signatures);
        this.helperPass(cu, methods);
    }

    protected void helperPass(String[] methodNames1, String[][] signatures1, String[] methodNames2, String[][] signatures2) throws Exception {
        ICompilationUnit cu = this.createCUfromTestFile(this.getPackageP(), "A");
        IType type = this.getType(cu, "A");
        LinkedHashSet methodSet = new LinkedHashSet();
        Collections.addAll(methodSet, RefactoringTest.getMethods((IType)type, (String[])methodNames1, (String[][])signatures1));
        type = this.getType(cu, "B");
        Collections.addAll(methodSet, RefactoringTest.getMethods((IType)type, (String[])methodNames2, (String[][])signatures2));
        Refactoring refactoring = this.getRefactoring(methodSet.toArray(new IMethod[methodSet.size()]));
        RefactoringStatus initialStatus = refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        this.getLogger().info("Initial status: " + initialStatus);
        RefactoringStatus finalStatus = refactoring.checkFinalConditions((IProgressMonitor)new NullProgressMonitor());
        this.getLogger().info("Final status: " + finalStatus);
        RefactoringTest.assertTrue((String)"Precondition was supposed to pass.", (initialStatus.isOK() && finalStatus.isOK() ? 1 : 0) != 0);
        this.performChange(refactoring, false);
        String outputTestFileName = this.getOutputTestFileName("A");
        String actual = cu.getSource();
        RefactoringTest.assertTrue((String)"Actual output should compile.", (boolean)RefactoringTest.compiles(actual));
        if (this.replaceExpectedWithActual) {
            this.setFileContents(outputTestFileName, actual);
        }
        String expected = this.getFileContents(outputTestFileName);
        RefactoringTest.assertEqualLines((String)expected, (String)actual);
    }

    protected void helperPassNoFatal(String[] methodNames1, String[][] signatures1, String[] methodNames2, String[][] signatures2) throws Exception {
        ICompilationUnit cu = this.createCUfromTestFile(this.getPackageP(), "A");
        IType type = this.getType(cu, "A");
        LinkedHashSet methodSet = new LinkedHashSet();
        Collections.addAll(methodSet, RefactoringTest.getMethods((IType)type, (String[])methodNames1, (String[][])signatures1));
        type = this.getType(cu, "B");
        Collections.addAll(methodSet, RefactoringTest.getMethods((IType)type, (String[])methodNames2, (String[][])signatures2));
        Refactoring refactoring = this.getRefactoring(methodSet.toArray(new IMethod[methodSet.size()]));
        RefactoringStatus initialStatus = refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        this.getLogger().info("Initial status: " + initialStatus);
        RefactoringStatus finalStatus = refactoring.checkFinalConditions((IProgressMonitor)new NullProgressMonitor());
        this.getLogger().info("Final status: " + finalStatus);
        RefactoringTest.assertTrue((String)"Precondition was supposed to pass.", (!initialStatus.hasFatalError() && !finalStatus.hasFatalError() ? 1 : 0) != 0);
        this.performChange(refactoring, false);
        String outputTestFileName = this.getOutputTestFileName("A");
        String actual = cu.getSource();
        RefactoringTest.assertTrue((String)"Actual output should compile.", (boolean)RefactoringTest.compiles(actual));
        if (this.replaceExpectedWithActual) {
            this.setFileContents(outputTestFileName, actual);
        }
        String expected = this.getFileContents(outputTestFileName);
        RefactoringTest.assertEqualLines((String)expected, (String)actual);
    }

    protected void helperPassNoFatal(String[] methodNames1, String[][] signatures1, String[] methodNames2, String[][] signatures2, String[] methodNames3, String[][] signatures3) throws Exception {
        ICompilationUnit cu = this.createCUfromTestFile(this.getPackageP(), "A");
        IType type = this.getType(cu, "A");
        LinkedHashSet methodSet = new LinkedHashSet();
        Collections.addAll(methodSet, RefactoringTest.getMethods((IType)type, (String[])methodNames1, (String[][])signatures1));
        type = this.getType(cu, "B");
        Collections.addAll(methodSet, RefactoringTest.getMethods((IType)type, (String[])methodNames2, (String[][])signatures2));
        type = this.getType(cu, "C");
        Collections.addAll(methodSet, RefactoringTest.getMethods((IType)type, (String[])methodNames3, (String[][])signatures3));
        Refactoring refactoring = this.getRefactoring(methodSet.toArray(new IMethod[methodSet.size()]));
        RefactoringStatus initialStatus = refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        this.getLogger().info("Initial status: " + initialStatus);
        RefactoringStatus finalStatus = refactoring.checkFinalConditions((IProgressMonitor)new NullProgressMonitor());
        this.getLogger().info("Final status: " + finalStatus);
        RefactoringTest.assertTrue((String)"Precondition was supposed to pass.", (!initialStatus.hasFatalError() && !finalStatus.hasFatalError() ? 1 : 0) != 0);
        this.performChange(refactoring, false);
        String outputTestFileName = this.getOutputTestFileName("A");
        String actual = cu.getSource();
        RefactoringTest.assertTrue((String)"Actual output should compile.", (boolean)RefactoringTest.compiles(actual));
        if (this.replaceExpectedWithActual) {
            this.setFileContents(outputTestFileName, actual);
        }
        String expected = this.getFileContents(outputTestFileName);
        RefactoringTest.assertEqualLines((String)expected, (String)actual);
    }

    public void testPlainMethod() throws Exception {
        this.helperPass(new String[]{"m"}, new String[][]{new String[0]});
    }
}

