/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.util;

import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.visit.CAstVisitor;
import com.ibm.wala.cast.util.CAstPrinter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class CAstPattern {
    private static boolean DEBUG_PARSER = false;
    private static boolean DEBUG_MATCH = false;
    private static final int CHILD_KIND = -1;
    private static final int CHILDREN_KIND = -2;
    private static final int REPEATED_PATTERN_KIND = -3;
    private static final int ALTERNATIVE_PATTERN_KIND = -4;
    private static final int OPTIONAL_PATTERN_KIND = -5;
    private static final int REFERENCE_PATTERN_KIND = -6;
    private static final int IGNORE_KIND = -99;
    private final String name;
    private final int kind;
    private final Object value;
    private final CAstPattern[] children;
    private final Map<String, CAstPattern> references;

    public CAstPattern(String name, int kind, CAstPattern[] children) {
        this.name = name;
        this.kind = kind;
        this.value = null;
        this.children = children;
        this.references = null;
    }

    public CAstPattern(String name, Object value) {
        this.name = name;
        this.kind = -99;
        this.value = value;
        this.children = null;
        this.references = null;
    }

    public CAstPattern(String patternName, Map<String, CAstPattern> references) {
        this.name = null;
        this.kind = -6;
        this.value = patternName;
        this.references = references;
        this.children = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.name != null) {
            sb.append("<").append(this.name).append(">");
        }
        if (this.value != null) {
            if (this.kind == -6) {
                sb.append("ref:").append(this.value);
            } else if (this.value instanceof Pattern) {
                sb.append("/").append(this.value).append("/");
            } else {
                sb.append("literal:").append(this.value);
            }
        } else if (this.kind == -1) {
            sb.append("*");
        } else if (this.kind == -2) {
            sb.append("**");
        } else if (this.kind == -3) {
            sb.append("@");
        } else if (this.kind == -4) {
            sb.append("|");
        } else if (this.kind == -5) {
            sb.append("?");
        } else {
            sb.append(CAstPrinter.kindAsString(this.kind));
        }
        if (this.children != null) {
            sb.append("(");
            int i = 0;
            while (i < this.children.length) {
                sb.append(this.children[i].toString());
                if (i == this.children.length - 1) {
                    sb.append(")");
                } else {
                    sb.append(",");
                }
                ++i;
            }
        }
        return sb.toString();
    }

    private static boolean matchChildren(CAstNode tree, int i, CAstPattern[] cs, int j, Segments s) {
        if (i >= tree.getChildCount() && j >= cs.length) {
            return true;
        }
        if (i < tree.getChildCount() && j >= cs.length) {
            return false;
        }
        if (i >= tree.getChildCount() && j < cs.length) {
            switch (cs[j].kind) {
                case -5: 
                case -3: 
                case -2: {
                    return CAstPattern.matchChildren(tree, i, cs, j + 1, s);
                }
            }
            return false;
        }
        if (cs[j].kind == -1) {
            if (DEBUG_MATCH) {
                System.err.println("* matches " + CAstPrinter.print(tree.getChild(i)));
            }
            if (s != null && cs[j].name != null) {
                s.add(cs[j].name, tree.getChild(i));
            }
            return CAstPattern.matchChildren(tree, i + 1, cs, j + 1, s);
        }
        if (cs[j].kind == -2) {
            if (CAstPattern.tryMatchChildren(tree, i, cs, j + 1, s)) {
                if (DEBUG_MATCH) {
                    System.err.println("** matches nothing");
                }
                return true;
            }
            if (DEBUG_MATCH) {
                System.err.println("** matches " + CAstPrinter.print(tree.getChild(i)));
            }
            if (s != null && cs[j].name != null) {
                s.add(cs[j].name, tree.getChild(i));
            }
            return CAstPattern.matchChildren(tree, i + 1, cs, j, s);
        }
        if (cs[j].kind == -3) {
            CAstPattern repeatedPattern = cs[j].children[0];
            if (repeatedPattern.tryMatch(tree.getChild(i), s)) {
                if (s != null && cs[j].name != null) {
                    s.add(cs[j].name, tree.getChild(i));
                }
                if (DEBUG_MATCH) {
                    System.err.println(cs[j] + " matches " + CAstPrinter.print(tree.getChild(i)));
                }
                return CAstPattern.matchChildren(tree, i + 1, cs, j, s);
            }
            if (DEBUG_MATCH) {
                System.err.println(cs[j] + " matches nothing");
            }
            return CAstPattern.matchChildren(tree, i, cs, j + 1, s);
        }
        if (cs[j].kind == -5) {
            if (CAstPattern.tryMatchChildren(tree, i, cs, j + 1, s)) {
                if (DEBUG_MATCH) {
                    System.err.println(cs[j] + " matches nothing");
                }
                return true;
            }
            CAstPattern optionalPattern = cs[j].children[0];
            if (optionalPattern.tryMatch(tree.getChild(i), s)) {
                if (DEBUG_MATCH) {
                    System.err.println(cs[j] + " matches " + CAstPrinter.print(tree.getChild(i)));
                }
                return CAstPattern.matchChildren(tree, i + 1, cs, j + 1, s);
            }
            return false;
        }
        return cs[j].match(tree.getChild(i), s) && CAstPattern.matchChildren(tree, i + 1, cs, j + 1, s);
    }

    public boolean match(CAstNode tree, Segments s) {
        if (DEBUG_MATCH) {
            System.err.println("matching " + this + " against " + CAstPrinter.print(tree));
        }
        if (this.kind == -6) {
            return this.references.get(this.value).match(tree, s);
        }
        if (this.kind == -4) {
            int i = 0;
            while (i < this.children.length) {
                if (this.children[i].tryMatch(tree, s)) {
                    if (s != null && this.name != null) {
                        s.add(this.name, tree);
                    }
                    return true;
                }
                ++i;
            }
            if (DEBUG_MATCH) {
                System.err.println("match failed (a)");
            }
            return false;
        }
        if (this.value == null ? tree.getKind() != this.kind : tree.getKind() != 300 || (this.value instanceof Pattern ? !((Pattern)this.value).matcher(tree.getValue().toString()).matches() : !this.value.equals(tree.getValue().toString()))) {
            if (DEBUG_MATCH) {
                System.err.println("match failed (b)");
            }
            return false;
        }
        if (s != null && this.name != null) {
            s.add(this.name, tree);
        }
        if (this.children == null || this.children.length == 0) {
            if (DEBUG_MATCH && tree.getChildCount() != 0) {
                System.err.println("match failed (c)");
            }
            return tree.getChildCount() == 0;
        }
        return CAstPattern.matchChildren(tree, 0, this.children, 0, s);
    }

    private static boolean tryMatchChildren(CAstNode tree, int i, CAstPattern[] cs, int j, Segments s) {
        if (s == null) {
            return CAstPattern.matchChildren(tree, i, cs, j, s);
        }
        Segments ss = new Segments();
        boolean result = CAstPattern.matchChildren(tree, i, cs, j, ss);
        if (result) {
            s.addAll(ss);
        }
        return result;
    }

    private boolean tryMatch(CAstNode tree, Segments s) {
        if (s == null) {
            return this.match(tree, s);
        }
        Segments ss = new Segments();
        boolean result = this.match(tree, ss);
        if (result) {
            s.addAll(ss);
        }
        return result;
    }

    public static Segments match(CAstPattern p, CAstNode n) {
        Segments s = new Segments();
        if (p.match(n, s)) {
            return s;
        }
        return null;
    }

    public static CAstPattern parse(String patternString) {
        try {
            return new Parser(patternString).parse();
        }
        catch (NoSuchFieldException e) {
            Assertions.UNREACHABLE((String)("no such kind in pattern: " + e.getMessage()));
            return null;
        }
        catch (IllegalAccessException e) {
            Assertions.UNREACHABLE((String)("internal error in CAstPattern" + e));
            return null;
        }
    }

    public static Collection<Segments> findAll(CAstPattern p, final CAstEntity e) {
        return p.new Matcher().findAll(new CAstVisitor.Context(){

            @Override
            public CAstEntity top() {
                return e;
            }

            @Override
            public CAstSourcePositionMap getSourceMap() {
                return e.getSourceMap();
            }
        }, e.getAST());
    }

    public class Matcher
    extends CAstVisitor<CAstVisitor.Context> {
        private final Collection<Segments> result = HashSetFactory.make();

        @Override
        public void leaveNode(CAstNode n, CAstVisitor.Context c, CAstVisitor visitor) {
            Segments s = CAstPattern.match(CAstPattern.this, n);
            if (s != null) {
                this.result.add(s);
            }
        }

        public Collection<Segments> findAll(CAstVisitor.Context c, CAstNode top) {
            this.visit(top, c, this);
            return this.result;
        }
    }

    private static class Parser {
        private final Map<String, CAstPattern> namedPatterns = HashMapFactory.make();
        private final String patternString;
        private int start;
        private int end;

        private Parser(String patternString) {
            this.patternString = patternString;
        }

        private String parseName(boolean internal) {
            if (this.patternString.charAt(this.start) == (internal ? (char)'{' : '<')) {
                int nameStart = this.start + 1;
                int nameEnd = this.patternString.indexOf(internal ? 125 : 62, nameStart);
                this.start = nameEnd + 1;
                return this.patternString.substring(nameStart, nameEnd);
            }
            return null;
        }

        public CAstPattern parse() throws NoSuchFieldException, IllegalAccessException {
            CAstPattern result;
            if (DEBUG_PARSER) {
                System.err.println("parsing " + this.patternString.substring(this.start));
            }
            String internalName = this.parseName(true);
            String name = this.parseName(false);
            if (this.patternString.charAt(this.start) == '`') {
                int strEnd = this.patternString.indexOf(96, this.start + 1);
                this.end = strEnd + 1;
                String patternName = this.patternString.substring(this.start + 1, strEnd);
                assert (internalName == null);
                result = new CAstPattern(patternName, this.namedPatterns);
            } else if (this.patternString.charAt(this.start) == '\"') {
                int strEnd = this.patternString.indexOf(34, this.start + 1);
                this.end = strEnd + 1;
                result = new CAstPattern(name, this.patternString.substring(this.start + 1, strEnd));
            } else if (this.patternString.charAt(this.start) == '/') {
                int strEnd = this.patternString.indexOf(47, this.start + 1);
                this.end = strEnd + 1;
                result = new CAstPattern(name, Pattern.compile(this.patternString.substring(this.start + 1, strEnd)));
            } else if (this.patternString.startsWith("**", this.start)) {
                this.end = this.start + 2;
                result = new CAstPattern(name, -2, null);
            } else if (this.patternString.startsWith("*", this.start)) {
                this.end = this.start + 1;
                result = new CAstPattern(name, -1, null);
            } else if (this.patternString.startsWith("|(", this.start)) {
                ArrayList<CAstPattern> alternatives = new ArrayList<CAstPattern>();
                this.start += 2;
                do {
                    alternatives.add(this.parse());
                    this.start = this.end + 2;
                } while (this.patternString.startsWith("||", this.end));
                assert (this.patternString.startsWith(")|", this.end)) : this.patternString;
                this.end += 2;
                result = new CAstPattern(name, -4, alternatives.toArray(new CAstPattern[alternatives.size()]));
            } else if (this.patternString.startsWith("@(", this.start)) {
                this.start += 2;
                CAstPattern[] children = new CAstPattern[]{this.parse()};
                assert (this.patternString.startsWith(")@", this.end));
                this.end += 2;
                if (DEBUG_PARSER) {
                    System.err.println("repeated pattern: " + children[0]);
                }
                result = new CAstPattern(name, -3, children);
            } else if (this.patternString.startsWith("?(", this.start)) {
                this.start += 2;
                CAstPattern[] children = new CAstPattern[]{this.parse()};
                assert (this.patternString.startsWith(")?", this.end));
                this.end += 2;
                if (DEBUG_PARSER) {
                    System.err.println("optional pattern: " + children[0]);
                }
                result = new CAstPattern(name, -5, children);
            } else {
                int kindEnd = this.patternString.indexOf(40, this.start);
                String kindStr = this.patternString.substring(this.start, kindEnd);
                Field kindField = CAstNode.class.getField(kindStr);
                int kind = kindField.getInt(null);
                if (this.patternString.charAt(kindEnd + 1) == ')') {
                    this.end = kindEnd + 2;
                    result = new CAstPattern(name, kind, null);
                } else {
                    ArrayList<CAstPattern> children = new ArrayList<CAstPattern>();
                    this.start = this.patternString.indexOf(40, this.start) + 1;
                    do {
                        children.add(this.parse());
                        this.start = this.end + 1;
                        if (!DEBUG_PARSER) continue;
                        System.err.println("parsing children: " + this.patternString.substring(this.end));
                    } while (this.patternString.charAt(this.end) == ',');
                    assert (this.patternString.charAt(this.end) == ')');
                    ++this.end;
                    result = new CAstPattern(name, kind, children.toArray(new CAstPattern[children.size()]));
                }
            }
            if (internalName != null) {
                this.namedPatterns.put(internalName, result);
            }
            return result;
        }
    }

    public static class Segments
    extends TreeMap<String, Object> {
        public CAstNode getSingle(String name) {
            assert (this.containsKey(name)) : name;
            return (CAstNode)this.get(name);
        }

        public List<CAstNode> getMultiple(String name) {
            if (!this.containsKey(name)) {
                return Collections.emptyList();
            }
            Object o = this.get(name);
            if (o instanceof CAstNode) {
                return Collections.singletonList((CAstNode)o);
            }
            assert (o instanceof List);
            return (List)o;
        }

        private void addAll(Segments other) {
            for (Map.Entry e : other.entrySet()) {
                String name = (String)e.getKey();
                if (e.getValue() instanceof CAstNode) {
                    this.add(name, (CAstNode)e.getValue());
                    continue;
                }
                Iterator vs = ((List)e.getValue()).iterator();
                while (vs.hasNext()) {
                    this.add(name, (CAstNode)vs.next());
                }
            }
        }

        private void add(String name, CAstNode result) {
            if (this.containsKey(name)) {
                Object o = this.get(name);
                if (o instanceof List) {
                    ((List)o).add(result);
                } else {
                    assert (o instanceof CAstNode);
                    ArrayList<Object> x = new ArrayList<Object>();
                    x.add(o);
                    x.add(result);
                    this.put(name, x);
                }
            } else {
                this.put(name, result);
            }
        }
    }
}

