/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.tree.rewrite;

import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstNodeTypeMap;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.CAstControlFlowRecorder;
import com.ibm.wala.cast.tree.impl.CAstNodeTypeMapRecorder;
import com.ibm.wala.cast.tree.impl.CAstSourcePositionRecorder;
import com.ibm.wala.cast.tree.impl.DelegatingEntity;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public abstract class CAstRewriter<C extends RewriteContext<K>, K extends CopyKey<K>> {
    protected static final boolean DEBUG = false;
    protected final CAst Ast;
    protected final boolean recursive;
    protected final C rootContext;

    public CAstRewriter(CAst Ast, boolean recursive, C rootContext) {
        this.Ast = Ast;
        this.recursive = recursive;
        this.rootContext = rootContext;
    }

    protected abstract CAstNode copyNodes(CAstNode var1, CAstControlFlowMap var2, C var3, Map<Pair<CAstNode, K>, CAstNode> var4);

    protected CAstNode flowOutTo(Map<Pair<CAstNode, K>, CAstNode> nodeMap, CAstNode oldSource, Object label, CAstNode oldTarget, CAstControlFlowMap orig, CAstSourcePositionMap src) {
        return oldTarget;
    }

    protected CAstControlFlowMap copyFlow(Map<Pair<CAstNode, K>, CAstNode> nodeMap, CAstControlFlowMap orig, CAstSourcePositionMap newSrc) {
        CAstControlFlowRecorder newMap = new CAstControlFlowRecorder(newSrc);
        HashSet mappedOutsideNodes = HashSetFactory.make((int)1);
        HashSet allNewTargetNodes = HashSetFactory.make((int)1);
        Collection<CAstNode> oldSources = orig.getMappedNodes();
        for (Map.Entry<Pair<CAstNode, K>, CAstNode> entry : nodeMap.entrySet()) {
            Pair<CAstNode, K> N = entry.getKey();
            CAstNode oldSource = (CAstNode)N.fst;
            CopyKey key = (CopyKey)N.snd;
            CAstNode newSource = entry.getValue();
            assert (newSource != null);
            newMap.map(newSource, newSource);
            if (!oldSources.contains(oldSource)) continue;
            for (Object origLabel : orig.getTargetLabels(oldSource)) {
                CAstNode newTarget;
                Pair targetKey;
                CAstNode oldTarget = orig.getTarget(oldSource, origLabel);
                assert (oldTarget != null);
                CopyKey k = key;
                do {
                    targetKey = Pair.make((Object)oldTarget, (Object)k);
                    if (k == null) break;
                    k = k.parent();
                } while (!nodeMap.containsKey(targetKey));
                Object newLabel = nodeMap.containsKey(Pair.make((Object)origLabel, (Object)targetKey.snd)) ? nodeMap.get(Pair.make((Object)origLabel, (Object)targetKey.snd)) : origLabel;
                if (nodeMap.containsKey(targetKey)) {
                    newTarget = nodeMap.get(targetKey);
                    newMap.add(newSource, newTarget, newLabel);
                    allNewTargetNodes.add(newTarget);
                    continue;
                }
                newTarget = this.flowOutTo(nodeMap, oldSource, origLabel, oldTarget, orig, newSrc);
                allNewTargetNodes.add(newTarget);
                newMap.add(newSource, newTarget, newLabel);
                if (newTarget == CAstControlFlowMap.EXCEPTION_TO_EXIT || mappedOutsideNodes.contains(newTarget)) continue;
                mappedOutsideNodes.add(newTarget);
                newMap.map(newTarget, newTarget);
            }
        }
        allNewTargetNodes.removeAll(newMap.getMappedNodes());
        for (CAstNode newTarget : allNewTargetNodes) {
            if (newTarget == CAstControlFlowMap.EXCEPTION_TO_EXIT) continue;
            newMap.map(newTarget, newTarget);
        }
        assert (!this.oldNodesInNewMap(nodeMap, newMap));
        return newMap;
    }

    private boolean oldNodesInNewMap(Map<Pair<CAstNode, K>, CAstNode> nodeMap, CAstControlFlowRecorder newMap) {
        HashSet oldNodes = HashSetFactory.make();
        for (Map.Entry<Pair<CAstNode, K>, CAstNode> e : nodeMap.entrySet()) {
            oldNodes.add((CAstNode)e.getKey().fst);
        }
        for (CAstNode mappedNode : newMap.getMappedNodes()) {
            if (oldNodes.contains(mappedNode)) {
                return true;
            }
            for (Object lbl : newMap.getTargetLabels(mappedNode)) {
                if (!oldNodes.contains(newMap.getTarget(mappedNode, lbl))) continue;
                return true;
            }
        }
        return false;
    }

    protected CAstSourcePositionMap copySource(Map<Pair<CAstNode, K>, CAstNode> nodeMap, CAstSourcePositionMap orig) {
        CAstSourcePositionRecorder newMap = new CAstSourcePositionRecorder();
        for (Map.Entry<Pair<CAstNode, K>, CAstNode> entry : nodeMap.entrySet()) {
            Pair<CAstNode, K> N = entry.getKey();
            CAstNode oldNode = (CAstNode)N.fst;
            CAstNode newNode = entry.getValue();
            if (orig.getPosition(oldNode) == null) continue;
            newMap.setPosition(newNode, orig.getPosition(oldNode));
        }
        return newMap;
    }

    protected CAstNodeTypeMap copyTypes(Map<Pair<CAstNode, K>, CAstNode> nodeMap, CAstNodeTypeMap orig) {
        if (orig != null) {
            CAstNodeTypeMapRecorder newMap = new CAstNodeTypeMapRecorder();
            for (Map.Entry<Pair<CAstNode, K>, CAstNode> entry : nodeMap.entrySet()) {
                Pair<CAstNode, K> N = entry.getKey();
                CAstNode oldNode = (CAstNode)N.fst;
                CAstNode newNode = entry.getValue();
                if (orig.getNodeType(oldNode) == null) continue;
                newMap.add(newNode, orig.getNodeType(oldNode));
            }
            return newMap;
        }
        return null;
    }

    protected Map<CAstNode, Collection<CAstEntity>> copyChildren(CAstNode root, Map<Pair<CAstNode, K>, CAstNode> nodeMap, Map<CAstNode, Collection<CAstEntity>> children) {
        LinkedHashMap<CAstNode, Collection<CAstEntity>> newChildren = new LinkedHashMap<CAstNode, Collection<CAstEntity>>();
        for (Map.Entry<Pair<CAstNode, K>, CAstNode> entry : nodeMap.entrySet()) {
            Pair<CAstNode, K> N = entry.getKey();
            CAstNode oldNode = (CAstNode)N.fst;
            CAstNode newNode = entry.getValue();
            if (!children.containsKey(oldNode)) continue;
            LinkedHashSet<CAstEntity> newEntities = new LinkedHashSet<CAstEntity>();
            newChildren.put(newNode, newEntities);
            Iterator<CAstEntity> oldEntities = children.get(oldNode).iterator();
            while (oldEntities.hasNext()) {
                newEntities.add(this.rewrite(oldEntities.next()));
            }
        }
        for (Map.Entry<CAstNode, Collection<CAstEntity>> entry : children.entrySet()) {
            CAstNode key = entry.getKey();
            if (key != null) continue;
            LinkedHashSet<CAstEntity> newEntities = new LinkedHashSet<CAstEntity>();
            newChildren.put(key, newEntities);
            Iterator<CAstEntity> oldEntities = entry.getValue().iterator();
            while (oldEntities.hasNext()) {
                newEntities.add(this.rewrite(oldEntities.next()));
            }
        }
        return newChildren;
    }

    public Rewrite rewrite(final CAstNode root, final CAstControlFlowMap cfg, final CAstSourcePositionMap pos, final CAstNodeTypeMap types, final Map<CAstNode, Collection<CAstEntity>> children) {
        final HashMap nodes = HashMapFactory.make();
        final CAstNode newRoot = this.copyNodes(root, cfg, this.rootContext, nodes);
        return new Rewrite(){
            private CAstControlFlowMap theCfg = null;
            private CAstSourcePositionMap theSource = null;
            private CAstNodeTypeMap theTypes = null;
            private Map<CAstNode, Collection<CAstEntity>> theChildren = null;

            @Override
            public CAstNode newRoot() {
                return newRoot;
            }

            @Override
            public CAstControlFlowMap newCfg() {
                if (this.theCfg == null) {
                    this.theCfg = CAstRewriter.this.copyFlow(nodes, cfg, this.newPos());
                }
                return this.theCfg;
            }

            @Override
            public CAstSourcePositionMap newPos() {
                if (this.theSource == null && pos != null) {
                    this.theSource = CAstRewriter.this.copySource(nodes, pos);
                }
                return this.theSource;
            }

            @Override
            public CAstNodeTypeMap newTypes() {
                if (this.theTypes == null) {
                    this.theTypes = CAstRewriter.this.copyTypes(nodes, types);
                }
                return this.theTypes;
            }

            @Override
            public Map<CAstNode, Collection<CAstEntity>> newChildren() {
                if (this.theChildren == null) {
                    this.theChildren = CAstRewriter.this.copyChildren(root, nodes, children);
                }
                return this.theChildren;
            }
        };
    }

    public CAstEntity rewrite(final CAstEntity root) {
        if (root.getAST() != null) {
            final Rewrite rewrite = this.rewrite(root.getAST(), root.getControlFlow(), root.getSourceMap(), root.getNodeTypeMap(), root.getAllScopedEntities());
            return new DelegatingEntity(root){

                public String toString() {
                    return String.valueOf(root.toString()) + " (clone)";
                }

                @Override
                public Iterator<CAstEntity> getScopedEntities(CAstNode construct) {
                    Map<CAstNode, Collection<CAstEntity>> newChildren = this.getAllScopedEntities();
                    if (newChildren.containsKey(construct)) {
                        return newChildren.get(construct).iterator();
                    }
                    return EmptyIterator.instance();
                }

                @Override
                public Map<CAstNode, Collection<CAstEntity>> getAllScopedEntities() {
                    return rewrite.newChildren();
                }

                @Override
                public CAstNode getAST() {
                    return rewrite.newRoot();
                }

                @Override
                public CAstNodeTypeMap getNodeTypeMap() {
                    return rewrite.newTypes();
                }

                @Override
                public CAstSourcePositionMap getSourceMap() {
                    return rewrite.newPos();
                }

                @Override
                public CAstControlFlowMap getControlFlow() {
                    return rewrite.newCfg();
                }
            };
        }
        if (this.recursive) {
            Map<CAstNode, Collection<CAstEntity>> children = root.getAllScopedEntities();
            final LinkedHashMap newChildren = new LinkedHashMap();
            for (Map.Entry<CAstNode, Collection<CAstEntity>> entry : children.entrySet()) {
                CAstNode key = entry.getKey();
                LinkedHashSet<CAstEntity> newValues = new LinkedHashSet<CAstEntity>();
                newChildren.put(key, newValues);
                Iterator<CAstEntity> es = entry.getValue().iterator();
                while (es.hasNext()) {
                    newValues.add(this.rewrite(es.next()));
                }
            }
            return new DelegatingEntity(root){

                public String toString() {
                    return String.valueOf(root.toString()) + " (clone)";
                }

                @Override
                public Iterator<CAstEntity> getScopedEntities(CAstNode construct) {
                    if (newChildren.containsKey(construct)) {
                        return ((Collection)newChildren.get(construct)).iterator();
                    }
                    return EmptyIterator.instance();
                }

                @Override
                public Map<CAstNode, Collection<CAstEntity>> getAllScopedEntities() {
                    return newChildren;
                }
            };
        }
        return root;
    }

    public static interface CopyKey<Self extends CopyKey> {
        public int hashCode();

        public boolean equals(Object var1);

        public Self parent();
    }

    public static interface Rewrite {
        public CAstNode newRoot();

        public CAstControlFlowMap newCfg();

        public CAstSourcePositionMap newPos();

        public CAstNodeTypeMap newTypes();

        public Map<CAstNode, Collection<CAstEntity>> newChildren();
    }

    public static interface RewriteContext<K extends CopyKey> {
        public K key();
    }
}

