/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.loader;

import com.ibm.wala.cast.ir.translator.TranslatorToCAst;
import com.ibm.wala.cast.ir.translator.TranslatorToIR;
import com.ibm.wala.cast.loader.CAstAbstractLoader;
import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.impl.CAstImpl;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.SourceFileModule;
import com.ibm.wala.classLoader.SourceModule;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.io.TemporaryFile;
import com.ibm.wala.util.warnings.Warning;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class CAstAbstractModuleLoader
extends CAstAbstractLoader {
    private static final boolean DEBUG = false;

    public CAstAbstractModuleLoader(IClassHierarchy cha, IClassLoader parent) {
        super(cha, parent);
    }

    public CAstAbstractModuleLoader(IClassHierarchy cha) {
        this(cha, null);
    }

    protected abstract TranslatorToCAst getTranslatorToCAst(CAst var1, ModuleEntry var2) throws IOException;

    protected abstract boolean shouldTranslate(CAstEntity var1);

    protected abstract TranslatorToIR initTranslator();

    protected File getLocalFile(SourceModule M) throws IOException {
        if (M instanceof SourceFileModule) {
            return ((SourceFileModule)M).getFile();
        }
        File f = File.createTempFile("module", ".txt");
        f.deleteOnExit();
        TemporaryFile.streamToFile((File)f, (InputStream[])new InputStream[]{M.getInputStream()});
        return f;
    }

    protected void finishTranslation() {
    }

    public void init(List<Module> modules) {
        CAstImpl ast = new CAstImpl();
        LinkedHashSet<Pair<CAstEntity, ModuleEntry>> topLevelEntities = new LinkedHashSet<Pair<CAstEntity, ModuleEntry>>();
        Iterator<Module> mes = modules.iterator();
        while (mes.hasNext()) {
            this.translateModuleToCAst(mes.next(), ast, topLevelEntities);
        }
        TranslatorToIR xlatorToIR = this.initTranslator();
        for (Pair pair : topLevelEntities) {
            if (!this.shouldTranslate((CAstEntity)pair.fst)) continue;
            xlatorToIR.translate((CAstEntity)pair.fst, (ModuleEntry)pair.snd);
        }
        this.finishTranslation();
    }

    private void translateModuleEntryToCAst(ModuleEntry moduleEntry, CAst ast, Set<Pair<CAstEntity, ModuleEntry>> topLevelEntities) {
        try {
            if (moduleEntry.isModuleFile()) {
                this.translateModuleToCAst(moduleEntry.asModule(), ast, topLevelEntities);
            } else {
                TranslatorToCAst xlatorToCAst = this.getTranslatorToCAst(ast, moduleEntry);
                CAstEntity fileEntity = null;
                try {
                    fileEntity = xlatorToCAst.translateToCAst();
                    topLevelEntities.add((Pair<CAstEntity, ModuleEntry>)Pair.make((Object)fileEntity, (Object)moduleEntry));
                }
                catch (TranslatorToCAst.Error e) {
                    this.addMessage(moduleEntry, e.warning);
                }
            }
        }
        catch (IOException e) {
            this.addMessage(moduleEntry, new Warning(2){

                public String getMsg() {
                    return "I/O issue: " + e.getMessage();
                }
            });
        }
        catch (RuntimeException e) {
            final ByteArrayOutputStream s = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(s);
            e.printStackTrace(ps);
            this.addMessage(moduleEntry, new Warning(2){

                public String getMsg() {
                    return "Parsing issue: " + new String(s.toByteArray());
                }
            });
        }
    }

    private void translateModuleToCAst(Module module, CAst ast, Set<Pair<CAstEntity, ModuleEntry>> topLevelEntities) {
        Iterator mes = module.getEntries();
        while (mes.hasNext()) {
            this.translateModuleEntryToCAst((ModuleEntry)mes.next(), ast, topLevelEntities);
        }
    }
}

