/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.loader;

import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.types.AstMethodReference;
import com.ibm.wala.cast.types.AstTypeReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeCT.ClassConstants;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.strings.Atom;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;

public abstract class AstFunctionClass
implements IClass,
ClassConstants {
    private final IClassLoader loader;
    protected IMethod functionBody;
    private final CAstSourcePositionMap.Position sourcePosition;
    private final TypeReference reference;
    private final TypeReference superReference;

    protected AstFunctionClass(TypeReference reference, TypeReference superReference, IClassLoader loader, CAstSourcePositionMap.Position sourcePosition) {
        this.superReference = superReference;
        this.sourcePosition = sourcePosition;
        this.reference = reference;
        this.loader = loader;
    }

    protected AstFunctionClass(TypeReference reference, IClassLoader loader, CAstSourcePositionMap.Position sourcePosition) {
        this(reference, TypeReference.findOrCreate((ClassLoaderReference)reference.getClassLoader(), (TypeName)AstTypeReference.functionTypeName), loader, sourcePosition);
    }

    public String toString() {
        try {
            return "function " + this.functionBody.getReference().getDeclaringClass().getName();
        }
        catch (NullPointerException nullPointerException) {
            return "<need to set code body>";
        }
    }

    public IClassLoader getClassLoader() {
        return this.loader;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAbstract() {
        return this.functionBody == null;
    }

    public boolean isPublic() {
        return true;
    }

    public boolean isPrivate() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }

    public int getModifiers() {
        return 1;
    }

    public IClass getSuperclass() {
        return this.loader.lookupClass(this.superReference.getName());
    }

    public Collection<IClass> getDirectInterfaces() {
        return Collections.emptySet();
    }

    public Collection<IClass> getAllImplementedInterfaces() {
        return Collections.emptySet();
    }

    public Collection<IClass> getAllAncestorInterfaces() {
        return Collections.emptySet();
    }

    public IMethod getMethod(Selector selector) {
        if (selector.equals((Object)AstMethodReference.fnSelector)) {
            return this.functionBody;
        }
        return this.loader.lookupClass(this.superReference.getName()).getMethod(selector);
    }

    public IField getField(Atom name) {
        return this.loader.lookupClass(this.superReference.getName()).getField(name);
    }

    public IField getField(Atom name, TypeName type) {
        return this.loader.lookupClass(this.superReference.getName()).getField(name);
    }

    public TypeReference getReference() {
        return this.reference;
    }

    public CAstSourcePositionMap.Position getSourcePosition() {
        return this.sourcePosition;
    }

    public URL getSourceURL() {
        return this.sourcePosition.getURL();
    }

    public String getSourceFileName() {
        return this.sourcePosition.getURL().getFile();
    }

    public Reader getSource() {
        return null;
    }

    public IMethod getClassInitializer() {
        return null;
    }

    public boolean isArrayClass() {
        return false;
    }

    public Collection<IMethod> getDeclaredMethods() {
        if (this.functionBody != null) {
            return Collections.singleton(this.functionBody);
        }
        throw new Error("function " + this.reference + " has no body!");
    }

    public Collection<IField> getDeclaredInstanceFields() {
        return Collections.emptySet();
    }

    public Collection<IField> getDeclaredStaticFields() {
        return Collections.emptySet();
    }

    public Collection<IField> getAllInstanceFields() {
        return Collections.emptySet();
    }

    public Collection<IField> getAllStaticFields() {
        return Collections.emptySet();
    }

    public Collection<IField> getAllFields() {
        return Collections.emptySet();
    }

    public Collection<IMethod> getAllMethods() {
        return Collections.singleton(this.functionBody);
    }

    public TypeName getName() {
        return this.reference.getName();
    }

    public boolean isReferenceType() {
        return true;
    }

    public IMethod getCodeBody() {
        return this.functionBody;
    }
}

