/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa;

import com.ibm.wala.cast.ir.ssa.AstInstructionFactory;
import com.ibm.wala.cast.ir.ssa.AstInstructionVisitor;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Collections;

public class AstEchoInstruction
extends SSAInstruction {
    private final int[] rvals;

    public AstEchoInstruction(int iindex, int[] rvals) {
        super(iindex);
        this.rvals = rvals;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        return ((AstInstructionFactory)insts).EchoInstruction(this.iindex, uses == null ? this.rvals : uses);
    }

    public int getNumberOfDefs() {
        return 0;
    }

    public int getDef(int i) {
        Assertions.UNREACHABLE();
        return -1;
    }

    public int getNumberOfUses() {
        return this.rvals.length;
    }

    public int getUse(int i) {
        return this.rvals[i];
    }

    public int hashCode() {
        int v = 1;
        int i = 0;
        while (i < this.rvals.length) {
            v *= this.rvals[i];
            ++i;
        }
        return v;
    }

    public String toString(SymbolTable symbolTable) {
        StringBuffer result = new StringBuffer("echo/print ");
        int i = 0;
        while (i < this.rvals.length) {
            result.append(this.getValueString(symbolTable, this.rvals[i])).append(" ");
            ++i;
        }
        return result.toString();
    }

    public void visit(SSAInstruction.IVisitor v) {
        ((AstInstructionVisitor)v).visitEcho(this);
    }

    public boolean isFallThrough() {
        return true;
    }

    public Collection<TypeReference> getExceptionTypes() {
        return Collections.emptySet();
    }
}

