/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa;

import com.ibm.wala.cast.ir.cfg.Util;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.util.collections.ArrayIterator;
import com.ibm.wala.util.collections.IntStack;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.dominators.DominanceFrontiers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractSSAConversion {
    protected final SSACFG CFG;
    protected final DominanceFrontiers<ISSABasicBlock> DF;
    private final Graph<ISSABasicBlock> dominatorTree;
    protected final int[] phiCounts;
    protected final SSAInstruction[] instructions;
    private final int[] flags;
    protected final SymbolTable symbolTable;
    protected final SSAOptions.DefaultValues defaultValues;
    protected IntStack[] S;
    protected int[] C;
    protected int[] valueMap;
    private Set<SSACFG.BasicBlock>[] assignmentMap;

    protected abstract int getNumberOfDefs(SSAInstruction var1);

    protected abstract int getDef(SSAInstruction var1, int var2);

    protected abstract int getNumberOfUses(SSAInstruction var1);

    protected abstract int getUse(SSAInstruction var1, int var2);

    protected abstract boolean isAssignInstruction(SSAInstruction var1);

    protected abstract int getMaxValueNumber();

    protected abstract boolean isLive(SSACFG.BasicBlock var1, int var2);

    protected abstract boolean skip(int var1);

    protected abstract boolean isConstant(int var1);

    protected abstract int getNextNewValueNumber();

    protected abstract void initializeVariables();

    protected abstract void repairExit();

    protected abstract void placeNewPhiAt(int var1, SSACFG.BasicBlock var2);

    protected abstract SSAPhiInstruction getPhi(SSACFG.BasicBlock var1, int var2);

    protected abstract void setPhi(SSACFG.BasicBlock var1, int var2, SSAPhiInstruction var3);

    protected abstract SSAPhiInstruction repairPhiDefs(SSAPhiInstruction var1, int[] var2);

    protected abstract void repairPhiUse(SSACFG.BasicBlock var1, int var2, int var3, int var4);

    protected abstract void repairInstructionUses(SSAInstruction var1, int var2, int[] var3);

    protected abstract void repairInstructionDefs(SSAInstruction var1, int var2, int[] var3, int[] var4);

    protected abstract void pushAssignment(SSAInstruction var1, int var2, int var3);

    protected abstract void popAssignment(SSAInstruction var1, int var2);

    protected AbstractSSAConversion(IR ir, SSAOptions options) {
        this.CFG = ir.getControlFlowGraph();
        this.DF = new DominanceFrontiers((Graph)ir.getControlFlowGraph(), (Object)ir.getControlFlowGraph().entry());
        this.dominatorTree = this.DF.dominatorTree();
        this.flags = new int[2 * ir.getControlFlowGraph().getNumberOfNodes()];
        this.instructions = this.getInstructions(ir);
        this.phiCounts = new int[this.CFG.getNumberOfNodes()];
        this.symbolTable = ir.getSymbolTable();
        this.defaultValues = options.getDefaultValues();
    }

    protected void perform() {
        this.init();
        this.placePhiNodes();
        this.renameVariables();
    }

    protected SSAInstruction[] getInstructions(IR ir) {
        return ir.getInstructions();
    }

    protected final Iterator<SSAInstruction> iterateInstructions(IR ir) {
        return new ArrayIterator((Object[])this.getInstructions(ir));
    }

    protected void init() {
        this.S = new IntStack[this.getMaxValueNumber() + 1];
        this.C = new int[this.getMaxValueNumber() + 1];
        this.valueMap = new int[this.getMaxValueNumber() + 1];
        this.makeAssignmentMap();
    }

    private void makeAssignmentMap() {
        this.assignmentMap = new Set[this.getMaxValueNumber() + 1];
        for (SSACFG.BasicBlock BB : this.CFG) {
            if (BB.getFirstInstructionIndex() < 0) continue;
            for (SSAInstruction inst : BB) {
                if (inst == null) continue;
                int j = 0;
                while (j < this.getNumberOfDefs(inst)) {
                    this.addDefiningBlock(this.assignmentMap, BB, this.getDef(inst, j));
                    ++j;
                }
            }
        }
    }

    private void addDefiningBlock(Set<SSACFG.BasicBlock>[] A, SSACFG.BasicBlock BB, int i) {
        if (!this.skip(i)) {
            if (A[i] == null) {
                A[i] = new LinkedHashSet<SSACFG.BasicBlock>(2);
            }
            A[i].add(BB);
        }
    }

    protected void placePhiNodes() {
        int IterCount = 0;
        for (SSACFG.BasicBlock X : this.CFG) {
            this.setHasAlready(X, 0);
            this.setWork(X, 0);
        }
        LinkedHashSet<SSACFG.BasicBlock> W = new LinkedHashSet<SSACFG.BasicBlock>();
        int V = 0;
        while (V < this.assignmentMap.length) {
            if (this.assignmentMap[V] != null && !this.skip(V)) {
                ++IterCount;
                for (SSACFG.BasicBlock X : this.assignmentMap[V]) {
                    this.setWork(X, IterCount);
                    W.add(X);
                }
                while (!W.isEmpty()) {
                    SSACFG.BasicBlock X = (SSACFG.BasicBlock)W.iterator().next();
                    W.remove(X);
                    Iterator YS = this.DF.getDominanceFrontier((Object)X);
                    while (YS.hasNext()) {
                        SSACFG.BasicBlock Y = (SSACFG.BasicBlock)YS.next();
                        if (this.getHasAlready(Y) >= IterCount) continue;
                        if (this.isLive(Y, V)) {
                            this.placeNewPhiAt(V, Y);
                            int n = Y.getGraphNodeId();
                            this.phiCounts[n] = this.phiCounts[n] + 1;
                        }
                        this.setHasAlready(Y, IterCount);
                        if (this.getWork(Y) >= IterCount) continue;
                        this.setWork(Y, IterCount);
                        W.add(Y);
                    }
                }
            }
            ++V;
        }
    }

    private int getWork(SSACFG.BasicBlock BB) {
        return this.flags[BB.getGraphNodeId() * 2 + 1];
    }

    private void setWork(SSACFG.BasicBlock BB, int v) {
        this.flags[BB.getGraphNodeId() * 2 + 1] = v;
    }

    private int getHasAlready(SSACFG.BasicBlock BB) {
        return this.flags[BB.getGraphNodeId() * 2];
    }

    private void setHasAlready(SSACFG.BasicBlock BB, int v) {
        this.flags[BB.getGraphNodeId() * 2] = v;
    }

    private void renameVariables() {
        int V = 1;
        while (V <= this.getMaxValueNumber()) {
            if (!this.skip(V)) {
                this.C[V] = 0;
                this.S[V] = new IntStack();
            }
            ++V;
        }
        this.initializeVariables();
        this.SEARCH(this.CFG.entry());
    }

    private void SEARCH(SSACFG.BasicBlock X) {
        ArrayList stack = new ArrayList();
        this.SearchPreRec(X);
        this.push(stack, new Frame(X, this.dominatorTree.getSuccNodes((Object)X)));
        while (!stack.isEmpty()) {
            Frame f = (Frame)this.peek(stack);
            if (f.i.hasNext()) {
                SSACFG.BasicBlock next = (SSACFG.BasicBlock)f.i.next();
                this.SearchPreRec(next);
                this.push(stack, new Frame(next, this.dominatorTree.getSuccNodes((Object)next)));
                continue;
            }
            this.SearchPostRec(f.X);
            this.pop(stack);
        }
    }

    private <T> void push(ArrayList<T> stack, T elt) {
        stack.add(elt);
    }

    private <T> T peek(ArrayList<T> stack) {
        return stack.get(stack.size() - 1);
    }

    private <T> T pop(ArrayList<T> stack) {
        T e = stack.get(stack.size() - 1);
        stack.remove(stack.size() - 1);
        return e;
    }

    private void SearchPreRec(SSACFG.BasicBlock X) {
        int id = X.getGraphNodeId();
        int Xf = X.getFirstInstructionIndex();
        int i = 0;
        while (i < this.phiCounts[id]) {
            SSAPhiInstruction phi = this.getPhi(X, i);
            if (!this.skipRepair((SSAInstruction)phi, -1)) {
                this.setPhi(X, i, this.repairPhiDefs(phi, this.makeNewDefs((SSAInstruction)phi)));
            }
            ++i;
        }
        i = Xf;
        while (i <= X.getLastInstructionIndex()) {
            SSAInstruction inst = this.instructions[i];
            if (this.isAssignInstruction(inst)) {
                int lhs = this.getDef(inst, 0);
                int rhs = this.getUse(inst, 0);
                int newRhs = this.skip(rhs) ? rhs : this.top(rhs);
                this.S[lhs].push(newRhs);
                this.pushAssignment(inst, i, newRhs);
            } else if (!this.skipRepair(inst, i)) {
                int[] newUses = this.makeNewUses(inst);
                this.repairInstructionUses(inst, i, newUses);
                int[] newDefs = this.makeNewDefs(inst);
                this.repairInstructionDefs(inst, i, newDefs, newUses);
            }
            ++i;
        }
        if (X.isExitBlock()) {
            this.repairExit();
        }
        Iterator YS = this.CFG.getSuccNodes((ISSABasicBlock)X);
        while (YS.hasNext()) {
            SSACFG.BasicBlock Y = (SSACFG.BasicBlock)YS.next();
            int Y_id = Y.getGraphNodeId();
            int j = Util.whichPred(this.CFG, Y, X);
            int i2 = 0;
            while (i2 < this.phiCounts[Y_id]) {
                SSAPhiInstruction phi = this.getPhi(Y, i2);
                int oldUse = this.getUse((SSAInstruction)phi, j);
                int newUse = this.skip(oldUse) ? oldUse : this.top(oldUse);
                this.repairPhiUse(Y, i2, j, newUse);
                ++i2;
            }
        }
    }

    private void SearchPostRec(SSACFG.BasicBlock X) {
        int j;
        SSAPhiInstruction A;
        int id = X.getGraphNodeId();
        int Xf = X.getFirstInstructionIndex();
        int i = 0;
        while (i < this.phiCounts[id]) {
            A = this.getPhi(X, i);
            j = 0;
            while (j < this.getNumberOfDefs((SSAInstruction)A)) {
                if (!this.skip(this.getDef((SSAInstruction)A, j))) {
                    this.S[this.valueMap[this.getDef((SSAInstruction)A, j)]].pop();
                }
                ++j;
            }
            ++i;
        }
        i = Xf;
        while (i <= X.getLastInstructionIndex()) {
            A = this.instructions[i];
            if (this.isAssignInstruction((SSAInstruction)A)) {
                this.S[this.getDef((SSAInstruction)A, 0)].pop();
                this.popAssignment((SSAInstruction)A, i);
            } else if (A != null) {
                j = 0;
                while (j < this.getNumberOfDefs((SSAInstruction)A)) {
                    if (!this.skip(this.getDef((SSAInstruction)A, j))) {
                        this.S[this.valueMap[this.getDef((SSAInstruction)A, j)]].pop();
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private int[] makeNewUses(SSAInstruction inst) {
        int[] newUses = new int[this.getNumberOfUses(inst)];
        int j = 0;
        while (j < this.getNumberOfUses(inst)) {
            newUses[j] = this.skip(this.getUse(inst, j)) ? this.getUse(inst, j) : this.top(this.getUse(inst, j));
            ++j;
        }
        return newUses;
    }

    private int[] makeNewDefs(SSAInstruction inst) {
        int[] newDefs = new int[this.getNumberOfDefs(inst)];
        int j = 0;
        while (j < this.getNumberOfDefs(inst)) {
            if (this.skip(this.getDef(inst, j))) {
                newDefs[j] = this.getDef(inst, j);
            } else {
                int ii = this.getNextNewValueNumber();
                if (this.valueMap.length <= ii) {
                    int[] nvm = new int[this.valueMap.length * 2 + ii + 1];
                    System.arraycopy(this.valueMap, 0, nvm, 0, this.valueMap.length);
                    this.valueMap = nvm;
                }
                this.valueMap[ii] = this.getDef(inst, j);
                this.S[this.getDef(inst, j)].push(ii);
                newDefs[j] = ii;
            }
            ++j;
        }
        return newDefs;
    }

    protected boolean skipRepair(SSAInstruction inst, int index) {
        if (inst == null) {
            return true;
        }
        int i = 0;
        while (i < this.getNumberOfDefs(inst)) {
            if (!this.skip(this.getDef(inst, i))) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.getNumberOfUses(inst)) {
            if (!this.skip(this.getUse(inst, i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void fail(int v) {
        assert (this.isConstant(v) || !this.S[v].isEmpty()) : "bad stack for " + v + " while SSA converting";
    }

    protected boolean hasDefaultValue(int valueNumber) {
        return this.defaultValues != null && this.defaultValues.getDefaultValue(this.symbolTable, valueNumber) != -1;
    }

    protected int getDefaultValue(int valueNumber) {
        return this.defaultValues.getDefaultValue(this.symbolTable, valueNumber);
    }

    protected int top(int v) {
        if (!this.isConstant(v) && this.S[v].isEmpty()) {
            if (this.hasDefaultValue(v)) {
                return this.getDefaultValue(v);
            }
            this.fail(v);
        }
        return this.isConstant(v) ? v : this.S[v].peek();
    }

    private static class Frame {
        public final SSACFG.BasicBlock X;
        public final Iterator<ISSABasicBlock> i;

        public Frame(SSACFG.BasicBlock X, Iterator<ISSABasicBlock> i) {
            this.X = X;
            this.i = i;
        }
    }
}

