/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.solvers;

import com.ibm.safe.Factoid;
import com.ibm.safe.ICFGSupergraph;
import com.ibm.wala.dataflow.IFDS.IFlowFunctionMap;
import com.ibm.wala.dataflow.IFDS.IMergeFunction;
import com.ibm.wala.dataflow.IFDS.PathEdge;
import com.ibm.wala.dataflow.IFDS.TabulationDomain;
import com.ibm.wala.dataflow.IFDS.TabulationProblem;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Collection;
import java.util.HashSet;

public abstract class ICFGTabulationProblem
implements TabulationProblem<BasicBlockInContext<IExplodedBasicBlock>, CGNode, Factoid> {
    protected final ICFGSupergraph supergraph;
    protected final TabulationDomain<Factoid, BasicBlockInContext<IExplodedBasicBlock>> domain;
    protected final IFlowFunctionMap<BasicBlockInContext<IExplodedBasicBlock>> functions;
    protected final IMergeFunction merge;

    public ICFGTabulationProblem(ICFGSupergraph supergraph, TabulationDomain<Factoid, BasicBlockInContext<IExplodedBasicBlock>> domain, IFlowFunctionMap<BasicBlockInContext<IExplodedBasicBlock>> functions, IMergeFunction merge) {
        this.supergraph = supergraph;
        this.domain = domain;
        this.functions = functions;
        this.merge = merge;
    }

    public ICFGSupergraph getSupergraph() {
        return this.supergraph;
    }

    public TabulationDomain<Factoid, BasicBlockInContext<IExplodedBasicBlock>> getDomain() {
        return this.domain;
    }

    public IFlowFunctionMap<BasicBlockInContext<IExplodedBasicBlock>> getFunctionMap() {
        return this.functions;
    }

    public IMergeFunction getMergeFunction() {
        return this.merge;
    }

    public Collection<PathEdge<BasicBlockInContext<IExplodedBasicBlock>>> initialSeeds() {
        HashSet entryBlocks = HashSetFactory.make();
        Collection entryNodes = this.supergraph.getICFG().getCallGraph().getEntrypointNodes();
        for (CGNode n : entryNodes) {
            BasicBlockInContext<IExplodedBasicBlock> entry = this.supergraph.getEntriesForProcedure(n)[0];
            entryBlocks.add(entry);
        }
        return this.initialSeeds(entryBlocks);
    }

    public Collection<PathEdge<BasicBlockInContext<IExplodedBasicBlock>>> initialSeeds(Collection<BasicBlockInContext<IExplodedBasicBlock>> entryPoints) {
        HashSet seeds = HashSetFactory.make();
        for (BasicBlockInContext<IExplodedBasicBlock> entryPoint : entryPoints) {
            PathEdge pe = PathEdge.createPathEdge(entryPoint, (int)0, entryPoint, (int)0);
            seeds.add(pe);
            IntIterator it = this.getReachableOnEntry().intIterator();
            while (it.hasNext()) {
                int i = it.next();
                if (i == 0) continue;
                seeds.add(PathEdge.createPathEdge(entryPoint, (int)0, entryPoint, (int)i));
            }
        }
        return seeds;
    }

    public SparseIntSet getReachableOnEntry() {
        return SparseIntSet.singleton((int)0);
    }
}

