/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.rules;

import com.ibm.safe.dfa.DFASpec;
import com.ibm.safe.dfa.DFAState;
import com.ibm.safe.dfa.DFATransition;
import com.ibm.safe.dfa.IDFAState;
import com.ibm.safe.dfa.IDFATransition;
import com.ibm.safe.dfa.events.IDispatchEventImpl;
import com.ibm.safe.dfa.events.IEvent;
import com.ibm.safe.dfa.events.IProgramExitEventImpl;
import com.ibm.safe.rules.RuleLevel;
import com.ibm.safe.rules.RuleSeverity;
import com.ibm.safe.rules.TypestateRule;
import java.util.ArrayList;
import java.util.HashSet;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypestateRuleParser {
    public static TypestateRule parseRule(Node node) {
        TypestateRule tr = new TypestateRule();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node curr = children.item(i);
            String nodeName = curr.getNodeName();
            if (nodeName.equals("automaton")) {
                tr.setTypeStateAutomaton(TypestateRuleParser.parseAutomaton(curr));
            } else if (nodeName.equals("type")) {
                String type = TypestateRuleParser.parseType(curr);
                tr.addType(type);
            } else if (nodeName.equals("attributes")) {
                NamedNodeMap attr = curr.getAttributes();
                Node name = attr.getNamedItem("name");
                Node severity = attr.getNamedItem("severity");
                Node level = attr.getNamedItem("level");
                if (name != null) {
                    tr.setName(name.getNodeValue());
                }
                if (severity != null) {
                    tr.setSeverity(RuleSeverity.getByName(severity.getNodeValue()));
                }
                if (level != null) {
                    tr.setLevel(RuleLevel.getByName(level.getNodeValue()));
                }
            }
            ++i;
        }
        if (tr.getTypes().isEmpty()) {
            throw new RuntimeException("No tracked type specified");
        }
        assert (tr.getName() != null);
        return tr;
    }

    public static DFASpec parseAutomaton(Node node) {
        DFASpec dfa = new DFASpec();
        HashSet<IDFAState> states = new HashSet<IDFAState>();
        HashSet<IEvent> events = new HashSet<IEvent>();
        HashSet<IDFATransition> transitions = new HashSet<IDFATransition>();
        IDFAState initial = null;
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node curr = children.item(i);
            String nodeName = curr.getNodeName();
            if (nodeName.equals("state")) {
                IDFAState state = TypestateRuleParser.parseState(curr);
                if (TypestateRuleParser.isInitialState(curr)) {
                    initial = state;
                }
                states.add(state);
            } else if (nodeName.equals("transition")) {
                IDFATransition t = TypestateRuleParser.parseTransition(curr);
                transitions.add(t);
            } else if (nodeName.equals("event")) {
                IEvent e = TypestateRuleParser.parseEvent(curr);
                events.add(e);
            }
            ++i;
        }
        if (initial == null) {
            throw new RuntimeException("no initial state found");
        }
        dfa.setInitialState(initial);
        for (IDFAState s : states) {
            dfa.addState(s);
        }
        for (IEvent e : events) {
            dfa.addEvent(e);
        }
        for (IDFATransition t : transitions) {
            dfa.addTransition(t);
        }
        return dfa;
    }

    private static String parseType(Node node) {
        NamedNodeMap attr = node.getAttributes();
        Node name = attr.getNamedItem("name");
        return name.getNodeValue();
    }

    private static IEvent parseEvent(Node node) {
        NamedNodeMap attr = node.getAttributes();
        Node type = attr.getNamedItem("type");
        Node name = attr.getNamedItem("name");
        ArrayList<String> patterns = new ArrayList<String>();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            NamedNodeMap currAtt;
            Node pat;
            String val;
            Node curr = children.item(i);
            if (curr.getNodeName().equals("pattern") && (val = (pat = (currAtt = curr.getAttributes()).getNamedItem("pattern")).getNodeValue()) != null) {
                patterns.add(val);
            }
            ++i;
        }
        if (type != null && type.getNodeValue() != null && type.getNodeValue().equals("IDispatchEvent")) {
            IDispatchEventImpl d = new IDispatchEventImpl();
            d.setName(name.getNodeValue());
            d.setPattern((String)patterns.get(0));
            return d;
        }
        if (type != null && type.getNodeValue() != null && type.getNodeValue().equals("IProgramExitEvent")) {
            IProgramExitEventImpl p = new IProgramExitEventImpl();
            return p;
        }
        throw new RuntimeException("Invalid event type: " + name + " type: " + type);
    }

    private static IDFATransition parseTransition(Node node) {
        NamedNodeMap attr = node.getAttributes();
        Node source = attr.getNamedItem("source");
        Node event = attr.getNamedItem("event");
        Node dest = attr.getNamedItem("destination");
        DFATransition t = new DFATransition();
        t.setSource(source.getNodeValue());
        t.setEvent(event.getNodeValue());
        t.setDestination(dest.getNodeValue());
        return t;
    }

    public static IDFAState parseState(Node node) {
        NamedNodeMap attr = node.getAttributes();
        Node stateName = attr.getNamedItem("name");
        Node accepting = attr.getNamedItem("accepting");
        DFAState state = new DFAState();
        String name = stateName.getNodeValue();
        if (accepting != null) {
            boolean isAccepting = Boolean.valueOf(accepting.getNodeValue());
            state.setAccepting(isAccepting);
        }
        state.setName(name);
        return state;
    }

    public static boolean isInitialState(Node node) {
        NamedNodeMap attr = node.getAttributes();
        Node initial = attr.getNamedItem("initial");
        return initial != null && Boolean.valueOf(initial.getNodeValue()) != false;
    }
}

