/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.rules;

import com.ibm.safe.rules.NamedValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class RuleSeverity
extends NamedValue {
    public static final int INFORMATION = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final RuleSeverity INFORMATION_LITERAL = new RuleSeverity(0, "Information", "Information");
    public static final RuleSeverity WARNING_LITERAL = new RuleSeverity(1, "Warning", "Warning");
    public static final RuleSeverity ERROR_LITERAL = new RuleSeverity(2, "Error", "Error");
    private static final RuleSeverity[] VALUES_ARRAY = new RuleSeverity[]{INFORMATION_LITERAL, WARNING_LITERAL, ERROR_LITERAL};
    public static final List<RuleSeverity> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static RuleSeverity get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RuleSeverity result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RuleSeverity getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RuleSeverity result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RuleSeverity get(int value) {
        switch (value) {
            case 0: {
                return INFORMATION_LITERAL;
            }
            case 1: {
                return WARNING_LITERAL;
            }
            case 2: {
                return ERROR_LITERAL;
            }
        }
        return null;
    }

    private RuleSeverity(int value, String name, String literal) {
        super(value, name, literal);
    }
}

