/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.reporting.message;

import com.ibm.safe.reporting.message.ClassLocation;
import com.ibm.safe.reporting.message.FieldLocation;
import com.ibm.safe.reporting.message.MethodLocation;
import com.ibm.safe.reporting.message.UnknownLocation;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;

public abstract class Location {
    public static final int UNKNOWN_LINE_NUMBER = -1;
    public static final int UNKNOWN_BYTECODE_INDEX = -1;
    public static final String UNKNOWN_METHOD = "unknown method";
    public static final String UNKNOWN_CLASS = "unknown class";
    public static final String UNKNOWN_FIELD = "unknown field";

    public static ClassLocation createClassLocation(String className, int line) {
        return new ClassLocation(className, line);
    }

    public static MethodLocation createMethodLocation(String signature, int lineNumber) {
        int dotIndex = signature.indexOf(46);
        if (dotIndex == -1) {
            throw new AssertionError((Object)("We could not extract class name from signature: " + signature));
        }
        return new MethodLocation(signature.substring(0, dotIndex), signature.substring(dotIndex + 1), lineNumber);
    }

    public static MethodLocation createMethodLocation(TypeName typeName, String selector) {
        return new MethodLocation(typeName.toString(), selector);
    }

    public static MethodLocation createMethodLocation(TypeName typeName, Selector selector, int lineNumber, int bcIndex) {
        return new MethodLocation(typeName.toString(), selector.toString(), lineNumber, bcIndex);
    }

    public static MethodLocation createMethodLocation(TypeName typeName, Selector selector, int lineNumber) {
        return new MethodLocation(typeName.toString(), selector.toString(), lineNumber);
    }

    public static FieldLocation createFieldLocation(TypeName typeName, String fieldName) {
        return new FieldLocation(typeName.toString(), fieldName);
    }

    public static UnknownLocation createUnknownLocation() {
        return UnknownLocation.location();
    }

    public abstract String getLocationClass();

    public String getSourceFileName() {
        int dollarIndex = this.getLocationClass().indexOf(36);
        String sourceFileName = dollarIndex != -1 ? this.getLocationClass().substring(0, dollarIndex) : this.getLocationClass();
        return sourceFileName.replace('.', '/').concat(".java");
    }

    public abstract String getByteCodeLocation();

    public abstract String getSourceLocation();

    public abstract int getLocationLineNumber();

    public abstract int getByteCodeIndex();

    public abstract Object getAdditionalInformation();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract boolean isFieldMember();

    public abstract boolean isMethodMember();
}

