/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.properties;

import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.properties.CommonProperties;
import com.ibm.safe.utils.SafeHome;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.CommandLine;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertiesManager {
    static final String PROPERTY_FILENAME = "safe.properties";
    private static final Map<String, IPropertyDescriptor> registry = HashMapFactory.make();
    private final Properties p;

    static {
        PropertiesManager.registerProperties(CommonProperties.Props.values());
    }

    PropertiesManager(Properties p) {
        this.p = p;
    }

    public PropertiesManager(PropertiesManager pm) {
        this.p = new Properties(pm.p);
    }

    protected PropertiesManager() {
        this.p = new Properties();
    }

    public static void registerProperties(IPropertyDescriptor[] props) {
        IPropertyDescriptor[] iPropertyDescriptorArray = props;
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor p = iPropertyDescriptorArray[n2];
            registry.put(p.getName(), p);
            ++n2;
        }
    }

    public boolean getBooleanValue(IPropertyDescriptor d) throws PropertiesException {
        String v;
        if (!d.getType().equals((Object)Type.BOOLEAN)) {
            Assertions.UNREACHABLE((String)("property " + d.getName() + " is not a boolean property"));
        }
        if ((v = this.p.getProperty(d.getName())) == null) {
            v = d.getDefaultAsString();
        }
        assert (v.equals("true") || v.equals("false"));
        return Boolean.valueOf(v);
    }

    public int getIntValue(IPropertyDescriptor d) throws PropertiesException {
        String v;
        if (!d.getType().equals((Object)Type.INT)) {
            Assertions.UNREACHABLE((String)("property " + d.getName() + " is not a boolean property"));
        }
        if ((v = this.p.getProperty(d.getName())) == null && (v = d.getDefaultAsString()) == null) {
            throw new PropertiesException("no known value for " + d.getName());
        }
        return Integer.valueOf(v);
    }

    public String getStringValue(IPropertyDescriptor d) throws PropertiesException {
        String result;
        if (!d.getType().equals((Object)Type.STRING)) {
            Assertions.UNREACHABLE((String)("property " + d.getName() + " is not a String property"));
        }
        if ((result = this.p.getProperty(d.getName())) == null) {
            return d.getDefaultAsString();
        }
        return result;
    }

    public String getPathValue(IPropertyDescriptor d) throws PropertiesException {
        String result;
        if (!d.getType().equals((Object)Type.PATH)) {
            Assertions.UNREACHABLE((String)("property " + d.getName() + " is not a Path property"));
        }
        if ((result = this.p.getProperty(d.getName())) == null && (result = d.getDefaultAsString()) == null) {
            return null;
        }
        try {
            return PropertiesManager.resolveDelimitedPath(result);
        }
        catch (WalaException e) {
            throw new PropertiesException(e.getMessage());
        }
    }

    public void setBooleanValue(String key, boolean val) throws PropertiesException {
        IPropertyDescriptor d = registry.get(key);
        if (d == null) {
            throw new PropertiesException("unknown option : -" + key);
        }
        if (!d.getType().equals((Object)Type.BOOLEAN)) {
            throw new PropertiesException("property " + d.getName() + " is not a boolean property");
        }
        this.p.put(key, String.valueOf(val));
    }

    public void setIntValue(String key, int val) throws PropertiesException {
        IPropertyDescriptor d = registry.get(key);
        if (d == null) {
            throw new PropertiesException("unknown option : -" + key);
        }
        if (!d.getType().equals((Object)Type.INT)) {
            throw new PropertiesException("property " + d.getName() + " is not an int property");
        }
        this.p.put(key, String.valueOf(val));
    }

    public void setStringValue(String key, String val) throws PropertiesException {
        IPropertyDescriptor d = registry.get(key);
        if (d == null) {
            throw new PropertiesException("unknown option : -" + key);
        }
        if (!d.getType().equals((Object)Type.STRING)) {
            throw new PropertiesException("property " + d.getName() + " is not a String property");
        }
        if (val == null) {
            throw new PropertiesException("new String value for " + d.getName() + " should not be null");
        }
        this.p.put(key, val);
    }

    public void setPathValue(String key, String val) throws PropertiesException {
        IPropertyDescriptor d = registry.get(key);
        if (d == null) {
            throw new PropertiesException("unknown option : -" + key);
        }
        if (!d.getType().equals((Object)Type.PATH)) {
            throw new PropertiesException("property " + d.getName() + " is not a Path property");
        }
        if (val == null) {
            throw new PropertiesException("new String value for " + d.getName() + " should not be null");
        }
        try {
            PropertiesManager.resolveDelimitedPath(val);
        }
        catch (WalaException e) {
            throw new PropertiesException(e.getMessage());
        }
        this.p.put(key, val);
    }

    private static Properties loadPropertiesFromFile() throws PropertiesException {
        try {
            Properties result = WalaProperties.loadPropertiesFromFile((ClassLoader)PropertiesManager.class.getClassLoader(), (String)PROPERTY_FILENAME);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PropertiesException("Unable to set up safe properties ", e);
        }
    }

    public static PropertiesManager initFromCommandLine(String[] args) throws PropertiesException, WalaException {
        Properties p = PropertiesManager.loadPropertiesFromFile();
        Properties cmd = CommandLine.parse((String[])args);
        for (Object key : cmd.keySet()) {
            String s = (String)key;
            IPropertyDescriptor d = registry.get(s);
            if (d == null) {
                throw new PropertiesException("unknown command-line option : -" + s);
            }
            if (!d.isCommandLineOption()) {
                throw new PropertiesException("forbidden command-line option : -" + s);
            }
            p.put(s, cmd.getProperty(s));
        }
        return new PropertiesManager(p);
    }

    public static PropertiesManager initFromMap(Map<String, String> options) throws PropertiesException {
        Properties p = PropertiesManager.loadPropertiesFromFile();
        for (String key : options.keySet()) {
            IPropertyDescriptor d = registry.get(key);
            if (d == null) {
                throw new PropertiesException("unknown option : -" + key);
            }
            p.put(key, options.get(key));
        }
        return new PropertiesManager(p);
    }

    private static String resolveDelimitedPath(String pathValue) throws WalaException {
        StringBuffer result = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(pathValue, ";");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            result.append(PropertiesManager.resolvePath(token));
            if (!tokenizer.hasMoreTokens()) continue;
            result.append(";");
        }
        return result.toString();
    }

    private static String resolvePath(String pathValue) throws WalaException {
        File fileToCheck;
        File file = new File(pathValue);
        String path = file.isAbsolute() ? file.getPath() : SafeHome.getSafeHomeDir(PropertiesManager.class.getClassLoader()).concat(File.separator).concat(pathValue);
        File targetPath = new File(path);
        File file2 = fileToCheck = targetPath.isDirectory() ? targetPath : targetPath.getParentFile();
        if (fileToCheck != null && !fileToCheck.exists() && !fileToCheck.mkdirs()) {
            throw new WalaException("Could not resolve path " + path);
        }
        return targetPath.getPath();
    }

    public static interface IPropertyDescriptor {
        public String getName();

        public String getDefaultAsString();

        public boolean isCommandLineOption();

        public String getDescription();

        public Type getType();
    }

    public static enum Type {
        STRING,
        INT,
        BOOLEAN,
        PATH;

    }
}

